/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Airtaksa;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Taksainterniracun;
import rs.pezar.globals.TipDokumentConfig;

@Entity
@Table(name="InterniRacun")
public class Interniracun
extends PzDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    private int idDok;
    @Column(nullable=false)
    private short arhiviran;
    @Column(nullable=false)
    private short cvProdajna;
    private BigDecimal cvProdajnaUkupno = new BigDecimal(0);
    private Date datArh;
    @Column(nullable=false)
    private Date datum;
    @Column(length=255)
    private String oznDokumenta;
    @Column(length=30)
    private String podTip;
    @Column(nullable=false)
    private BigDecimal pdvIznos = new BigDecimal(0);
    private BigDecimal pdvIznos2 = new BigDecimal(0);
    @Column(nullable=false)
    private double procRabata;
    @Column(nullable=false)
    private short proknjizen;
    private BigDecimal razlika = new BigDecimal(0);
    @Column(length=5000)
    private String poruka;
    @Column(nullable=false)
    private int rbrDok;
    @Column(nullable=false)
    private int rBroj;
    @Column(nullable=false, length=255)
    private String rjIzlaz;
    @Column(nullable=false, length=255)
    private String rjUlaz;
    @Column(nullable=false)
    private int storno;
    private BigDecimal stornoIznos = new BigDecimal(0);
    @Column(nullable=false, length=255)
    private String tip;
    @Column(nullable=false)
    private BigDecimal vredNaIzlazu = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal vredNaUlazu = new BigDecimal(0);
    @Transient
    private String vrsta = "N";
    @OneToMany(mappedBy="interniracun", cascade={CascadeType.ALL})
    @OrderBy(value="sort ASC")
    @PrivateOwned
    private List<Artikalinterniracun> artikalinterniracuns;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="ulazniOgranak", referencedColumnName="OZNOGRANAK", nullable=false), @JoinColumn(name="ulaznaRJ", referencedColumnName="OZNRJ", nullable=false)})
    private Radnajedinica ulaznaRJ;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Dokument dokument1;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="idDok1", nullable=false)
    private Dokument dokument2;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="izlazniOgranak", referencedColumnName="OZNOGRANAK", nullable=false), @JoinColumn(name="izlaznaRJ", referencedColumnName="OZNRJ", nullable=false)})
    private Radnajedinica izlaznaRJ;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamepoc", nullable=false)
    private Pzuser userPoc;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usernamekraj", nullable=false)
    private Pzuser userKraj;
    @OneToMany(mappedBy="interniracun", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<Taksainterniracun> taksainterniracuns;

    @Override
    public int getIdDok() {
        return this.idDok;
    }

    @Override
    public void setIdDok(int idDok) {
        this.idDok = idDok;
    }

    @Override
    public short getArhiviran() {
        return this.arhiviran;
    }

    @Override
    public void setArhiviran(short arhiviran) {
        this.arhiviran = arhiviran;
    }

    @Override
    public short getCvProdajna() {
        return this.cvProdajna;
    }

    @Override
    public void setCvProdajna(short cvProdajna) {
        this.cvProdajna = cvProdajna;
    }

    @Override
    public Date getDatArh() {
        return this.datArh;
    }

    @Override
    public void setDatArh(Date datArh) {
        this.datArh = datArh;
    }

    @Override
    public Date getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Date datum) {
        this.datum = datum;
    }

    @Override
    public String getOznDokumenta() {
        return this.oznDokumenta;
    }

    @Override
    public void setOznDokumenta(String oznDokumenta) {
        this.oznDokumenta = oznDokumenta;
    }

    @Override
    public String getPodTip() {
        return this.podTip;
    }

    @Override
    public void setPodTip(String podTip) {
        this.podTip = podTip;
    }

    public BigDecimal getPdvIznos() {
        return this.pdvIznos;
    }

    public void setPdvIznos(BigDecimal pdvIznos) {
        this.pdvIznos = pdvIznos;
    }

    public BigDecimal getPdvIznos2() {
        return this.pdvIznos2;
    }

    public void setPdvIznos2(BigDecimal pdvIznos2) {
        this.pdvIznos2 = pdvIznos2;
    }

    public double getProcRabata() {
        return this.procRabata;
    }

    public void setProcRabata(double procRabata) {
        this.procRabata = procRabata;
    }

    @Override
    public short getProknjizen() {
        return this.proknjizen;
    }

    @Override
    public void setProknjizen(short proknjizen) {
        this.proknjizen = proknjizen;
    }

    public BigDecimal getRazlika() {
        return this.razlika;
    }

    public void setRazlika(BigDecimal razlika) {
        this.razlika = razlika;
    }

    public String getPoruka() {
        return this.poruka;
    }

    public void setPoruka(String razlogIzrade) {
        this.poruka = razlogIzrade;
    }

    @Override
    public int getRbrDok() {
        return this.rbrDok;
    }

    @Override
    public void setRbrDok(int rbrDok) {
        this.rbrDok = rbrDok;
    }

    @Override
    public int getrBroj() {
        return this.rBroj;
    }

    @Override
    public void setrBroj(int rBroj) {
        this.rBroj = rBroj;
    }

    public String getRjIzlaz() {
        return this.rjIzlaz;
    }

    public void setRjIzlaz(String rjIzlaz) {
        this.rjIzlaz = rjIzlaz;
    }

    public String getRjUlaz() {
        return this.rjUlaz;
    }

    public void setRjUlaz(String rjUlaz) {
        this.rjUlaz = rjUlaz;
    }

    @Override
    public int getStorno() {
        return this.storno;
    }

    @Override
    public void setStorno(int storno) {
        this.storno = storno;
    }

    @Override
    public void setStornoIznos(BigDecimal stornoIznos) {
        this.stornoIznos = stornoIznos;
    }

    @Override
    public BigDecimal getStornoIznos() {
        return this.stornoIznos;
    }

    @Override
    public String getTip() {
        return this.tip;
    }

    @Override
    public void setTip(String tip) {
        this.tip = tip;
    }

    public BigDecimal getVredNaIzlazu() {
        return this.vredNaIzlazu;
    }

    public void setVredNaIzlazu(BigDecimal vredNaIzlazu) {
        this.vredNaIzlazu = vredNaIzlazu;
    }

    public BigDecimal getVredNaUlazu() {
        return this.vredNaUlazu;
    }

    public void setVredNaUlazu(BigDecimal vredNaUlazu) {
        this.vredNaUlazu = vredNaUlazu;
    }

    @Override
    public String getVrsta() {
        return this.vrsta;
    }

    @Override
    public void setVrsta(String vrsta) {
        this.vrsta = vrsta;
    }

    public List<Artikalinterniracun> getArtikalinterniracuns() {
        return this.artikalinterniracuns;
    }

    public void setArtikalinterniracuns(List<Artikalinterniracun> artikalinterniracuns) {
        this.artikalinterniracuns = artikalinterniracuns;
    }

    public Radnajedinica getUlaznaRJ() {
        return this.ulaznaRJ;
    }

    public void setUlaznaRJ(Radnajedinica radnajedinica1) {
        this.ulaznaRJ = radnajedinica1;
    }

    public Dokument getDokument1() {
        return this.dokument1;
    }

    public void setDokument1(Dokument dokument1) {
        this.dokument1 = dokument1;
    }

    public Dokument getDokument2() {
        return this.dokument2;
    }

    public void setDokument2(Dokument dokument2) {
        this.dokument2 = dokument2;
    }

    public Radnajedinica getIzlaznaRJ() {
        return this.izlaznaRJ;
    }

    public void setIzlaznaRJ(Radnajedinica radnajedinica2) {
        this.izlaznaRJ = radnajedinica2;
    }

    @Override
    public Pzuser getUserPoc() {
        return this.userPoc;
    }

    @Override
    public void setUserPoc(Pzuser pzuser) {
        this.userPoc = pzuser;
    }

    @Override
    public Pzuser getUserKraj() {
        return this.userKraj;
    }

    @Override
    public void setUserKraj(Pzuser pzuser) {
        this.userKraj = pzuser;
    }

    public List<Taksainterniracun> getTaksainterniracuns() {
        return this.taksainterniracuns;
    }

    public void setTaksainterniracuns(List<Taksainterniracun> taksainterniracuns) {
        this.taksainterniracuns = taksainterniracuns;
    }

    public List<Taksainterniracun> getTaksainterniracunsU() {
        IndirectList lista = new IndirectList();
        for (Taksainterniracun taksa : this.taksainterniracuns) {
            if (!taksa.getId().getTip().equals("U")) continue;
            lista.add(taksa);
        }
        return lista;
    }

    public List<Taksainterniracun> getTaksainterniracunsI() {
        IndirectList lista = new IndirectList();
        for (Taksainterniracun taksa : this.taksainterniracuns) {
            if (!taksa.getId().getTip().equals("I")) continue;
            lista.add(taksa);
        }
        return lista;
    }

    public List<Taksainterniracun> getTaksainterniracunsUK() {
        IndirectList lista = new IndirectList();
        for (Taksainterniracun taksa : this.taksainterniracuns) {
            if (!taksa.getId().getTip().equals("UK")) continue;
            lista.add(taksa);
        }
        return lista;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Br. dokumenta", "Datum dok.", "Iznos na ulazu", "Tip", "Izlazna RJ", "Ulazna RJ"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getrBroj(), this.datum, this.vredNaUlazu, this.getTip(), String.valueOf(this.izlaznaRJ.getId().getOznRj()) + " - " + this.izlaznaRJ.getNaziv(), String.valueOf(this.ulaznaRJ.getId().getOznRj()) + " - " + this.ulaznaRJ.getNaziv()};
    }

    @Override
    public String[] getDokColumnNames() {
        if (this.tip != null) {
            if (this.tip.equals("PRIMO_PREDAJNICA")) {
                if (this.izlaznaRJ.getgTip().charAt(0) == 'V') {
                    return new String[]{"Dokument", "Datum", "Vred. izlazni magacin", "Vred. ulazni magacin", "Razlika u ceni", "Cena u velikoprodaji", "Dokument arhivirao"};
                }
                return new String[]{"Dokument", "Datum", "Izlazna prod.", "Ukalk. PDV-izlaz", "Ulazna prod.", "Ukalk. PDV-ulaz", "Razlika u ceni", "Dokument arhivirao"};
            }
            if (this.tip.equals("ZADUZENJE_NASE_KONSIGNACIJE")) {
                return new String[]{"Dokument", "Datum", "Ulazni magacin", "Izlazni magacin", "Razlika u ceni", "Prodajna vrednost", "iddok", "rjUlaz", "rjIzlaz", "Dokument arhivirao"};
            }
            if (this.tip.equals("POVRATNICA_SA_NASE_KONS")) {
                return new String[]{"Dokument", "Datum", "Ulazni magacin", "Izlazni magacin", "Razlika u ceni", "Prodajna vrednost", "iddok", "rjUlaz", "rjIzlaz", "Dokument arhivirao"};
            }
            if (this.tip.equals("POVRATNICA")) {
                return new String[]{"Dokument", "Datum", "Vred. prodavnica", "Razlika u ceni", "Ukalk. PDV", "Vred. magacin", "iddok", "rjUlaz", "rjIzlaz", "Dokument arhivirao"};
            }
            return new String[]{"Dokument", "Datum", "Vred. magacin", "Razlika u ceni", "Ukalk. PDV", "Vred. prodavnica", "iddok", "rjUlaz", "rjIzlaz", "Dokument arhivirao"};
        }
        return null;
    }

    @Override
    public Object[] getDokValues() {
        if (this.tip.equals("PRIMO_PREDAJNICA")) {
            if (this.izlaznaRJ.getgTip().equals("V")) {
                String vrCena = "";
                vrCena = this.cvProdajna == 1 ? "Prodajna" : "Prosecna nabavna";
                return new Object[]{String.valueOf(this.izlaznaRJ.getId().getOznRj()) + "-" + this.ulaznaRJ.getId().getOznRj() + "/" + PzEntityUtil.strZero("" + this.getrBroj(), 5), this.datum, this.vredNaIzlazu, this.vredNaUlazu, this.vredNaUlazu.subtract(this.vredNaIzlazu), vrCena};
            }
            return new Object[]{String.valueOf(this.izlaznaRJ.getId().getOznRj()) + "-" + this.ulaznaRJ.getId().getOznRj() + "/" + PzEntityUtil.strZero("" + this.getrBroj(), 5), this.datum, this.vredNaIzlazu, this.pdvIznos2, this.vredNaUlazu, this.pdvIznos, this.vredNaUlazu.subtract(this.vredNaIzlazu).add(this.pdvIznos2).subtract(this.pdvIznos)};
        }
        if (this.tip.equals("ZADUZENJE_NASE_KONSIGNACIJE")) {
            return new Object[]{String.valueOf(this.izlaznaRJ.getId().getOznRj()) + "-" + this.ulaznaRJ.getId().getOznRj() + "/" + PzEntityUtil.strZero("" + this.getrBroj(), 5), this.datum, this.vredNaUlazu, this.vredNaIzlazu, this.vredNaUlazu.subtract(this.vredNaIzlazu), this.vredNaUlazu};
        }
        if (this.tip.equals("POVRATNICA_SA_NASE_KONS")) {
            return new Object[]{String.valueOf(this.izlaznaRJ.getId().getOznRj()) + "-" + this.ulaznaRJ.getId().getOznRj() + "/" + PzEntityUtil.strZero("" + this.getrBroj(), 5), this.datum, this.vredNaUlazu, this.vredNaIzlazu, this.vredNaUlazu.subtract(this.vredNaIzlazu), this.vredNaUlazu};
        }
        if (this.tip.equals("POVRATNICA")) {
            return new Object[]{String.valueOf(this.izlaznaRJ.getId().getOznRj()) + "-" + this.ulaznaRJ.getId().getOznRj() + "/" + PzEntityUtil.strZero("" + this.getrBroj(), 5), this.datum, this.vredNaIzlazu, this.vredNaUlazu.subtract(this.pdvIznos).subtract(this.vredNaIzlazu), this.pdvIznos, this.vredNaUlazu};
        }
        return new Object[]{String.valueOf(this.izlaznaRJ.getId().getOznRj()) + "-" + this.ulaznaRJ.getId().getOznRj() + "/" + PzEntityUtil.strZero("" + this.getrBroj(), 5), this.datum, this.vredNaIzlazu, this.vredNaUlazu.subtract(this.pdvIznos).subtract(this.vredNaIzlazu), this.pdvIznos, this.vredNaUlazu};
    }

    @Override
    public void formirajOznaku() {
        String tipI = this.getTip();
        if (tipI.equals("INTERNI_NALOG")) {
            this.oznDokumenta = String.format("%s-%s/%s", String.valueOf(this.getIzlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getIzlaznaRJ().getId().getOznRj(), 3), String.valueOf(this.getUlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getUlaznaRJ().getId().getOznRj(), 3), PzEntityUtil.strZero("" + this.getrBroj(), 5));
        } else if (tipI.equals("POVRATNICA")) {
            this.oznDokumenta = String.format("%s-%s/%s", String.valueOf(this.getIzlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getIzlaznaRJ().getId().getOznRj(), 3), String.valueOf(this.getUlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getUlaznaRJ().getId().getOznRj(), 3), PzEntityUtil.strZero("" + this.getrBroj(), 5));
        } else if (tipI.equals("PRIMO_PREDAJNICA")) {
            this.oznDokumenta = String.format("%s-%s/%s", String.valueOf(this.getIzlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getIzlaznaRJ().getId().getOznRj(), 3), String.valueOf(this.getUlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getUlaznaRJ().getId().getOznRj(), 3), PzEntityUtil.strZero("" + this.getrBroj(), 5));
        } else if (tipI.equals("ZADUZENJE_NASE_KONSIGNACIJE")) {
            this.oznDokumenta = String.format("%s-%s/%s", String.valueOf(this.getIzlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getIzlaznaRJ().getId().getOznRj(), 3), String.valueOf(this.getUlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getUlaznaRJ().getId().getOznRj(), 3), PzEntityUtil.strZero("" + this.getrBroj(), 5));
        } else if (tipI.equals("POVRATNICA_SA_NASE_KONS")) {
            this.oznDokumenta = String.format("%s-%s/%s", String.valueOf(this.getIzlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getIzlaznaRJ().getId().getOznRj(), 3), String.valueOf(this.getUlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getUlaznaRJ().getId().getOznRj(), 3), PzEntityUtil.strZero("" + this.getrBroj(), 5));
        } else if (tipI.equals("DOSTAVNICA")) {
            this.oznDokumenta = String.format("%s-%s/%s", String.valueOf(this.getIzlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getIzlaznaRJ().getId().getOznRj(), 3), String.valueOf(this.getUlaznaRJ().getgTip()) + PzEntityUtil.strZero(this.getUlaznaRJ().getId().getOznRj(), 3), PzEntityUtil.strZero("" + this.getrBroj(), 5));
        }
    }

    @Override
    public Object[] getKValues(byte type) {
        return null;
    }

    @Override
    public Radnajedinica getRadnajedinica() {
        Radnajedinica rj = null;
        if (this.getVrsta().equals("N")) {
            if (this.tip.equals("INTERNI_NALOG")) {
                rj = this.izlaznaRJ;
            }
            if (this.tip.equals("DOSTAVNICA")) {
                rj = this.izlaznaRJ;
            } else if (this.tip.equals("POVRATNICA")) {
                rj = this.ulaznaRJ;
            } else if (this.tip.equals("PRIMO_PREDAJNICA")) {
                rj = this.ulaznaRJ;
            } else if (this.tip.equals("ZADUZENJE_NASE_KONSIGNACIJE")) {
                rj = this.izlaznaRJ;
            } else if (this.tip.equals("POVRATNICA_SA_NASE_KONS")) {
                rj = this.izlaznaRJ;
            }
        } else if (this.getVrsta().equals("U")) {
            rj = this.ulaznaRJ;
        } else if (this.getVrsta().equals("I")) {
            rj = this.izlaznaRJ;
        }
        return rj;
    }

    @Override
    public List<? extends PzArtikalDokument> getArtikalDocuments() {
        return this.artikalinterniracuns;
    }

    public void setCvProdajnaUkupno(BigDecimal cvProdajnaUkupno) {
        this.cvProdajnaUkupno = cvProdajnaUkupno;
    }

    public BigDecimal getCvProdajnaUkupno() {
        return this.cvProdajnaUkupno;
    }

    @Override
    public BigDecimal getIznos() {
        if (this.vrsta.equals("U")) {
            return this.vredNaUlazu;
        }
        return this.vredNaIzlazu;
    }

    @Override
    public Komitent getKomitent() {
        return null;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
    }

    @Override
    public void setKomitent(Komitent komitent) {
    }

    @Override
    public void setRadnajedinica(Radnajedinica rj) {
    }

    @Override
    public String getOpis() {
        return TipDokumentConfig.getNameByValue(this.getTip(), null);
    }

    @Override
    public void setOpis(String opis) {
    }

    @Override
    public Dokument getDokument() {
        return this.dokument1;
    }

    @Override
    public void setDokument(Dokument dokument) {
        this.dokument1 = dokument;
    }

    @Override
    public void adjust() {
        if (this.getArtikalinterniracuns() != null) {
            for (Artikalinterniracun air : this.getArtikalinterniracuns()) {
                air.getId().setIdDok(this.getIdDok());
                if (air.getAirtaksas() == null) continue;
                for (Airtaksa taksa : air.getAirtaksas()) {
                    taksa.getId().setIdDok(this.getIdDok());
                    taksa.getId().setrBroj(air.getId().getrBroj());
                }
            }
        }
    }

    @Override
    public Date getDatValute() {
        return null;
    }

    @Override
    public void setDatValute(Date datum) {
    }

    @Override
    public PzTaksaDokument createEmptyTaksaDokument(String oznTarGr, String tip) {
        return new Taksainterniracun(this.idDok, tip, oznTarGr);
    }

    @Override
    public void setTaksadokuments(List<? extends PzTaksaDokument> taksaDokuments) {
        this.taksainterniracuns = taksaDokuments;
    }

    @Override
    public List<? extends PzTaksaDokument> getTaksadokuments() {
        return this.taksainterniracuns;
    }

    @Override
    public BigDecimal getVrednostRobe() {
        if (this.vrsta.equals("U")) {
            return this.getVredNaUlazu();
        }
        return this.getVredNaIzlazu();
    }

    @Override
    public void izracunajVrednostRobe() {
    }

    @Override
    public Date getDatPrometa() {
        return this.datum;
    }

    @Override
    public void setArtikalDokuments(List<? extends PzArtikalDokument> list) {
        this.artikalinterniracuns = list;
    }

    public int getCountArtikal(String sfrA) {
        int i = 0;
        for (Artikalinterniracun af : this.artikalinterniracuns) {
            if (!af.getId().getSfrProizvod().equals(sfrA)) continue;
            ++i;
        }
        return i;
    }
}

