/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.sql.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Artikalnalog;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Koplaca;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;

@Entity
@Table(name="NalogMagacinu")
public class Nalogmagacinu
implements Serializable,
PzEntity {
    public static final int INFO_PRODAVAC = 0;
    public static final int INFO_KUPAC = 2;
    public static final int INFO_BP = 1;
    public static final int INFO_INTERNI = 3;
    public static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    @TableGenerator(name="NalogMagacinuTab", table="ID_GEN", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="NALOG_MAGACINU_ID", initialValue=1, allocationSize=1)
    @GeneratedValue(generator="NalogMagacinuTab", strategy=GenerationType.TABLE)
    private int oznNalogMagacinu;
    @Column(nullable=false, length=255)
    private String adrTel;
    private int brojKopije = 1;
    private int brTure;
    @Column(nullable=false)
    private Date datum;
    @Column(nullable=false)
    private int info;
    private String koVozi;
    private String napomena;
    private String poslaoUser;
    private int rbrPalete;
    @Column(nullable=false)
    private int redniBroj;
    @Column(length=255)
    private String robuPreuzima;
    @Column(length=10)
    private String vremePreuzimanja;
    @OneToMany(mappedBy="nalogmagacinu", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Artikalnalog> artikalnalogs;
    @OneToMany(mappedBy="nalogmagacinu", cascade={CascadeType.ALL})
    private List<Koplaca> koplacas;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false)
    private Dokument dokument;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK", nullable=false), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ", nullable=false)})
    private Radnajedinica radnajedinica;
    @ManyToMany
    @JoinTable(name="UserNalogMagacinu", joinColumns={@JoinColumn(name="OZNNALOGMAGACINU", nullable=false)}, inverseJoinColumns={@JoinColumn(name="PZUSERNAME", nullable=false)})
    private List<Pzuser> pzusers;

    public int getOznNalogMagacinu() {
        return this.oznNalogMagacinu;
    }

    public void setOznNalogMagacinu(int idDok) {
        this.oznNalogMagacinu = idDok;
    }

    public String getAdrTel() {
        return this.adrTel;
    }

    public void setAdrTel(String adrTel) {
        this.adrTel = adrTel;
    }

    public int getBrojKopije() {
        return this.brojKopije;
    }

    public void setBrojKopije(int brojKopije) {
        this.brojKopije = brojKopije;
    }

    public int getBrTure() {
        return this.brTure;
    }

    public void setBrTure(int brTure) {
        this.brTure = brTure;
    }

    public Date getDatum() {
        return this.datum;
    }

    public void setDatum(Date datum) {
        this.datum = datum;
    }

    public int getInfo() {
        return this.info;
    }

    public void setInfo(int info) {
        this.info = info;
    }

    public String getKoVozi() {
        return this.koVozi;
    }

    public void setKoVozi(String koVozi) {
        this.koVozi = koVozi;
    }

    public String getPoslaoUser() {
        return this.poslaoUser;
    }

    public void setPoslaoUser(String poslaoUser) {
        this.poslaoUser = poslaoUser;
    }

    public int getRbrPalete() {
        return this.rbrPalete;
    }

    public void setRbrPalete(int rbrPalete) {
        this.rbrPalete = rbrPalete;
    }

    public int getRedniBroj() {
        return this.redniBroj;
    }

    public void setRedniBroj(int redniBroj) {
        this.redniBroj = redniBroj;
    }

    public String getRobuPreuzima() {
        return this.robuPreuzima;
    }

    public void setRobuPreuzima(String robuPreuzima) {
        this.robuPreuzima = robuPreuzima;
    }

    public String getVremePreuzimanja() {
        return this.vremePreuzimanja;
    }

    public void setVremePreuzimanja(String vremePreuzimanja) {
        this.vremePreuzimanja = vremePreuzimanja;
    }

    public List<Artikalnalog> getArtikalnalogs() {
        return this.artikalnalogs;
    }

    public void setArtikalnalogs(List<Artikalnalog> artikalnalogs) {
        this.artikalnalogs = artikalnalogs;
    }

    public List<Koplaca> getKoplacas() {
        return this.koplacas;
    }

    public void setKoplacas(List<Koplaca> koplacas) {
        this.koplacas = koplacas;
    }

    public Dokument getDokument() {
        return this.dokument;
    }

    public void setDokument(Dokument faktura) {
        this.dokument = faktura;
    }

    public List<Pzuser> getPzusers() {
        return this.pzusers;
    }

    public void setPzusers(List<Pzuser> pzusers) {
        this.pzusers = pzusers;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Broj naloga", "Datum", "Opis", "Tura(*)", "\u0160ifra kupca(*)", "Naziv kupca", "Poslato od", "Vreme"};
    }

    @Override
    public Object[] getValues() {
        Komitent kom = this.dokument.getKomitent();
        return new Object[]{this.oznNalogMagacinu, this.datum, "", this.brTure, kom == null ? "" : kom.getSfrKomitent(), kom == null ? "Interni dokument" : this.dokument.getKomitent().getNaziv(), this.dokument.getUserPoc().getFullName(), this.vremePreuzimanja};
    }

    public String getNapomena() {
        return this.napomena;
    }

    public void setNapomena(String napomena) {
        this.napomena = napomena;
    }

    public Radnajedinica getRadnajedinica() {
        return this.radnajedinica;
    }

    public void setRadnajedinica(Radnajedinica radnajedinica) {
        this.radnajedinica = radnajedinica;
    }
}

