/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Opstidokument;

@Entity
@Table(name="RadniNalog")
public class RadniNalog
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(unique=true, nullable=false, length=255)
    private String oznRadniNalog;
    @Column(nullable=false, length=255)
    private Date datumOtvaranja;
    private short status;
    private String opis;
    private BigDecimal direktanRad = new BigDecimal(0);
    private BigDecimal direktanMaterijal = new BigDecimal(0);
    private BigDecimal indirektanRad = new BigDecimal(0);
    private BigDecimal indirektanMaterijal = new BigDecimal(0);
    private BigDecimal energija = new BigDecimal(0);
    private BigDecimal amortizacija = new BigDecimal(0);
    private BigDecimal ostalo = new BigDecimal(0);
    @OneToMany(mappedBy="radninalog")
    private List<Opstidokument> opstidokuments;
    @OneToMany(mappedBy="radninalog")
    private List<Faktura> fakturas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sfrKomitent")
    private Komitent komitent;

    public RadniNalog() {
    }

    public RadniNalog(String oznRadniNalog, Date datumOtvaranja) {
        this.oznRadniNalog = oznRadniNalog;
        this.datumOtvaranja = datumOtvaranja;
    }

    public String getOznRadniNalog() {
        return this.oznRadniNalog;
    }

    public void setOznRadniNalog(String oznRadniNalog) {
        this.oznRadniNalog = oznRadniNalog;
    }

    public Date getDatumOtvaranja() {
        return this.datumOtvaranja;
    }

    public void setDatumOtvaranja(Date datumOtvaranja) {
        this.datumOtvaranja = datumOtvaranja;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"", "Oznaka", "Datum otvaranja", "Investitor", "Opis", "Vrednost"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.status, this.oznRadniNalog, this.datumOtvaranja, this.komitent != null ? String.valueOf(this.komitent.getSfrKomitent()) + " " + this.komitent.getNaziv() : "", this.opis, this.getVrednost()};
    }

    public String toString() {
        return this.oznRadniNalog;
    }

    public List<Opstidokument> getOpstidokuments() {
        return this.opstidokuments;
    }

    public void setOpstidokuments(List<Opstidokument> opstidokuments) {
        this.opstidokuments = opstidokuments;
    }

    public short getStatus() {
        return this.status;
    }

    public void setStatus(short status) {
        this.status = status;
    }

    public void setDirektanRad(BigDecimal direktanRad) {
        this.direktanRad = direktanRad;
    }

    public void setDirektanMaterijal(BigDecimal direktanMaterijal) {
        this.direktanMaterijal = direktanMaterijal;
    }

    public BigDecimal getIndirektanRad() {
        return this.indirektanRad;
    }

    public void setIndirektanRad(BigDecimal indirektanRad) {
        this.indirektanRad = indirektanRad;
    }

    public BigDecimal getIndirektanMaterijal() {
        return this.indirektanMaterijal;
    }

    public void setIndirektanMaterijal(BigDecimal indirektanMaterijal) {
        this.indirektanMaterijal = indirektanMaterijal;
    }

    public BigDecimal getEnergija() {
        return this.energija;
    }

    public void setEnergija(BigDecimal energija) {
        this.energija = energija;
    }

    public BigDecimal getAmortizacija() {
        return this.amortizacija;
    }

    public void setAmortizacija(BigDecimal amortizacija) {
        this.amortizacija = amortizacija;
    }

    public BigDecimal getOstalo() {
        return this.ostalo;
    }

    public void setOstalo(BigDecimal ostalo) {
        this.ostalo = ostalo;
    }

    public Komitent getKomitent() {
        return this.komitent;
    }

    public void setKomitent(Komitent komitent) {
        this.komitent = komitent;
    }

    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    public List<Faktura> getFakturas() {
        return this.fakturas;
    }

    public void setFakturas(List<Faktura> fakturas) {
        this.fakturas = fakturas;
    }

    public BigDecimal getVrednost() {
        BigDecimal ukupnaVrednost = new BigDecimal("0.00");
        ukupnaVrednost = this.getDirektanMaterijal().add(this.getDirektanRad()).add(this.getIndirektanRad()).add(this.getIndirektanMaterijal()).add(this.getEnergija()).add(this.getAmortizacija()).add(this.getOstalo());
        return ukupnaVrednost;
    }

    public BigDecimal getDirektanMaterijal() {
        BigDecimal materijal = new BigDecimal("0.00");
        ArrayList<Opstidokument> l = new ArrayList<Opstidokument>();
        for (Opstidokument t : this.getOpstidokuments()) {
            if (t.getArhiviran() != 1) continue;
            l.add(t);
            materijal = t.getStorno() == 0 ? materijal.add(t.getIznosBezPoreza()) : materijal.subtract(t.getIznosBezPoreza());
        }
        return materijal;
    }

    public BigDecimal getDirektanRad() {
        BigDecimal fakturisaniRad = new BigDecimal("0.00");
        ArrayList<Faktura> l1 = new ArrayList<Faktura>();
        for (Faktura f : this.getFakturas()) {
            if (f.getArhiviran() != 1) continue;
            l1.add(f);
            if (f.getStorno() == 0) {
                for (Fakturaparameter fp : f.getFakturaparameters()) {
                    if (!fp.getId().getName().equalsIgnoreCase("rad")) continue;
                    fakturisaniRad = fakturisaniRad.add(new BigDecimal(fp.getValue()));
                }
                continue;
            }
            for (Fakturaparameter fp : f.getFakturaparameters()) {
                if (!fp.getId().getName().equalsIgnoreCase("rad")) continue;
                fakturisaniRad = fakturisaniRad.subtract(new BigDecimal(fp.getValue()));
            }
        }
        return fakturisaniRad;
    }
}

