/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.TaksaTrosakPK;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Trosak;

@Entity
@Table(name="TaksaTrosak")
public class TaksaTrosak
extends PzTaksaDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private TaksaTrosakPK id;
    @Column(nullable=false)
    private BigDecimal iznos = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal osnovica = new BigDecimal(0);
    private short porezKodUvoza;
    @Column(nullable=false, length=15)
    private String vrsta;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", referencedColumnName="IDDOK", nullable=false, insertable=false, updatable=false)
    private Trosak trosak;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznTarGr", nullable=false, insertable=false, updatable=false)
    private Tarifnagrupa tarifnaGrupa;

    public TaksaTrosak() {
    }

    public TaksaTrosak(String oznTarGr, String tip) {
        this.setId(0, oznTarGr);
        this.setTip(tip);
    }

    public TaksaTrosakPK getId() {
        return this.id;
    }

    public void setId(TaksaTrosakPK id) {
        this.id = id;
    }

    public void setId(int idDok, String oznTarGr) {
        this.setId(new TaksaTrosakPK(idDok, oznTarGr));
    }

    @Override
    public BigDecimal getIznos() {
        return this.iznos;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }

    @Override
    public BigDecimal getOsnovica() {
        return this.osnovica;
    }

    @Override
    public void setOsnovica(BigDecimal osnovica) {
        this.osnovica = osnovica;
    }

    public short getPorezKodUvoza() {
        return this.porezKodUvoza;
    }

    public void setPorezKodUvoza(short porezKodUvoza) {
        this.porezKodUvoza = porezKodUvoza;
    }

    @Override
    public String getVrsta() {
        return this.vrsta;
    }

    @Override
    public void setVrsta(String vrsta) {
        this.vrsta = vrsta;
    }

    public Trosak getTrosak() {
        return this.trosak;
    }

    public void setTrosak(Trosak trosak) {
        this.trosak = trosak;
    }

    @Override
    public Tarifnagrupa getTarifnagrupa() {
        return this.tarifnaGrupa;
    }

    @Override
    public void setTarifnagrupa(Tarifnagrupa tarifnaGrupa) {
        this.tarifnaGrupa = tarifnaGrupa;
    }

    @Override
    public PzDokument getDokument() {
        return null;
    }

    @Override
    public String getTip() {
        if (this.porezKodUvoza == 1) {
            return PzTaksaDokument.TIP_UVOZ;
        }
        return PzTaksaDokument.TIP_ULAZ;
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.trosak = (Trosak)dokument;
    }

    @Override
    public void setTip(String tip) {
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Tarifna grupa", "Stopa PDV-a", "Osnovica", "Iznos"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.tarifnaGrupa.getOznTarGr(), this.tarifnaGrupa.getStopa(), this.osnovica, this.iznos};
    }

    @Override
    public void setId(String oznTarGr, int idDok, String tip) {
    }
}

