/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaopstidokument;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.globals.TipDokumentConfig;

@Entity
@DiscriminatorValue(value="ZADUZENJE_ODOBRENJE")
public class ZaduzenjeOdobrenje
extends Opstidokument
implements PzEntity,
Serializable {
    @Column(name="str1")
    private String pdv;
    @Column(name="str2")
    private String oznKomitenta;
    @Column(name="int1")
    private int rBrDokumenta;
    @Column(name="int2")
    private int kalkulacijaId;
    @Column(name="str3")
    private String printIndicator;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="Fakturaopstidokument", joinColumns={@JoinColumn(name="OPSTIDOKUMENT", nullable=false)}, inverseJoinColumns={@JoinColumn(name="FAKTURA", nullable=false)})
    private List<Faktura> fakturas;
    @OneToMany(mappedBy="zaduzenjeodobrenje", cascade={CascadeType.ALL})
    @PrivateOwned
    private List<Fakturaopstidokument> fakturaopstidokuments;

    public List<Fakturaopstidokument> getFakturaopstidokuments() {
        return this.fakturaopstidokuments;
    }

    public void setFakturaopstidokuments(List<Fakturaopstidokument> fakturaopstidokuments) {
        this.fakturaopstidokuments = fakturaopstidokuments;
    }

    public void setFakturas(List<Faktura> fakturas) {
        this.fakturas = fakturas;
    }

    public List<Faktura> getFakturas() {
        return this.fakturas;
    }

    public void setPdv(String pdv) {
        this.pdv = pdv;
    }

    public String getPdv() {
        return this.pdv;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Tip", "Oznaka", "\u0160ifra komitenta", "Naziv komitenta", "Datum", "Osnovica", "PDV", "Iznos"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getPodTip(), this.getIdDok(), this.getKomitent().getSfrKomitent(), this.getKomitent().getNaziv(), this.getDatum(), this.getIznosBezPoreza(), this.getPdvIznos(), this.getIznos()};
    }

    public Object[] getPregledValues() {
        return new Object[]{this.getPrintIndicator(), TipDokumentConfig.getNameByValue(this.getTip(), null), this.getrBrDokumenta(), this.getKomitent().getSfrKomitent(), this.getKomitent().getNaziv(), this.getDatum(), this.getIznosBezPoreza(), this.getPdvIznos(), this.getIznos()};
    }

    public void setOznKomitenta(String oznKomitenta) {
        this.oznKomitenta = oznKomitenta;
    }

    public String getOznKomitenta() {
        return this.oznKomitenta;
    }

    @Override
    public void formirajOznaku() {
    }

    public int getrBrDokumenta() {
        return this.rBrDokumenta;
    }

    public void setrBrDokumenta(int rBrDokumenta) {
        this.rBrDokumenta = rBrDokumenta;
    }

    public void setPrintIndicator(String printIndicator) {
        this.printIndicator = printIndicator;
    }

    public String getPrintIndicator() {
        return this.printIndicator;
    }

    public int getKalkulacijaId() {
        return this.kalkulacijaId;
    }

    public void setKalkulacijaId(int kalkulacijaId) {
        this.kalkulacijaId = kalkulacijaId;
    }
}

