/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.test;

import java.sql.BatchUpdateException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Proizvod;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Tarifnagrupa;

public class Test {
    public static void main(String[] args) {
        Calendar c = Calendar.getInstance();
        c.set(10, 23);
        c.set(12, 59);
        c.set(13, 59);
        Timestamp ts = new Timestamp(c.getTimeInMillis());
        System.out.println(ts);
    }

    private static void deleteDokument(PzDokument dokument) {
        try {
            Kalkulacija k = (Kalkulacija)PzEntityManager.find(Kalkulacija.class, 24);
            PzDokumentManager.getInstance().deleteDokument(k, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void scrollableCursor() {
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery("SELECT s FROM Stanjeartikal s where s.naziv like 'as%'");
        q.setHint("eclipselink.cursor.scrollable", (Object)true);
        q.setHint("eclipselink.read-only", (Object)true);
        ScrollableCursor cursor = (ScrollableCursor)q.getSingleResult();
        while (cursor.hasNext()) {
            Stanjeartikal s = (Stanjeartikal)cursor.next();
            System.out.println(s.getId().getSfrProizvod());
        }
        cursor.close();
        em.close();
    }

    public static void addKomitent() {
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"pezardb", (Map)System.getProperties());
        EntityManager em = factory.createEntityManager();
        em.getTransaction().begin();
        Random random = new Random();
        int i = 10000;
        while (i < 20000) {
            Komitent komitent = new Komitent();
            komitent.setSfrKomitent(String.valueOf(i));
            komitent.setAdresa("Adresa komintenta " + i);
            komitent.setBrFaxa("0" + random.nextInt(99) + "/" + random.nextInt(999999));
            komitent.setDomaciKomitent((short)random.nextInt(2));
            komitent.setEmail("komintent" + i + "@google.com");
            komitent.setGrad("Grad " + i);
            komitent.setKontakt("Kontakt komintenta" + i);
            komitent.setMatBroj("" + random.nextInt(99999999));
            komitent.setNaziv("Naziv komintenta " + i);
            komitent.setObveznikPDV((short)random.nextInt(2));
            if (komitent.getObveznikPDV() == 1) {
                komitent.setBrojPDV("" + random.nextInt(99999));
            } else {
                komitent.setBrojPDV("");
            }
            komitent.setOpis("Opis komintenta " + i);
            komitent.setPib("" + random.nextInt(99999));
            komitent.setPostBroj(random.nextInt(99) + "000");
            komitent.setPovPravnoLice((short)random.nextInt(2));
            komitent.setRegBroj("" + random.nextInt(999999999));
            komitent.setSifDelatnosti("" + random.nextInt(9999));
            if (komitent.getDomaciKomitent() == 1) {
                komitent.setSrbija((short)random.nextInt(2));
            }
            komitent.setTelefoni("0" + random.nextInt(99) + "/" + random.nextInt(999999) + " ; " + "0" + random.nextInt(99) + "/" + random.nextInt(999999));
            if (komitent.getDomaciKomitent() == 0) {
                komitent.setZemljaKomitenta("Zemlja komintenta " + i);
            } else {
                komitent.setZemljaKomitenta("");
            }
            System.out.println("Snimanje komintenta " + i);
            em.persist((Object)komitent);
            ++i;
        }
        System.out.println("Komitovanje izmena u bazi ...");
        em.getTransaction().commit();
        em.close();
        factory.close();
        System.out.println("Unos obavljen!");
    }

    public static void addKonto() {
        block6: {
            EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"pezardb", (Map)System.getProperties());
            EntityManager em = factory.createEntityManager();
            try {
                try {
                    em.getTransaction().begin();
                    Random random = new Random();
                    String[] analitika = new String[]{"", "K", "S", "P", "R"};
                    int i = 0;
                    while (i < 100) {
                        Konto konto = new Konto();
                        konto.setId(new KontoPK("" + random.nextInt(999999), ""));
                        konto.setTipAnalitike(analitika[random.nextInt(4)]);
                        konto.setNaziv("Naziv konta " + i);
                        System.out.println("Snimanje konta " + konto.getNaziv());
                        em.persist((Object)konto);
                        ++i;
                    }
                    System.out.println("Komitovanje izmena u bazi ...");
                    em.getTransaction().commit();
                }
                catch (Exception exception) {
                    em.getTransaction().rollback();
                    em.close();
                    factory.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                em.close();
                factory.close();
                throw throwable;
            }
            em.close();
            factory.close();
        }
        System.out.println("Unos obavljen!");
    }

    public static void addArtikal() {
        block7: {
            EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"pezardb", (Map)System.getProperties());
            EntityManager em = factory.createEntityManager();
            try {
                try {
                    em.getTransaction().begin();
                    Random random = new Random();
                    Robnagrupa rg = (Robnagrupa)PzEntityManager.find(Robnagrupa.class, "1");
                    Tarifnagrupa tg = (Tarifnagrupa)PzEntityManager.find(Tarifnagrupa.class, "T1");
                    int i = 2000;
                    while (i < 5000) {
                        Artikal artikal = new Artikal();
                        Proizvod p = new Proizvod("" + i);
                        artikal.setProizvod(p);
                        artikal.setSfrProizvod("" + i);
                        artikal.setBarKod("" + random.nextInt(99999));
                        artikal.setJedMere("KOM");
                        artikal.setNaziv("TEST ARTIKAL " + i);
                        artikal.setDobSifra("" + random.nextInt(99999));
                        artikal.setProcKala((double)random.nextInt(6) + random.nextDouble());
                        artikal.setStandPak(0.0);
                        artikal.setStokMax(0.0);
                        artikal.setStokMin(0.0);
                        artikal.setTezina(0.0);
                        artikal.setTip("");
                        artikal.setRobnagrupa(rg);
                        artikal.setTarifnagrupas((List<Tarifnagrupa>)new IndirectList());
                        artikal.getTarifnagrupas().add(tg);
                        artikal.setOpis("");
                        System.out.println("Snimanje artikla " + artikal.getSfrProizvod());
                        em.persist((Object)p);
                        em.persist((Object)artikal);
                        ++i;
                    }
                    System.out.println("Komitovanje izmena u bazi ...");
                    em.getTransaction().commit();
                    System.out.println("Unos obavljen");
                }
                catch (Exception exception) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                    factory.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                em.close();
                factory.close();
                throw throwable;
            }
            em.close();
            factory.close();
        }
        System.out.println("Unos obavljen!");
    }

    public static void addKalkulacija() {
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"pezardb", (Map)System.getProperties());
        EntityManager em = factory.createEntityManager();
        try {
            try {
                em.getTransaction().begin();
                System.out.println("Dobavljam kalkulaciju ...");
                Kalkulacija k1 = (Kalkulacija)em.createQuery("select k from Kalkulacija k where k.rbrDok=1").getResultList().get(0);
                System.out.println("Obavljeno");
                System.out.println("Dobavljam artikle.");
                Vector cfr_ignored_0 = (Vector)em.createQuery("select a from Artikal a").getResultList();
                System.out.println("Obavljeno");
                Pzuser user = k1.getUserPoc();
                Komitent kom = k1.getKomitent();
                List<Taksakalkulacija> pdvk = k1.getTaksakalkulacijas();
                k1.getArtikalkalkulacijas();
                Radnajedinica rj = k1.getRadnajedinica();
                System.out.println("Ulazim u transakciju");
                int i = 15001;
                while (i < 25000) {
                    Kalkulacija k = new Kalkulacija();
                    k.setIdDok(i);
                    k.setArhiviran(k1.getArhiviran());
                    k.setDatum(k1.getDatum());
                    k.setDatDPO(k1.getDatDPO());
                    k.setDatFakture(k1.getDatFakture());
                    k.setDatValute(k1.getDatValute());
                    k.setIznos(k1.getIznos());
                    k.setKomitent(kom);
                    k.setKurs(k1.getKurs());
                    k.setPdv(k1.getPdv());
                    k.setProcRabata(k1.getProcRabata());
                    k.setProknjizen(k1.getProknjizen());
                    k.setTaksakalkulacijas(pdvk);
                    k.setRadnajedinica(rj);
                    k.setrBroj(-100);
                    k.setPoruka(k1.getPoruka());
                    k.setTip(k1.getTip());
                    k.setTipKalkulacije(k1.getTipKalkulacije());
                    k.setTrosakBezPdv(k1.getTrosakBezPdv());
                    k.setUserKraj(user);
                    k.setOznDokumenta("0000-" + PzEntityUtil.strZero("" + i, 4));
                    new IndirectList();
                    System.out.println("Dodajem kalkulaciju za dokument " + k.getOznDokumenta());
                    PzDokumentManager.getInstance().arhivirajDokument(k, true, null, em);
                    ++i;
                }
                System.out.println("Komitujem izmene...");
                em.getTransaction().commit();
                System.out.println("Kraj unosa.");
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                e.printStackTrace();
                em.close();
                factory.close();
            }
        }
        finally {
            em.close();
            factory.close();
        }
    }

    public static void insertFaktura() {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                Vector fakture = (Vector)em.createQuery("SELECT f FROM Faktura f").getResultList();
                em.close();
                em = PzEntityManager.getEm();
                em.getTransaction().begin();
                int i = 0;
                while (i < 100) {
                    int j = 0;
                    while (j < fakture.size()) {
                        Faktura f = (Faktura)fakture.elementAt(j);
                        f.setId(0);
                        f.setDokument(null);
                        f.setLicnaKarta("888");
                        PzDokumentManager.getInstance().arhivirajDokument(f, true, null, em);
                        ++j;
                    }
                    ++i;
                }
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                ((BatchUpdateException)((DatabaseException)((RollbackException)e).getCause()).getInternalException()).getNextException().printStackTrace();
                em.close();
                PzEntityManagerFactory.getInstance().close();
            }
        }
        finally {
            em.close();
            PzEntityManagerFactory.getInstance().close();
        }
    }

    public static void test() {
        try {
            EntityManager em = PzEntityManager.getEm();
            Query q = em.createQuery("SELECT s FROM Stanjeartikal s where s.id.sfrProizvod=:sfrP and s.radnajedinica.gTip='T' and s.kolicina>0");
            q.setParameter("sfrP", (Object)"100017");
            Vector cfr_ignored_0 = (Vector)q.getResultList();
            em.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

