/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import rs.pezar.swing.PzPanel;

class PanelTaskPerformer
implements ActionListener {
    private final String type;
    private final PzPanel panel;
    private final Dimension dim;
    private final Dimension preferred;
    private final JComponent component;

    public PanelTaskPerformer(String type, PzPanel panel, Dimension preferred, JComponent component) {
        this.type = type;
        this.panel = panel;
        this.dim = new Dimension();
        this.preferred = preferred;
        this.component = component;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Timer timer = (Timer)e.getSource();
        if (this.type.equalsIgnoreCase("top-down")) {
            if ((double)this.panel.getHeight() >= this.preferred.getHeight()) {
                timer.stop();
                this.component.requestFocusInWindow();
                return;
            }
            this.dim.setSize(this.panel.getWidth(), this.panel.getHeight() + 5);
            JPanel parent = (JPanel)this.panel.getParent();
            this.panel.setPreferredSize(this.dim);
            parent.doLayout();
            parent.validate();
        } else if (this.type.equalsIgnoreCase("hide-bottom-up")) {
            if (this.panel.getHeight() <= 0) {
                timer.stop();
                this.panel.setVisible(false);
                this.component.requestFocusInWindow();
                return;
            }
            this.dim.setSize(this.panel.getWidth(), this.panel.getHeight() - 5);
            JPanel parent = (JPanel)this.panel.getParent();
            this.panel.setPreferredSize(this.dim);
            parent.doLayout();
            parent.validate();
        }
    }
}

