/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzImageContainer;
import rs.pezar.swing.PzImageDialog;
import rs.pezar.swing.fields.PzTextArea;

public class PzImagePanel
extends JPanel {
    private static final long serialVersionUID = -2162495178273183986L;
    private float xScaleFactor = 0.3f;
    private float yScaleFactor = 0.3f;
    private BufferedImage originalImage;
    private String path;
    private PzTextArea txtNemaSlike;
    private PzImageContainer container;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new PzImagePanel());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public PzImagePanel() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PzImagePanel.this.thisMouseClicked(evt);
                }
            });
            this.txtNemaSlike = new PzTextArea();
            this.add(this.txtNemaSlike);
            this.txtNemaSlike.setVisible(false);
            this.txtNemaSlike.setWrapStyleWord(true);
            this.txtNemaSlike.setEditable(false);
            this.txtNemaSlike.setFocusable(false);
            this.txtNemaSlike.setLineWrap(true);
            this.txtNemaSlike.setPreferredSize(new Dimension(200, 100));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paintImage(String path) {
        this.path = path;
        this.repaint();
    }

    public void imageResize(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        try {
            this.txtNemaSlike.setVisible(false);
            this.originalImage = ImageIO.read(new File(this.path));
        }
        catch (IOException iOException) {
            this.txtNemaSlike.setText(String.valueOf(this.path) + " \u017dao nam je, ali navedena slika ne postoji na disku.");
            this.txtNemaSlike.setVisible(true);
            return;
        }
        int pnlH = this.getHeight();
        int pnlW = this.getWidth();
        int slikaH = this.originalImage.getHeight();
        int slikaW = this.originalImage.getWidth();
        int x = 0;
        int y = 0;
        if (pnlH > pnlW) {
            this.xScaleFactor = this.yScaleFactor = (float)pnlW / (float)slikaW;
        } else {
            this.yScaleFactor = this.xScaleFactor = (float)pnlH / (float)slikaH;
        }
        int newW = (int)((float)this.originalImage.getWidth() * this.xScaleFactor);
        int newH = (int)((float)this.originalImage.getHeight() * this.yScaleFactor);
        if (slikaH > slikaW) {
            float raz = (float)pnlH - (float)newH;
            x = 0;
            y = (int)(raz /= 2.0f);
        } else if (slikaW > slikaH) {
            float raz = (float)pnlW - (float)newW;
            y = 0;
            x = (int)(raz /= 2.0f);
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(this.originalImage, x, y, newW, newH, null);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.path != null) {
            this.imageResize(g);
        }
    }

    public void setContainer(PzImageContainer container) {
        this.container = container;
    }

    private void thisMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            PzImageContainer kopija = new PzImageContainer();
            if (this.container.getImages() != null) {
                kopija.setImages(this.container.getImages());
                kopija.setIndex(this.container.getIndex());
                kopija.btnNazad.setVisible(true);
                PzImageDialog dialog = new PzImageDialog((PzDialog)SwingUtilities.getRoot(this), kopija);
                dialog.setLocationRelativeTo((PzDialog)SwingUtilities.getRoot(this));
                dialog.setModal(true);
                dialog.setVisible(true);
            } else {
                return;
            }
        }
    }
}

