/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import rs.pezar.swing.PanelTaskPerformer;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzPanel
extends JPanel {
    private static final long serialVersionUID = 7789717534879617008L;
    public static int GRADIENT_WEST_EAST = 123456;
    public static int GRADIENT_NORTH_SOUTH = 123457;
    public static int GRADIENT_SOUTH_NORTH = 123458;
    private Dimension preferred = null;
    private String type;
    private Color startColor = Color.LIGHT_GRAY;
    private Color endColor = Color.WHITE;
    private boolean paintGradient;
    private int direction = GRADIENT_SOUTH_NORTH;
    private Line2D lineDirection;
    private final boolean opaque = false;

    public PzPanel() {
        this.setOpaque(false);
    }

    public PzPanel(LayoutManager layout) {
        super(layout);
        this.setOpaque(false);
    }

    public PzPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.setOpaque(false);
    }

    public PzPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.setOpaque(false);
    }

    public void setTransferFocusOnEnter(boolean arg) {
    }

    public void showAnimated(String type, JComponent comp) {
        if (this.isVisible()) {
            return;
        }
        this.type = type;
        if (this.preferred == null) {
            this.preferred = this.getPreferredSize();
        }
        if (type.equalsIgnoreCase("top-down")) {
            this.setPreferredSize(new Dimension(this.getWidth(), 0));
        }
        this.setVisible(true);
        PanelTaskPerformer taskPerformer = new PanelTaskPerformer(type, this, this.preferred, comp);
        Timer timer = new Timer(1, taskPerformer);
        timer.start();
    }

    public void hideAnimated(JComponent component) {
        String hideType = null;
        if (this.type == "top-down") {
            hideType = "hide-bottom-up";
        }
        PanelTaskPerformer taskPerformer = new PanelTaskPerformer(hideType, this, this.preferred, component);
        Timer timer = new Timer(1, taskPerformer);
        timer.start();
    }

    public Vector<PzField> getAllFields() {
        Vector<PzField> result = new Vector<PzField>();
        int i = 0;
        while (i < this.getComponents().length) {
            if (this.getComponents()[i] instanceof PzField) {
                result.add((PzField)((Object)this.getComponents()[i]));
            } else if (this.getComponents()[i] instanceof PzPanel) {
                result.addAll(((PzPanel)this.getComponents()[i]).getAllFields());
            } else if (this.getComponents()[i] instanceof PzTextAreaPanel) {
                result.addElement(((PzTextAreaPanel)this.getComponents()[i]).getArea());
            }
            ++i;
        }
        return result;
    }

    public void updateAllFieldsState() {
        Vector<PzField> fields = this.getAllFields();
        for (PzField field : fields) {
            if (!field.isValueValid()) continue;
            field.setState(PzFieldIndikator.STATE_VALID);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.paintGradient) {
            int panelHeight = this.getHeight();
            int panelWidth = this.getWidth();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.startColor, 0.0f, 0.0f, this.endColor);
            if (this.lineDirection != null) {
                gradientPaint = new GradientPaint(this.lineDirection.getP1(), this.startColor, this.lineDirection.getP1(), this.endColor);
            } else if (this.direction == GRADIENT_NORTH_SOUTH) {
                gradientPaint = new GradientPaint(0.0f, 0.0f, this.startColor, 0.0f, panelHeight, this.endColor);
            } else if (this.direction == GRADIENT_WEST_EAST) {
                gradientPaint = new GradientPaint(0.0f, 0.0f, this.startColor, panelWidth, 0.0f, this.endColor);
            } else if (this.direction == GRADIENT_SOUTH_NORTH) {
                gradientPaint = new GradientPaint(0.0f, panelHeight, this.startColor, 0.0f, 0.0f, this.endColor);
            }
            if (g instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)g;
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, panelWidth, panelHeight);
            }
            this.setOpaque(false);
        }
    }

    public void setGradient(Color startColor, Color endColor, int direction) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.direction = direction;
    }

    public void setGradient(PzGradient gradient) {
        this.setGradient(gradient.getStartColor(), gradient.getEndColor(), gradient.getDirection());
    }

    public void setGradient(Color startColor, Color endColor, Line2D.Float direction) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.lineDirection = direction;
    }

    public void setGradient(int startColor, int endColor, int direction) {
        this.startColor = new Color(startColor);
        this.endColor = new Color(endColor);
        this.direction = direction;
    }

    public void setGradient(int startColor, int endColor, Line2D.Float direction) {
        this.startColor = new Color(startColor);
        this.endColor = new Color(endColor);
        this.lineDirection = direction;
    }

    public void setPaintGradient(boolean arg) {
        this.paintGradient = arg;
    }

    public boolean validateForm(boolean showErrorMessage) {
        Vector<PzField> fields = this.getAllFields();
        boolean ok = true;
        Iterator<PzField> iterator = fields.iterator();
        while (iterator.hasNext() && ok) {
            PzField fld = iterator.next();
            if (fld.getState() != PzFieldIndikator.STATE_INVALID) continue;
            ok = false;
        }
        if (!ok && showErrorMessage) {
            PzSwingUtility.showErrorMessage(this, "Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
        }
        return ok;
    }
}

