/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;

public class PzRadioGroup<T>
extends JPanel {
    private static final long serialVersionUID = 3257285842266567986L;
    private ButtonGroup buttonGroup;
    private final List<T> values = new ArrayList<T>();
    private ActionSelectionListener actionHandler;
    private List<PzRadioGroupListener> actionListeners;
    private boolean isCyclic;
    private boolean isGroupSelectionFollowFocus;

    public PzRadioGroup() {
        this.buttonGroup = new ButtonGroup();
        this.init();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                PzRadioGroup.this.getSelectedButton().requestFocus();
            }
        });
    }

    public PzRadioGroup(T[] radioValues) {
        this();
        int i = 0;
        while (i < radioValues.length) {
            this.add(radioValues[i]);
            ++i;
        }
    }

    public static <T> PzRadioGroup<T> create(T[] radioValues) {
        return new PzRadioGroup<T>(radioValues);
    }

    public void setLayoutAxis(int axis) {
        this.setLayout(new BoxLayout(this, axis));
    }

    public void setValues(T[] radioValues) {
        this.clearAll();
        int i = 0;
        while (i < radioValues.length) {
            this.add(radioValues[i]);
            ++i;
        }
    }

    private void clearAll() {
        this.values.clear();
        this.buttonGroup = new ButtonGroup();
        this.removeAll();
    }

    public void add(T radioValue) {
        if (this.values.contains(radioValue)) {
            throw new IllegalArgumentException("cannot add the same value twice " + radioValue);
        }
        if (radioValue instanceof AbstractButton) {
            this.values.add(radioValue);
            ((AbstractButton)radioValue).setOpaque(false);
            this.addButton((AbstractButton)radioValue);
        } else {
            this.values.add(radioValue);
            JRadioButton button = new JRadioButton("" + radioValue);
            button.setOpaque(false);
            this.addButton(button);
        }
    }

    private void addButton(AbstractButton button) {
        this.buttonGroup.add(button);
        super.add(button);
        if (this.actionHandler == null) {
            this.actionHandler = new ActionSelectionListener(this);
        }
        button.addItemListener(this.actionHandler);
    }

    public AbstractButton getSelectedButton() {
        ButtonModel selectedModel = this.buttonGroup.getSelection();
        AbstractButton[] children = this.getButtonComponents();
        int i = 0;
        while (i < children.length) {
            AbstractButton button = children[i];
            if (button.getModel() == selectedModel) {
                return button;
            }
            ++i;
        }
        return null;
    }

    public AbstractButton[] getButtonComponents() {
        Component[] children = this.getComponents();
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof AbstractButton) {
                buttons.add((AbstractButton)children[i]);
            }
            ++i;
        }
        return buttons.toArray(new AbstractButton[buttons.size()]);
    }

    public List<T> getValues() {
        return this.values;
    }

    public int getSelectedIndex() {
        ButtonModel selectedModel = this.buttonGroup.getSelection();
        AbstractButton[] children = this.getButtonComponents();
        int i = 0;
        while (i < children.length) {
            AbstractButton button = children[i];
            if (button.getModel() == selectedModel) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setSelectedIndex(int index) {
        AbstractButton[] children = this.getButtonComponents();
        children[index].setSelected(true);
    }

    public T getSelectedValue() {
        int index = this.getSelectedIndex();
        return index < 0 || index >= this.values.size() ? null : (T)this.values.get(index);
    }

    public void setSelectedValue(T value) {
        int index = this.values.indexOf(value);
        AbstractButton button = this.getButtonComponents()[index];
        this.firePropertyChange("selectedValue", this.getSelectedValue(), value);
        button.setSelected(true);
    }

    public AbstractButton getChildButton(int index) {
        return this.getButtonComponents()[index];
    }

    public AbstractButton getChildButton(T value) {
        int index = this.values.indexOf(value);
        return this.getButtonComponents()[index];
    }

    public int getChildButtonCount() {
        return this.getButtonComponents().length;
    }

    public void addRadioGroupListener(PzRadioGroupListener l) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<PzRadioGroupListener>();
        }
        this.actionListeners.add(l);
    }

    public void removeRadioGroupListener(PzRadioGroupListener l) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(l);
        }
    }

    public PzRadioGroupListener[] getItemListeners() {
        if (this.actionListeners != null) {
            return this.actionListeners.toArray(new PzRadioGroupListener[0]);
        }
        return new PzRadioGroupListener[0];
    }

    private void fireRadioGroupEvent(ItemEvent e) {
        if (this.actionListeners != null) {
            PzRadioGroupEvent event = new PzRadioGroupEvent(e.getItem(), e.getStateChange(), this.values.get(this.getIndexOfButton((AbstractButton)e.getItem())));
            for (PzRadioGroupListener listener : this.actionListeners) {
                listener.selectionChanged(event);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Enumeration<AbstractButton> en = this.buttonGroup.getElements();
        while (en.hasMoreElements()) {
            AbstractButton button = en.nextElement();
            if (!enabled || button.getAction() == null || button.getAction().isEnabled()) {
                button.setEnabled(enabled);
            }
            this.setFocusTraversalPolicyProvider(enabled);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setFocusTraversalPolicyProvider(visible);
    }

    private int getIndexOfButton(AbstractButton b) {
        int res = 0;
        int i = 0;
        while (i < this.getButtonComponents().length) {
            if (b == this.getButtonComponents()[i]) {
                res = i;
                break;
            }
            ++i;
        }
        return res;
    }

    private void init() {
        this.setFocusTraversalPolicyProvider(this.isEnabled() && this.isVisible());
        this.setFocusTraversalPolicy(new JXButtonPanelFocusTraversalPolicy());
        ActionHandler actionHandler = new ActionHandler();
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(40, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionBackward", KeyStroke.getKeyStroke(37, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionBackward", KeyStroke.getKeyStroke(38, 0), 1);
        this.setGroupSelectionFollowFocus(true);
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
    }

    public boolean isGroupSelectionFollowFocus() {
        return this.isGroupSelectionFollowFocus;
    }

    public void setGroupSelectionFollowFocus(boolean groupSelectionFollowFocus) {
        this.isGroupSelectionFollowFocus = groupSelectionFollowFocus;
    }

    private static ButtonGroup getButtonGroup(AbstractButton button) {
        ButtonModel model = button.getModel();
        if (model instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)model).getGroup();
        }
        return null;
    }

    private class ActionHandler
    implements ActionListener {
        private static final String FORWARD = "moveSelectionForward";
        private static final String BACKWARD = "moveSelectionBackward";

        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FocusTraversalPolicy ftp = PzRadioGroup.this.getFocusTraversalPolicy();
            if (ftp instanceof JXButtonPanelFocusTraversalPolicy) {
                Component next;
                JXButtonPanelFocusTraversalPolicy xftp = (JXButtonPanelFocusTraversalPolicy)ftp;
                String actionCommand = e.getActionCommand();
                Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                xftp.setAlternativeFocusMode(true);
                if (FORWARD.equals(actionCommand)) {
                    next = xftp.getComponentAfter(PzRadioGroup.this, fo);
                } else if (BACKWARD.equals(actionCommand)) {
                    next = xftp.getComponentBefore(PzRadioGroup.this, fo);
                } else {
                    throw new AssertionError((Object)("Unexpected action command: " + actionCommand));
                }
                xftp.setAlternativeFocusMode(false);
                if (fo instanceof AbstractButton) {
                    AbstractButton b = (AbstractButton)fo;
                    b.getModel().setPressed(false);
                }
                if (next != null && fo instanceof AbstractButton && next instanceof AbstractButton) {
                    AbstractButton nextButton;
                    ButtonGroup group = PzRadioGroup.getButtonGroup((AbstractButton)fo);
                    if (group != PzRadioGroup.getButtonGroup(nextButton = (AbstractButton)next)) {
                        return;
                    }
                    if (PzRadioGroup.this.isGroupSelectionFollowFocus() && group != null && group.getSelection() != null && !nextButton.isSelected()) {
                        nextButton.setSelected(true);
                    }
                    next.requestFocusInWindow();
                }
            }
        }
    }

    private class ActionSelectionListener
    implements ItemListener {
        private PzRadioGroup<T> radioGroup;

        public ActionSelectionListener() {
        }

        public ActionSelectionListener(PzRadioGroup<T> pzRadioGroup2) {
            this.radioGroup = pzRadioGroup2;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            PzRadioGroup.this.fireRadioGroupEvent(e);
            ButtonModel selectedModel = PzRadioGroup.this.buttonGroup.getSelection();
            int i = 0;
            while (i < this.radioGroup.getButtonComponents().length) {
                AbstractButton button = this.radioGroup.getButtonComponents()[i];
                if (button.getModel() == selectedModel) {
                    this.radioGroup.firePropertyChange("selectedValue", this.radioGroup.getSelectedValue(), PzRadioGroup.this.values.indexOf(i));
                }
                ++i;
            }
        }
    }

    private class JXButtonPanelFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private static final long serialVersionUID = -8365200550220777393L;
        private boolean isAlternativeFocusMode;

        private JXButtonPanelFocusTraversalPolicy() {
        }

        public boolean isAlternativeFocusMode() {
            return this.isAlternativeFocusMode;
        }

        public void setAlternativeFocusMode(boolean alternativeFocusMode) {
            this.isAlternativeFocusMode = alternativeFocusMode;
        }

        @Override
        protected boolean accept(Component c) {
            AbstractButton button;
            ButtonGroup group;
            if (!this.isAlternativeFocusMode() && c instanceof AbstractButton && (group = PzRadioGroup.getButtonGroup(button = (AbstractButton)c)) != null && group.getSelection() != null && !button.isSelected()) {
                return false;
            }
            boolean accepted = super.accept(c);
            return accepted;
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component componentAfter = super.getComponentAfter(aContainer, aComponent);
            if (!this.isAlternativeFocusMode()) {
                return componentAfter;
            }
            if (PzRadioGroup.this.isCyclic()) {
                return componentAfter == null ? this.getFirstComponent(aContainer) : componentAfter;
            }
            if (aComponent == this.getLastComponent(aContainer)) {
                return aComponent;
            }
            return componentAfter;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component componentBefore = super.getComponentBefore(aContainer, aComponent);
            if (!this.isAlternativeFocusMode()) {
                return componentBefore;
            }
            if (PzRadioGroup.this.isCyclic()) {
                return componentBefore == null ? this.getLastComponent(aContainer) : componentBefore;
            }
            if (aComponent == this.getFirstComponent(aContainer)) {
                return aComponent;
            }
            return componentBefore;
        }
    }
}

