/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzEntityManager;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.data.models.PzScrollableTableModel;

public class PzScrollableTable
extends PzAbstractTable {
    private static final long serialVersionUID = -7039554091159544417L;
    private String dbTableName;
    private PzScrollableTableModel model;

    public PzScrollableTable(Class<?> c, String[][] columns) {
        this.read(c, columns);
        this.packColumns();
    }

    public PzScrollableTable(ScrollableCursor cursor, String[] columns) {
        this.read(cursor, columns);
    }

    public PzScrollableTable() {
    }

    public void read(Class<?> c, String[][] columns) {
        if (columns[0].length != columns[1].length) {
            throw new IllegalArgumentException("Duzine nizova se ne podudaraju!");
        }
        this.dbTableName = c.getName().replaceAll(String.valueOf(c.getPackage().getName()) + ".", "");
        String columnStr = "";
        int i = 0;
        while (i < columns[0].length) {
            columnStr = String.valueOf(columnStr) + "e." + columns[0][i] + (i == columns[0].length - 1 ? " " : ", ");
            ++i;
        }
        EntityManager em = PzEntityManager.getEm();
        Query query = em.createQuery("SELECT " + columnStr + " FROM " + this.dbTableName + " e");
        query.setHint("eclipselink.cursor.scrollable", (Object)true);
        query.setHint("eclipselink.read-only", (Object)true);
        ScrollableCursor cursor = (ScrollableCursor)query.getSingleResult();
        this.model = new PzScrollableTableModel(cursor, columns[1]);
        this.setModel(this.model);
        this.restoreState();
        this.calculateFields();
    }

    public void read(ScrollableCursor cursor, String[] columnNames) {
        this.model = new PzScrollableTableModel(cursor, columnNames);
        this.setModel(this.model);
        this.restoreState();
        this.calculateFields();
    }

    public void insertColumn(int column, String expression, String columnName) {
        ((PzScrollableTableModel)this.getModel()).insertColumn(column, expression, columnName);
    }
}

