/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.TreeTableModel;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Ogranak;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.swing.data.models.PzTreeTableModel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.renderers.PzTreeTableCellRenderer;

public class PzTreeTable
extends JXTreeTable {
    private static final long serialVersionUID = -7047473918196337527L;
    public static Ogranak selectedEntity;
    private PzTreeTableModel model;
    private String dbTableName;

    public PzTreeTable(TreeTableModel model) {
        super(model);
        this.initGUI();
    }

    public PzTreeTable(Vector<Ogranak> data) {
        PzTreeTableModel tblModel;
        this.model = tblModel = new PzTreeTableModel(data);
        this.initGUI();
    }

    public PzTreeTable(Class<?> c) throws Exception {
        this.dbTableName = c.getName().replaceAll(String.valueOf(c.getPackage().getName()) + ".", "");
        try {
            Vector<Ogranak> v = new Vector<Ogranak>();
            Vector<PzEntity> data = PzEntityManager.selectAll(this.dbTableName);
            Iterator<PzEntity> i = data.iterator();
            while (i.hasNext()) {
                v.add((Ogranak)i.next());
            }
            String[] column = new String[]{"Oznaka", "Naziv", "Mesto", "Adresa"};
            this.model = new PzTreeTableModel(column, v);
            this.setTreeTableModel((TreeTableModel)this.model);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
        this.initGUI();
    }

    public PzTreeTable() {
        try {
            Vector<PzEntity> data = PzEntityManager.select("select e from Ogranak e");
            String[] columnNames = new String[]{"Naziv", "Oznaka", "Mesto", "Adresa", "Tip RJ"};
            PzTreeTableModel model = new PzTreeTableModel(columnNames, data);
            this.setTreeTableModel((TreeTableModel)model);
            this.model = model;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initGUI();
    }

    public PzTreeTable(String[] tipoviRJ) {
        try {
            Vector<PzEntity> data = PzEntityManager.select("select e from Ogranak e");
            for (PzEntity e : data) {
                Ogranak o = (Ogranak)e;
                if (o.getRadnajedinicas() == null || o.getRadnajedinicas().size() <= 0) continue;
                IndirectList radnejedinice = new IndirectList();
                for (Radnajedinica rj : o.getRadnajedinicas()) {
                    if (!this.isInList(tipoviRJ, rj)) continue;
                    radnejedinice.addElement((Object)rj);
                }
                o.setRadnajedinicas((List<Radnajedinica>)radnejedinice);
            }
            String[] columnNames = new String[]{"Naziv", "Oznaka", "Mesto", "Adresa", "Tip RJ"};
            PzTreeTableModel model = new PzTreeTableModel(columnNames, data);
            this.setTreeTableModel((TreeTableModel)model);
            this.model = model;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initGUI();
    }

    public PzTreeTable(String tip) {
        try {
            Vector<PzEntity> data = PzEntityManager.select("select e from Ogranak e");
            for (PzEntity e : data) {
                Ogranak o = (Ogranak)e;
                if (o.getRadnajedinicas() == null || o.getRadnajedinicas().size() <= 0) continue;
                IndirectList radnejedinice = new IndirectList();
                for (Radnajedinica rj : o.getRadnajedinicas()) {
                    if (!rj.getTip().startsWith(tip)) continue;
                    radnejedinice.addElement((Object)rj);
                }
                o.setRadnajedinicas((List<Radnajedinica>)radnejedinice);
            }
            String[] columnNames = new String[]{"Naziv", "Oznaka", "Mesto", "Adresa", "Tip RJ"};
            PzTreeTableModel model = new PzTreeTableModel(columnNames, data);
            this.setTreeTableModel((TreeTableModel)model);
            this.model = model;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initGUI();
    }

    private boolean isInList(String[] tipovi, Radnajedinica rj) {
        boolean res = false;
        int i = 0;
        while (i < tipovi.length) {
            if (tipovi[i].equals(rj.getTip())) {
                res = true;
                break;
            }
            ++i;
        }
        return res;
    }

    public void insert(PzEntity entity) {
        try {
            PzEntityManager.insert(entity);
            if (entity instanceof Ogranak) {
                this.model.addOgranak((Ogranak)entity);
            } else if (entity instanceof Radnajedinica) {
                TreePath path = null;
                path = this.getSelectedEntity() instanceof Ogranak ? this.getPathForRow(this.getSelectedRow()) : this.getPathForRow(this.getSelectedRow()).getParentPath();
                Ogranak ogranak = (Ogranak)path.getLastPathComponent();
                this.model.addRadnaJedinica(ogranak, path, (Radnajedinica)entity);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
        this.expandAll();
    }

    public void remove(TreePath path, Class<? extends PzEntity> c, Object key) {
        try {
            PzEntityManager.delete(c, key);
            this.model.remove(this.getSelectedEntity(), path);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
        this.expandAll();
    }

    public void removeSelectedEntity(boolean ask) {
        if (this.getSelectedEntity() == null) {
            return;
        }
        if (ask) {
            int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0);
            if (rez == 0) {
                this.remove(this.getPathForRow(this.getSelectedRow()), this.getSelectedEntity().getClass(), PzEntityUtil.getID(this.getSelectedEntity()));
            }
        } else {
            this.remove(this.getPathForRow(this.getSelectedRow()), this.getSelectedEntity().getClass(), PzEntityUtil.getID(this.getSelectedEntity()));
        }
    }

    public void update(Integer index, PzEntity entity) {
        try {
            PzEntityManager.update(entity);
            this.model.update(this.getPathForRow(index), entity);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
    }

    public void updateSelectedEntity(PzEntity newEntity) {
        try {
            PzEntityManager.update(newEntity);
            this.update(this.getSelectedRow(), newEntity);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
        }
    }

    public PzEntity getEntity(int index) {
        if (index != -1) {
            return (PzEntity)this.getPathForRow(index).getLastPathComponent();
        }
        return null;
    }

    public PzEntity getSelectedEntity() {
        return this.getEntity(this.getSelectedRow());
    }

    public Ogranak getCurrentOgranak() {
        Ogranak result = null;
        result = this.getSelectedEntity() instanceof Ogranak ? (Ogranak)this.getSelectedEntity() : ((Radnajedinica)this.getSelectedEntity()).getOgranak();
        return result;
    }

    public Vector<?> getEntities() {
        return (Vector)this.model.getRoot();
    }

    private void initGUI() {
        try {
            this.setTreeCellRenderer(new PzTreeTableCellRenderer());
            this.setShowHorizontalLines(false);
            this.setColumnControlVisible(true);
            this.addHighlighter(HighlighterFactory.createSimpleStriping());
            this.setFont(new Font("Ariel", 0, 14));
            this.getTableHeader().setFont(new Font("Ariel", 1, 14));
            this.getTableHeader().setSize(this.getWidth(), 25);
            this.requestFocusInWindow();
            this.scrollRectToVisible(this.getCellRect(0, 0, true));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                }
            });
            try {
                this.setRowSelectionInterval(0, 0);
                this.editCellAt(0, 0);
            }
            catch (Exception exception) {}
            this.expandAll();
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

