/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SwingManipulator {
    public static void addStandardEditingPopupMenu(JTextField[] fields) {
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem cutMenuItem = new JMenuItem("Cut", 116);
        cutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = popupMenu.getInvoker();
                if (c instanceof JTextField) {
                    ((JTextField)c).cut();
                }
            }
        });
        popupMenu.add(cutMenuItem);
        JMenuItem copyMenuItem = new JMenuItem("Copy", 67);
        copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = popupMenu.getInvoker();
                if (c instanceof JTextField) {
                    ((JTextField)c).copy();
                }
            }
        });
        popupMenu.add(copyMenuItem);
        JMenuItem pasteMenuItem = new JMenuItem("Paste", 80);
        pasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = popupMenu.getInvoker();
                if (c instanceof JTextField) {
                    ((JTextField)c).paste();
                }
            }
        });
        popupMenu.add(pasteMenuItem);
        popupMenu.addSeparator();
        JMenuItem selectAllMenuItem = new JMenuItem("Select All", 65);
        selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = popupMenu.getInvoker();
                if (c instanceof JTextField) {
                    ((JTextField)c).selectAll();
                }
            }
        });
        popupMenu.add(selectAllMenuItem);
        JTextField[] jTextFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            final JTextField f = jTextFieldArray[n2];
            f.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.processMouseEvent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.processMouseEvent(e);
                }

                private void processMouseEvent(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        popupMenu.show(e.getComponent(), e.getX(), e.getY());
                        popupMenu.setInvoker(f);
                    }
                }
            });
            ++n2;
        }
    }

    static String getTextJTextField(JTextField f) {
        try {
            return f.getText();
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    static char[] getPasswordJPasswordField(JPasswordField f) {
        try {
            return f.getPassword();
        }
        catch (NullPointerException nullPointerException) {
            return new char[0];
        }
    }

    public static void updateProgressBar(final JProgressBar progressBar, final String text, final int percent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (percent < 0 || percent > 100) {
                    progressBar.setString(text);
                    progressBar.setIndeterminate(true);
                } else {
                    progressBar.setValue(percent);
                    progressBar.setString(text);
                    progressBar.setIndeterminate(false);
                }
            }
        });
    }

    static int showOptionTextDialog(Component parentComponent, String label, String text, int rows, String title, int optionType, int messageType, Icon icon, Object[] options, int initialValue) throws HeadlessException {
        class ChoiceDialog
        implements Runnable {
            public int choiceIndex;
            private final /* synthetic */ Object[] val$options;
            private final /* synthetic */ int val$initialValue;
            private final /* synthetic */ String val$label;
            private final /* synthetic */ String val$text;
            private final /* synthetic */ int val$rows;
            private final /* synthetic */ Component val$parentComponent;
            private final /* synthetic */ String val$title;
            private final /* synthetic */ int val$optionType;
            private final /* synthetic */ int val$messageType;
            private final /* synthetic */ Icon val$icon;

            ChoiceDialog(Object[] objectArray, int n, String string, String string2, int n2, Component component, String string3, int n3, int n4, Icon icon) {
                this.val$options = objectArray;
                this.val$initialValue = n;
                this.val$label = string;
                this.val$text = string2;
                this.val$rows = n2;
                this.val$parentComponent = component;
                this.val$title = string3;
                this.val$optionType = n3;
                this.val$messageType = n4;
                this.val$icon = icon;
            }

            @Override
            public void run() {
                Object initialOption = null;
                if (this.val$options != null && this.val$initialValue >= 0 && this.val$initialValue < this.val$options.length) {
                    initialOption = this.val$options[this.val$initialValue];
                }
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)new JLabel(String.valueOf(this.val$label) + ":"), "North");
                JTextArea textArea = new JTextArea(this.val$text, this.val$rows, 50);
                textArea.setEditable(false);
                textArea.setWrapStyleWord(true);
                textArea.setLineWrap(true);
                textArea.setToolTipText(this.val$label);
                textArea.setFont(new Font("Dialog", 0, textArea.getFont().getSize() - 2));
                panel.add((Component)new JScrollPane(textArea, 20, 31), "Center");
                this.choiceIndex = JOptionPane.showOptionDialog(this.val$parentComponent, panel, this.val$title, this.val$optionType, this.val$messageType, this.val$icon, this.val$options, initialOption);
            }
        }
        ChoiceDialog r = new ChoiceDialog(options, initialValue, label, text, rows, parentComponent, title, optionType, messageType, icon);
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (Exception exception) {}
        }
        return r.choiceIndex;
    }

    public static void showErrorDialog(Component parent, String title, String message) {
        SwingManipulator.showOptionTextDialog(parent, "An error has occurred", message, 5, title, -1, 0, null, null, 0);
    }

    public static void showWarningDialog(Component parent, String title, String message) {
        SwingManipulator.showOptionTextDialog(parent, "A warning has been issued", message, 5, title, -1, 2, null, null, 0);
    }

    public static void showInfoDialog(Component parent, String title, String label, String message, int rows) {
        SwingManipulator.showOptionTextDialog(parent, label, message, rows, title, -1, 1, null, null, 0);
    }
}

