/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom;

import com.cloudgarden.resource.ArrayFocusTraversalPolicy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.core.PzApplication;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.custom.Logger;
import rs.pezar.swing.custom.login.PzConnection;
import rs.pezar.swing.custom.login.PzConnectionsConfigurationUtility;
import rs.pezar.swing.custom.login.PzDialogConnectionsConfiguration;
import rs.pezar.swing.fields.PzTextField;

public class PzLoginDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -8764493687439696327L;
    private JPanel panel;
    private PzButton btnConnConfiguration;
    private PzComboBox comboConnections;
    private PzButton btnOK;
    private JPasswordField txtPassword;
    private PzTextField txtUsername;
    private JLabel lblPassword;
    private JLabel lblUsername;
    private JLabel lblConnection;
    private PzPanel panelCredentials;
    private JLabel banner;
    private PzBusyPainterUI layerUI;
    private static boolean logged = false;
    private PzApplication application;
    private Vector<PzConnection> conns;

    public PzLoginDialog(PzApplication application) {
        this.conns = PzConnectionsConfigurationUtility.readConnections();
        this.initGUI();
        this.loadUserName();
        this.application = application;
    }

    private void loadUserName() {
        String uname = PzApplication.getApplication().getLocalMachineUserSettings().getString("KOR.IME");
        if (uname != null) {
            this.txtUsername.setVal(uname);
            this.txtPassword.requestFocusInWindow();
        }
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(3);
            this.setTitle("Pezar - prijava korisnika");
            this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/48x48.png")).getImage());
            this.panel = new JPanel();
            GridBagLayout panelLayout = new GridBagLayout();
            this.panel.setLayout(panelLayout);
            this.getContentPane().add((Component)this.panel, "Center");
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            this.banner = new JLabel();
            this.panel.add((Component)this.banner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.banner.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/loginbanner.jpg")));
            this.panelCredentials = new PzPanel();
            this.panelCredentials.setOpaque(false);
            this.panelCredentials.setTransferFocusOnEnter(true);
            GridBagLayout panelCredentialsLayout = new GridBagLayout();
            this.layerUI = new PzBusyPainterUI();
            JXLayer layer = new JXLayer((Component)this.panelCredentials, (LayerUI)this.layerUI);
            panelCredentialsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            panelCredentialsLayout.columnWeights = new double[]{0.0, 0.0};
            panelCredentialsLayout.columnWidths = new int[]{108, 300};
            panelCredentialsLayout.rowHeights = new int[]{21, 25, 25, 28, 30, 20};
            this.panelCredentials.setLayout(panelCredentialsLayout);
            this.panel.add((Component)layer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.lblUsername = new JLabel();
            this.panelCredentials.add((Component)this.lblUsername, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblUsername.setText("Korisni\u010dko ime:");
            this.lblUsername.setFont(new Font("Tahoma", 1, 12));
            this.lblPassword = new JLabel();
            this.panelCredentials.add((Component)this.lblPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblPassword.setText("Lozinka:");
            this.lblPassword.setFont(new Font("Tahoma", 1, 12));
            this.lblConnection = new JLabel();
            this.panelCredentials.add((Component)this.lblConnection, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblConnection.setText("Konekcija:");
            this.lblConnection.setFont(new Font("Tahoma", 1, 12));
            this.txtUsername = new PzTextField();
            this.txtUsername.setColumns(15);
            this.panelCredentials.add((Component)this.txtUsername, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.txtPassword = new JPasswordField();
            this.txtPassword.setColumns(15);
            this.panelCredentials.add((Component)this.txtPassword, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.txtPassword.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    PzLoginDialog.this.txtPasswordKeyReleased(evt);
                }
            });
            this.comboConnections = new PzComboBox();
            this.panelCredentials.add((Component)this.comboConnections, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 30), 0, 0));
            this.comboConnections.setModel(new DefaultComboBoxModel<PzConnection>(this.conns));
            String connection = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty("CONNECTION");
            this.comboConnections.setSelectedItem(PzConnection.findConnectionByName(this.conns, connection));
            this.btnConnConfiguration = new PzButton();
            this.btnConnConfiguration.setPreferredSize(new Dimension(30, 24));
            this.panelCredentials.add((Component)this.btnConnConfiguration, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 1, 1), 0, 0));
            this.btnConnConfiguration.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/gear_connection.png")));
            this.btnConnConfiguration.setToolTipText("Konfiguracija konekcija");
            this.btnConnConfiguration.addActionListener(this);
            this.btnConnConfiguration.setActionCommand("connConf");
            this.btnOK = new PzButton();
            this.panelCredentials.add((Component)this.btnOK, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(4, 0, 0, 0), 0, 0));
            this.btnOK.setText("Prijava");
            this.btnOK.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/check.png")));
            this.btnOK.addActionListener(this);
            this.btnOK.setActionCommand("login");
            this.btnOK.setPreferredSize(new Dimension(110, 30));
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setName("btnOK");
            this.setFocusTraversalPolicy(new ArrayFocusTraversalPolicy(new Component[]{this.txtUsername, this.txtPassword, this.btnOK}));
            this.pack();
            this.setSize(450, 310);
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("login")) {
            if (this.comboConnections.getSelectedIndex() == -1) {
                JOptionPane.showMessageDialog(this.getContentPane(), "Morate odabrati konekciju!", "Gre\u0161ka", 0);
                return;
            }
            PzConnection selectedConn = (PzConnection)this.comboConnections.getSelectedItem();
            PzApplication.getApplication().getLocalMachineUserSettings().setProperty("SERVER_ADDRESS", PzConnection.convertToServerAdress(selectedConn));
            PzApplication.getApplication().getLocalMachineUserSettings().setProperty("CONNECTION", selectedConn.toString());
            PzApplication.getApplication().initEMF();
            this.login();
        } else if (actionCommand.equals("connConf")) {
            PzDialogConnectionsConfiguration dlg = new PzDialogConnectionsConfiguration(this.conns);
            dlg.setVisible(true);
            this.conns = PzConnectionsConfigurationUtility.readConnections();
            this.comboConnections.setModel(new DefaultComboBoxModel<PzConnection>(this.conns));
            this.comboConnections.setSelectedIndex(-1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzLoginDialog(Boolean.FALSE);
    }

    public PzLoginDialog(Boolean initGUI) {
    }

    public static boolean logUser(final PzApplication application) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzLoginDialog dialog = new PzLoginDialog(application);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
        return logged;
    }

    private void login() {
        this.layerUI.setLocked(true);
        this.btnOK.setEnabled(false);
        Logger logger = new Logger(this, this.txtUsername.getText().trim(), new String(this.txtPassword.getPassword()));
        logger.execute();
    }

    public void loginFailed() {
        this.layerUI.setLocked(false);
        JOptionPane.showMessageDialog(this, "Niste uneli ispravno korisni\u010dko ime / lozinku", "Gre\u0161ka", 0);
        logged = false;
        this.btnOK.setEnabled(true);
        this.txtUsername.requestFocus();
    }

    public void wrongDatabase() {
        this.layerUI.setLocked(false);
        JOptionPane.showMessageDialog(this, "Pogre\u0161na baza podataka!", "Gre\u0161ka", 0);
        logged = false;
        this.btnOK.setEnabled(true);
        this.comboConnections.requestFocus();
    }

    public void loginForbidden() {
        this.layerUI.setLocked(false);
        JOptionPane.showMessageDialog(this, "Logovanje na sistem iz tehni\u010dkih razloga trenutno nije dozvoljeno. \nMolimo, poku\u0161ajte ponovo kasnije.", "Gre\u0161ka", 0);
        logged = false;
        this.btnOK.setEnabled(true);
    }

    public void loginSucceed() {
        this.layerUI.setLocked(false);
        logged = true;
        this.setVisible(false);
        this.dispose();
        this.application.runApplication();
    }

    public void unlockPanel() {
        this.layerUI.setLocked(false);
        this.btnOK.setEnabled(true);
    }

    private void txtPasswordKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            ((JPasswordField)evt.getSource()).transferFocus();
        }
    }
}

