/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom.login;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import rs.pezar.swing.custom.login.PzConnection;

public class ConnConfTableModel
extends AbstractTableModel {
    private final String[] columnNames = new String[]{"Naziv konfiguracije", "Server", "Baza"};
    private final Vector<PzConnection> data;

    public ConnConfTableModel(Vector<PzConnection> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        PzConnection conn = this.data.get(row);
        String ret = "";
        switch (col) {
            case 0: {
                ret = conn.getConnectionName();
                break;
            }
            case 1: {
                ret = conn.getServer();
                break;
            }
            case 2: {
                ret = conn.getDatabase();
            }
        }
        return ret;
    }

    public void setElementAt(int row, PzConnection conn) {
        this.data.set(row, conn);
        this.fireTableDataChanged();
    }

    public Vector<PzConnection> getData() {
        return this.data;
    }

    public void removeRow(int row) {
        this.data.remove(row);
        this.fireTableDataChanged();
    }

    public void insertElement(PzConnection conn) {
        this.data.add(conn);
        this.fireTableDataChanged();
    }

    public PzConnection getConnectionAt(int row) {
        if (this.data.size() > 0) {
            return this.data.get(row);
        }
        return null;
    }

    public int containsElement(PzConnection conn) {
        for (PzConnection curr : this.data) {
            if (!curr.getConnectionName().equals(conn.getConnectionName())) continue;
            return this.data.indexOf(curr);
        }
        return -1;
    }
}

