/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom.login;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import rs.pezar.core.PzApplication;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.swing.custom.login.PzConnection;

public class PzConnectionsConfigurationUtility {
    public static final String CONNECTION_CONFIGURATION_FILE_NAME = String.valueOf(PzApplication.getApplication().getConfigFolder().getPath()) + "\\pz_conn_conf.txt";

    public static void writeConnections(Vector<PzConnection> connections) {
        ObjectOutputStream outputStream = null;
        try {
            try {
                outputStream = new ObjectOutputStream(new FileOutputStream(CONNECTION_CONFIGURATION_FILE_NAME));
                for (PzConnection conn : connections) {
                    outputStream.writeObject(conn);
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                try {
                    if (outputStream != null) {
                        outputStream.flush();
                        outputStream.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    if (outputStream != null) {
                        outputStream.flush();
                        outputStream.close();
                    }
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Vector<PzConnection> readConnections() {
        ObjectInputStream inputStream = null;
        Vector<PzConnection> ret = new Vector<PzConnection>();
        try {
            try {
                inputStream = new ObjectInputStream(new FileInputStream(CONNECTION_CONFIGURATION_FILE_NAME));
                Object obj = null;
                while ((obj = inputStream.readObject()) != null) {
                    if (!(obj instanceof PzConnection)) continue;
                    ret.add((PzConnection)obj);
                }
            }
            catch (Exception exception) {
                new PzInfoException("Gre\u0161ka pri \u010ditanju konfiguracionog fajla!");
            }
        }
        catch (Throwable throwable) {}
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return ret;
    }
}

