/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.custom.login.ConnConfTableModel;
import rs.pezar.swing.custom.login.PzConnection;
import rs.pezar.swing.custom.login.PzConnectionsConfigurationUtility;
import rs.pezar.swing.custom.login.connections.DodavanjeConnConf;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogConnectionsConfiguration
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private JPanel mainPanel;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnKopiraj;
    private PzToolBarIcon icnBrisanje;
    private JXTable table;
    private JScrollPane scrollPane;
    private JToolBar toolbar;
    private Vector<PzConnection> connections;
    private PzConnection elementForSelection;

    public PzDialogConnectionsConfiguration(Vector<PzConnection> connections) {
        this.connections = connections;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setModal(true);
            this.setTitle("Konfiguracija konekcija");
            this.toolbar = new JToolBar();
            this.getContentPane().add((Component)this.toolbar, "North");
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setFloatable(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add(this.icnDodavanje);
            this.icnDodavanje.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/gear_add.png")));
            this.icnDodavanje.setText("Dodavanje|konfiguracije|(INS)");
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener(this);
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add(this.icnIzmena);
            this.icnIzmena.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/gear_edit.png")));
            this.icnIzmena.setText("Izmena|konfiguracije|(F3)");
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener(this);
            this.icnIzmena.setShortcut("F3");
            this.icnKopiraj = new PzToolBarIcon();
            this.toolbar.add(this.icnKopiraj);
            this.icnKopiraj.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/gears.png")));
            this.icnKopiraj.setText("Kopiranje|konfiguracije|(F4)");
            this.icnKopiraj.setActionCommand("Kopiranje");
            this.icnKopiraj.addActionListener(this);
            this.icnKopiraj.setShortcut("F4");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add(this.icnBrisanje);
            this.icnBrisanje.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/gear_delete.png")));
            this.icnBrisanje.setText("Brisanje|konfiguracije|(DEL)");
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener(this);
            this.icnBrisanje.setShortcut("DELETE");
            this.setSize(700, 400);
            this.setResizable(false);
            this.setLocationRelativeTo(null);
            this.mainPanel = new JPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            jPanel1Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7};
            jPanel1Layout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout(jPanel1Layout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setPreferredSize(new Dimension(592, 272));
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.scrollPane.setBackground(new Color(211, 242, 210));
            this.table = new JXTable((TableModel)new ConnConfTableModel(this.connections));
            this.table.setHorizontalScrollEnabled(true);
            this.table.setShowHorizontalLines(false);
            this.table.getTableHeader().setFont(new Font("SansSerif", 1, 12));
            this.table.getTableHeader().setSize(this.table.getWidth(), 25);
            this.table.setSelectionMode(0);
            this.table.addHighlighter(HighlighterFactory.createSimpleStriping());
            this.table.getTableHeader().setReorderingAllowed(false);
            this.scrollPane.setViewportView((Component)this.table);
            try {
                this.table.setRowSelectionInterval(0, 0);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        PzToolBarIcon icon = (PzToolBarIcon)arg0.getSource();
        String actionCommand = icon.getActionCommand();
        ConnConfTableModel myModel = (ConnConfTableModel)this.table.getModel();
        this.elementForSelection = null;
        if (actionCommand.equalsIgnoreCase("dodavanje")) {
            this.createAndShowDialog(myModel, false, -1);
        } else if (this.table.getSelectedRow() != -1) {
            if (actionCommand.equalsIgnoreCase("Brisanje")) {
                int rez = PzSwingUtility.daNeDijalog(this.mainPanel, "Da li ste sigurni da \u017eelite da obri\u0161ete odabranu konfiguraciju?", "Brisanje dokumenta", null, false);
                if (rez == 0) {
                    myModel.removeRow(this.table.convertRowIndexToModel(this.table.getSelectedRow()));
                    PzConnectionsConfigurationUtility.writeConnections(myModel.getData());
                    this.elementForSelection = myModel.getConnectionAt(0);
                }
            } else if (actionCommand.equalsIgnoreCase("Izmena")) {
                this.createAndShowDialog(myModel, true, this.table.convertRowIndexToModel(this.table.getSelectedRow()));
            } else {
                this.createAndShowDialog(myModel, false, this.table.convertRowIndexToModel(this.table.getSelectedRow()));
            }
        }
        PzConnectionsConfigurationUtility.writeConnections(myModel.getData());
        if (this.elementForSelection != null) {
            int selectedRow = myModel.containsElement(this.elementForSelection);
            this.table.setRowSelectionInterval(this.table.convertRowIndexToView(selectedRow), this.table.convertRowIndexToView(selectedRow));
        }
    }

    private void createAndShowDialog(ConnConfTableModel myModel, boolean update, int selectedRow) {
        DodavanjeConnConf dlg = new DodavanjeConnConf(myModel, update, update || selectedRow != -1 ? myModel.getConnectionAt(selectedRow) : null, this);
        if (update) {
            dlg.setSelectedRow(this.table.convertRowIndexToModel(this.table.getSelectedRow()));
        }
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    public Vector<PzConnection> getConnections() {
        return this.connections;
    }

    public void setConnections(Vector<PzConnection> connections) {
        this.connections = connections;
    }

    @Override
    protected void thisWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    public void setElementForSelection(PzConnection elementForSelection) {
        this.elementForSelection = elementForSelection;
    }
}

