/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.data.models;

import java.util.List;
import java.util.Vector;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.swing.data.models.PzAbstractTableModel;
import rs.pezar.swing.event.PzTableCheckboxListener;

public abstract class PzManageableTableModel
extends PzAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Vector<PzTableCheckboxListener> listeners;
    private PzEntityFilter filter;
    private Class<? extends PzEntity> entityClass;
    protected String[] columnNames;
    protected Vector<Boolean> selected;
    private int checkBoxColumn = -1;

    public abstract void remove(int var1);

    public abstract void insert(PzEntity var1);

    public abstract void update(int var1, PzEntity var2);

    public abstract PzEntity getEntity(int var1);

    public void setFilter(PzEntityFilter filter) {
        if (filter == null) {
            return;
        }
        this.filter = filter;
        this.columnNames = filter.getColumnNames();
        this.fireTableStructureChanged();
    }

    public PzEntityFilter getFilter() {
        return this.filter;
    }

    public void setEntityClass(Class<? extends PzEntity> entityClass) {
        try {
            Class<? extends PzEntity> old = this.entityClass;
            this.entityClass = entityClass;
            if (this.getFilter() == null) {
                if (old != entityClass) {
                    this.columnNames = entityClass.newInstance().getColumnNames();
                }
            } else {
                this.columnNames = this.getFilter().getColumnNames();
            }
        }
        catch (Exception exception) {}
    }

    public Class<? extends PzEntity> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.getRowCount() == 0) {
            return null;
        }
        if (this.checkBoxColumn != -1) {
            if (columnIndex == this.checkBoxColumn) {
                return this.selected.elementAt(rowIndex);
            }
            if (columnIndex > this.checkBoxColumn) {
                --columnIndex;
            }
        }
        return this.getFilter() != null ? this.getFilter().getValues(this.getEntity(rowIndex))[columnIndex] : this.getEntity(rowIndex).getValues()[columnIndex];
    }

    @Override
    public synchronized int getColumnCount() {
        if (this.columnNames != null) {
            return this.checkBoxColumn != -1 ? this.columnNames.length + 1 : this.columnNames.length;
        }
        if (this.getRowCount() > 0) {
            return this.getEntity(0).getColumnNames().length;
        }
        if (this.getFilter() != null) {
            return this.getFilter().getColumnNames().length;
        }
        return 0;
    }

    @Override
    public synchronized String getColumnName(int columnIndex) {
        if (this.checkBoxColumn != -1) {
            if (this.checkBoxColumn == columnIndex) {
                return "";
            }
            if (columnIndex > this.checkBoxColumn) {
                --columnIndex;
            }
        }
        return this.columnNames != null ? this.columnNames[columnIndex] : (this.getRowCount() > 0 ? this.getEntity(0).getColumnNames()[columnIndex] : null);
    }

    public void setCheckBoxColumn(int checkBoxColumn) {
        this.resetCheckboxes();
        this.checkBoxColumn = checkBoxColumn;
        this.fireTableStructureChanged();
    }

    protected void resetCheckboxes() {
        this.selected = new Vector();
        int i = 0;
        while (i < this.getRowCount()) {
            this.selected.add(Boolean.FALSE);
            ++i;
        }
    }

    public int getCheckBoxColumn() {
        return this.checkBoxColumn;
    }

    public void insertCheckBoxRowAt(int index) {
        if (this.checkBoxColumn != -1 && this.selected != null) {
            this.selected.add(index, false);
        }
    }

    public void removeCheckBoxRow(int index) {
        if (this.checkBoxColumn != -1 && this.selected != null) {
            this.selected.remove(index);
        }
    }

    protected void recreateCheckboxColumn() {
        if (this.getCheckBoxColumn() != -1) {
            this.setCheckBoxColumn(this.getCheckBoxColumn());
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == this.checkBoxColumn;
    }

    @Override
    public void setValueAt(Object arg0, int rowIndex, int columnIndex) {
        if (columnIndex == this.checkBoxColumn) {
            this.selected.setElementAt((Boolean)arg0, rowIndex);
            this.fireCheckboxValueChanged(rowIndex, this.getEntity(rowIndex), (Boolean)arg0);
        }
        super.setValueAt(arg0, rowIndex, columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == this.checkBoxColumn ? Boolean.class : Object.class;
    }

    public void setRowChecked(int rowIndex, boolean checked) {
        if (this.checkBoxColumn != -1 && rowIndex != -1 && !this.selected.elementAt(rowIndex).equals(checked)) {
            this.setValueAt(checked, rowIndex, this.checkBoxColumn);
        }
    }

    public boolean isRowChecked(int rowIndex) {
        if (this.checkBoxColumn == -1) {
            return false;
        }
        return this.selected != null ? this.selected.elementAt(rowIndex) : false;
    }

    public List<PzEntity> getCheckedEntities() {
        if (this.checkBoxColumn == -1) {
            return null;
        }
        Vector<PzEntity> result = new Vector<PzEntity>();
        int i = 0;
        while (i < this.selected.size()) {
            if (this.selected.elementAt(i).booleanValue()) {
                result.addElement(this.getEntity(i));
            }
            ++i;
        }
        return result;
    }

    public void checkAll() {
        if (this.getCheckBoxColumn() != -1 && this.selected != null) {
            int i = 0;
            while (i < this.getRowCount()) {
                this.setRowChecked(i, true);
                ++i;
            }
        }
    }

    public void unCheckAll() {
        if (this.getCheckBoxColumn() != -1 && this.selected != null) {
            int i = 0;
            while (i < this.getRowCount()) {
                this.setRowChecked(i, false);
                ++i;
            }
        }
    }

    public void addCheckboxListener(PzTableCheckboxListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public void fireCheckboxValueChanged(int row, PzEntity entity, boolean value) {
        if (this.getCheckBoxColumn() == -1) {
            return;
        }
        if (this.listeners != null) {
            for (PzTableCheckboxListener listener : this.listeners) {
                listener.valueChanged(row, entity, value);
            }
        }
        this.fireTableCellUpdated(row, this.getCheckBoxColumn());
    }

    public void removeCheckBoxListener(PzTableCheckboxListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void refresh() {
        if (this.getRowCount() > 0) {
            this.recreateCheckboxColumn();
        }
        if (this.columnNames == null) {
            if (this.getRowCount() > 0) {
                this.columnNames = this.getEntity(0).getColumnNames();
            }
            this.fireTableStructureChanged();
        } else if (this.getRowCount() > 0) {
            this.fireTableDataChanged();
        }
    }

    public void inverseCheck() {
        if (this.getCheckBoxColumn() != -1 && this.selected != null) {
            int i = 0;
            while (i < this.getRowCount()) {
                this.setRowChecked(i, !this.isRowChecked(i));
                ++i;
            }
        }
    }
}

