/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.fields;

import javax.swing.text.DefaultFormatterFactory;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.util.RegexFormatter;

public class PzNumericOnlyTextField
extends PzFieldImpl {
    private static final long serialVersionUID = 8228465685442266250L;
    private boolean parseInput;

    public PzNumericOnlyTextField() {
        RegexFormatter formatter = new RegexFormatter("\\d{0,9}");
        DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter, formatter, formatter);
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        this.setFormatterFactory(factory);
        this.setHorizontalAlignment(4);
        this.parseInput = true;
    }

    public void setMaxLength(int length) {
        RegexFormatter formatter = new RegexFormatter("\\d{0," + length + "}");
        DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter, formatter, formatter);
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        this.setFormatterFactory(factory);
        this.setHorizontalAlignment(4);
    }

    public int getIntVal() {
        return !super.getText().equals("") ? Integer.parseInt(super.getText()) : 0;
    }

    @Override
    public String getVal() {
        String rez = this.getText().replaceAll("^0+", "");
        if (rez.equals("")) {
            rez = "0";
        }
        return rez;
    }

    @Override
    public void setVal(Object value) {
        if (value == null) {
            return;
        }
        this.setText(value.toString());
    }

    @Override
    public boolean isValueValid() {
        return !this.getVal().equals("0");
    }

    public void setParseInput(boolean parseInput) {
        this.parseInput = parseInput;
    }

    public boolean shouldParseInput() {
        return this.parseInput;
    }
}

