/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.util;

import com.jxcell.View;
import com.jxcell.designer.Designer;
import java.awt.Desktop;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class TableExportUtil {
    public static final int OPTION_DO_NOT_OPEN = 1;
    public static final int OPTION_OPEN_INTERNAL = 2;
    public static final int OPTION_OPEN_EXTERNAL = 3;

    public static void exportToXls(final JTable table, final File file, int option) {
        if (file == null) {
            return;
        }
        PzWorkerDialog.showStatus("Export podataka u toku. Molim, sa\u010dekajte.", (PzDialog)SwingUtilities.getRoot(table));
        PzWorkerDialog.getDialogInstance().setProgresSize(0, table.getRowCount());
        SwingWorker<WritableWorkbook, Integer> worker = new SwingWorker<WritableWorkbook, Integer>(){

            @Override
            protected WritableWorkbook doInBackground() throws Exception {
                WritableWorkbook workbook = Workbook.createWorkbook((File)file);
                WritableSheet sheet = workbook.createSheet("Sheet 1", 0);
                Label cell = null;
                int i = 0;
                while (i < table.getColumnCount()) {
                    cell = new Label(i, 0, table.getColumnName(i));
                    sheet.addCell((WritableCell)cell);
                    ++i;
                }
                i = 1;
                while (i < table.getRowCount() + 1) {
                    int j = 0;
                    while (j < table.getColumnCount()) {
                        WritableCellFormat format;
                        Object value = table.getValueAt(i - 1, j);
                        if (value instanceof Date) {
                            java.util.Date dat = new java.util.Date(((Date)value).getTime());
                            DateFormat df = new DateFormat("dd.MM.yyyy");
                            WritableCellFormat format2 = new WritableCellFormat((DisplayFormat)df);
                            cell = new DateTime(j, i, dat, (CellFormat)format2);
                        } else if (value instanceof Double) {
                            format = new WritableCellFormat(NumberFormats.THOUSANDS_FLOAT);
                            cell = new Number(j, i, ((Double)value).doubleValue(), (CellFormat)format);
                        } else if (value instanceof BigDecimal) {
                            format = new WritableCellFormat(NumberFormats.THOUSANDS_FLOAT);
                            cell = new Number(j, i, ((BigDecimal)value).doubleValue(), (CellFormat)format);
                        } else if (value instanceof Integer) {
                            format = new WritableCellFormat(NumberFormats.INTEGER);
                            cell = new Number(j, i, (double)((Integer)value).intValue(), (CellFormat)format);
                        } else {
                            cell = new Label(j, i, String.valueOf(value));
                        }
                        sheet.addCell((WritableCell)cell);
                        this.publish(i);
                        ++j;
                    }
                    ++i;
                }
                return workbook;
            }

            @Override
            protected void process(List<Integer> chunks) {
                Iterator<Integer> iterator = chunks.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    PzWorkerDialog.getDialogInstance().incProgress(1);
                }
            }

            @Override
            protected void done() {
                try {
                    try {
                        WritableWorkbook workbook = (WritableWorkbook)this.get();
                        workbook.write();
                        workbook.close();
                        PzChoice[] choices = new PzChoice[]{new PzChoice("Ne", 1), new PzChoice("Da, kroz interni editor ", 2), new PzChoice("Da, kroz eksterni editor", 3)};
                        Integer chc = (Integer)PzDialogChoice.showPzDialogChoice(PzSwingUtility.getActiveDialog(), choices, "\u017delite li da otvorite eksportovani fajl?");
                        if (chc.equals(2)) {
                            View view = new View();
                            view.read(file.getPath());
                            Designer.newDesigner((View)view);
                        } else if (chc.equals(3)) {
                            Desktop.getDesktop().open(file);
                        }
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle(table, e);
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }
}

