/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.gui.pretraga.criteria.Condition;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.RabatnaPolitika;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzDateUtility;

public class RabatnaPolitikaManager {
    public static final String SERVICE_ID = "RABATNA_POLITIKA_MANAGER";
    List<RabatnaPolitika> politike;
    private JComponent statusbar;
    private JLabel lblStatus;
    private Komitent komitent;

    public List<RabatnaPolitika> load() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        Query q = em.createQuery("SELECT p FROM RabatnaPolitika p WHERE p.aktivna=1");
        List politike = q.getResultList();
        em.close();
        return politike;
    }

    public List<RabatnaPolitika> getRabatnePolitike(Stanjeartikal a, Komitent k) throws Exception {
        ArrayList<RabatnaPolitika> res = new ArrayList<RabatnaPolitika>();
        if (a != null && k != null) {
            RabatnaPolitika permanentna = null;
            int count = 0;
            for (RabatnaPolitika p : this.politike) {
                Date danas;
                if (p.getDatDo() != null && p.getDatOd() != null && ((danas = PzDateUtility.getCurrentDate()).toString().compareTo(p.getDatOd().toString()) < 0 || danas.toString().compareTo(p.getDatDo().toString()) > 0)) continue;
                Condition artikalCondition = Condition.getRootCondition(p.getKondGrupaArtikli());
                Condition komitentCondition = Condition.getRootCondition(p.getKondGrupaKomitenti());
                if (!artikalCondition.satisfies(a) || !komitentCondition.satisfies(k)) continue;
                res.add(p);
                if (p.getTip() != 1) continue;
                permanentna = p;
                ++count;
            }
            if (count > 1) {
                throw new RabatnaPolitikaException("Za trazeni artikal i komitenta postoji vise od jedne rabatne politike koja je oznacena permanentnom sto nije dozvoljeno");
            }
            if (count == 1) {
                res.clear();
                res.add(permanentna);
            }
        }
        return res;
    }

    public static BigDecimal calculateRabat(List<RabatnaPolitika> rabPolitike) {
        BigDecimal res = new BigDecimal("0.00");
        for (RabatnaPolitika rabatnaPolitika : rabPolitike) {
            res = res.add(rabatnaPolitika.getProcenat());
        }
        return BDConverter.getProcRabata100(res.doubleValue());
    }

    public void loadRabatnePolitikeZaKomitenta(JComponent c, Komitent komitent) {
        this.komitent = komitent;
        this.statusbar = c;
        this.lblStatus = new JLabel("U\u010ditavanje rabatnih politika za komitenta ... ");
        this.statusbar.add(this.lblStatus);
        if (komitent != null) {
            this.executeLoad();
        } else {
            PzApplication.getApplication().getSession().getRuntimeStore().put("RPM_TEKUCI_KOMITENT", null);
        }
    }

    private void executeLoad() {
        SwingWorker<List<RabatnaPolitika>, Object> worker = new SwingWorker<List<RabatnaPolitika>, Object>(){

            @Override
            protected List<RabatnaPolitika> doInBackground() throws Exception {
                List<RabatnaPolitika> rpolitike = RabatnaPolitikaManager.this.load();
                Iterator<RabatnaPolitika> iterator = rpolitike.iterator();
                while (iterator.hasNext()) {
                    RabatnaPolitika rabatnaPolitika = iterator.next();
                    Condition cond = Condition.getRootCondition(rabatnaPolitika.getKondGrupaKomitenti());
                    if (cond.satisfies(RabatnaPolitikaManager.this.komitent)) continue;
                    iterator.remove();
                }
                return rpolitike;
            }

            @Override
            protected void done() {
                try {
                    RabatnaPolitikaManager.this.politike = (List)this.get();
                    RabatnaPolitikaManager.this.lblStatus.setText(String.valueOf(RabatnaPolitikaManager.this.lblStatus.getText()) + "OK");
                    PzApplication.getApplication().getSession().getRuntimeStore().put("RPM_TEKUCI_KOMITENT", RabatnaPolitikaManager.this);
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle(e);
                    RabatnaPolitikaManager.this.lblStatus.setText(String.valueOf(RabatnaPolitikaManager.this.lblStatus.getText()) + "GRESKA");
                    PzApplication.getApplication().getSession().getRuntimeStore().put("RPM_TEKUCI_KOMITENT", null);
                }
            }
        };
        worker.execute();
    }

    public void primeniRabat(Stanjeartikal a) throws Exception {
        if (this.politike != null && a != null) {
            a.setRabat(RabatnaPolitikaManager.calculateRabat(this.getRabatnePolitike(a, this.komitent)));
        }
    }

    public static class RabatnaPolitikaException
    extends Exception {
        private static final long serialVersionUID = -7202604081941953914L;

        public RabatnaPolitikaException(String message) {
            super(message);
        }
    }
}

