/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval;

import java.util.Enumeration;

public class ArgumentTokenizer
implements Enumeration {
    public final char defaultDelimiter = (char)44;
    private String arguments = null;
    private char delimiter = (char)44;
    private char quoteCharacter;

    public ArgumentTokenizer(String arguments, char delimiter, char quoteCharacter) {
        this.arguments = arguments;
        this.delimiter = delimiter;
        this.quoteCharacter = quoteCharacter;
    }

    public ArgumentTokenizer(String arguments, char delimiter) {
        this(arguments, delimiter, '\'');
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        return this.arguments.length() > 0;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        int charCtr = 0;
        int size = this.arguments.length();
        int parenthesesCtr = 0;
        int quotesCtr = 0;
        int quotesSgn = -1;
        String returnArgument = null;
        while (charCtr < size) {
            if (this.arguments.charAt(charCtr) == '(') {
                ++parenthesesCtr;
            } else if (this.arguments.charAt(charCtr) == ')') {
                --parenthesesCtr;
            } else if (this.arguments.charAt(charCtr) == this.quoteCharacter) {
                if (charCtr == 0 || this.arguments.charAt(charCtr - 1) != '\\') {
                    quotesSgn = -quotesSgn;
                    quotesCtr += quotesSgn;
                }
            } else if (this.arguments.charAt(charCtr) == this.delimiter && parenthesesCtr == 0 && quotesCtr == 0) {
                returnArgument = this.arguments.substring(0, charCtr);
                this.arguments = this.arguments.substring(charCtr + 1);
                break;
            }
            ++charCtr;
        }
        if (returnArgument == null) {
            returnArgument = this.arguments;
            this.arguments = "";
        }
        return returnArgument;
    }
}

