/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.samples;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.jeval.EvaluationException;
import net.sourceforge.jeval.Evaluator;

public class LoopingWithVariablesSample {
    public static void main(String[] args) {
        Evaluator evaluator = new Evaluator();
        ArrayList table = new ArrayList();
        LoopingWithVariablesSample.loadData(table, 50, 3);
        try {
            int numRows = table.size();
            int rowNum = 0;
            while (rowNum < numRows) {
                List row = (List)table.get(rowNum);
                Long a = (Long)row.get(0);
                Long b = (Long)row.get(1);
                Long c = (Long)row.get(2);
                evaluator.putVariable("a", a.toString());
                evaluator.putVariable("b", b.toString());
                evaluator.putVariable("c", c.toString());
                long startTime = new Date().getTime();
                String result = evaluator.evaluate("#{a} >= 2 && #{b} >= 5 && #{c} >= 8");
                long endTime = new Date().getTime();
                System.out.println("Execution time (row number = " + rowNum + "):" + (endTime - startTime) + " ms");
                if (result.equals("1.0")) {
                    System.out.println("Row number " + rowNum + " meets our criteria. A=" + a + " B=" + b + " C=" + c);
                }
                ++rowNum;
            }
        }
        catch (EvaluationException ee) {
            System.out.println(ee);
        }
    }

    private static void loadData(List table, int numRows, int numColumns) {
        int rowNum = 0;
        while (rowNum < numRows) {
            ArrayList<Long> row = new ArrayList<Long>();
            int columnNum = 0;
            while (columnNum < numColumns) {
                Long dataValue = Math.round(Math.random() * 10.0);
                row.add(dataValue);
                ++columnNum;
            }
            table.add(row);
            ++rowNum;
        }
    }
}

