/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.engine.internal;

import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.jxpath.JXPathContext;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.finansije.engine.DokumentCompilerException;
import rs.pezar.util.PzExpressionParser;

public class ExpressionParser {
    private static final String FIELD_PATTERN = "DOK\\{.+?\\}";
    private static final String LIST_PATTERN = "LIST\\{.+?\\}";
    private static final String FUNCTION_PATTERN = "\\$.+?\\(.+?\\)";

    public static Object parseDoubleExpression(String expression, PzDokument dokument) throws DokumentCompilerException {
        String oName;
        String expRes = new String(expression);
        Pattern pattern = Pattern.compile(FIELD_PATTERN);
        Matcher m = pattern.matcher(expression);
        new Vector();
        while (m.find()) {
            oName = m.group();
            String fName = oName.substring(4, oName.length() - 1);
            try {
                expRes = expRes.replace(oName, JXPathContext.newContext((Object)dokument).getValue(fName).toString());
            }
            catch (Exception e) {
                throw new DokumentCompilerException("Greska prilikom pristupa polju '" + fName + "' dokumenta " + dokument.getClass().getSimpleName(), e);
            }
        }
        expRes = expRes.replaceAll(FIELD_PATTERN, "0");
        pattern = Pattern.compile(LIST_PATTERN);
        m = pattern.matcher(expRes);
        String list = "";
        while (m.find()) {
            oName = m.group();
            String lName = oName.substring(5, oName.length() - 1);
            Iterator i = JXPathContext.newContext((Object)dokument).iterate(lName);
            list = "";
            while (i.hasNext()) {
                list = String.valueOf(list) + i.next() + ",";
            }
            if (list.endsWith(",")) {
                list = list.substring(0, list.length() - 1);
            }
            expRes = expRes.replace(oName, list);
        }
        expRes = expRes.replaceAll(LIST_PATTERN, "0");
        try {
            return BDConverter.getIznos((double)PzExpressionParser.getDouble((String)expRes));
        }
        catch (Exception e) {
            throw new DokumentCompilerException("Greska prilikom izracunavanja izraza : " + expression + "[[ " + expRes + " ]]", e);
        }
    }

    public static String parseStringExpression(String opis, PzDokument dokument) throws DokumentCompilerException {
        Pattern pattern = Pattern.compile(FIELD_PATTERN);
        String expRes = new String(opis);
        Matcher m = pattern.matcher(opis);
        new Vector();
        while (m.find()) {
            String oName = m.group();
            String fName = oName.substring(4, oName.length() - 1);
            try {
                expRes = expRes.replace(oName, PropertyUtils.getProperty((Object)dokument, (String)fName).toString());
            }
            catch (Exception e) {
                throw new DokumentCompilerException("Greska prilikom pristupa polju '" + fName + "' dokumenta " + dokument.getClass().getSimpleName(), e);
            }
        }
        pattern = Pattern.compile(FUNCTION_PATTERN);
        m = pattern.matcher(expRes);
        String function = "";
        String rFunction = "";
        String result = new String(expRes);
        try {
            while (m.find()) {
                function = m.group();
                rFunction = function.substring(1).replace("(", "('").replace(")", "')");
                result = result.replace(function, PzExpressionParser.getString((String)rFunction).replace("'", ""));
            }
            return result;
        }
        catch (Exception e) {
            throw new DokumentCompilerException("Greska prilikom parsiranja izraza : " + rFunction, e);
        }
    }

    public static Boolean parseBooleanExpression(String expression, PzDokument dokument) throws DokumentCompilerException {
        String oName;
        String expRes = new String(expression);
        Pattern pattern = Pattern.compile(FIELD_PATTERN);
        Matcher m = pattern.matcher(expression);
        new Vector();
        while (m.find()) {
            oName = m.group();
            String fName = oName.substring(4, oName.length() - 1);
            try {
                Object value = JXPathContext.newContext((Object)dokument).getValue(fName);
                if (value instanceof String) {
                    expRes = expRes.replace(oName, "'" + value.toString() + "'");
                    continue;
                }
                expRes = expRes.replace(oName, value.toString());
            }
            catch (Exception e) {
                throw new DokumentCompilerException("Greska prilikom pristupa polju '" + fName + "' dokumenta " + dokument.getClass().getSimpleName(), e);
            }
        }
        expRes = expRes.replaceAll(FIELD_PATTERN, "0");
        pattern = Pattern.compile(LIST_PATTERN);
        m = pattern.matcher(expRes);
        while (m.find()) {
            String list = "";
            oName = m.group();
            String lName = oName.substring(5, oName.length() - 1);
            Iterator i = JXPathContext.newContext((Object)dokument).iterate(lName);
            while (i.hasNext()) {
                list = String.valueOf(list) + i.next() + ",";
            }
            if (!list.endsWith(",")) continue;
            list = list.substring(0, list.length() - 1);
            expRes = expRes.replace(oName, list);
        }
        expRes = expRes.replaceAll(LIST_PATTERN, "0");
        try {
            return PzExpressionParser.getBoolean((String)expRes);
        }
        catch (Exception e) {
            throw new DokumentCompilerException("Greska prilikom izracunavanja izraza : " + expression + " | " + expRes, e);
        }
    }
}

