/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.engine.izvod.uplataLoader;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.persistence.queries.FetchGroup;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Uplata;
import rs.pezar.finansije.engine.izvod.TransakcijaIzvodaBanke;
import rs.pezar.finansije.engine.izvod.uplataLoader.UplataLoader;
import rs.pezar.finansije.gui.izvod.uplate.PnlUplataPoRacunu;
import rs.pezar.finansije.gui.izvod.uplate.UplataComponent;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;

public class UplataByRacunKupcaLoader
implements UplataLoader {
    @Override
    public List<Uplata> getUplate(Komitent k, TransakcijaIzvodaBanke t, BigDecimal iznos, EntityManager em) {
        ArrayList<Uplata> uplate = new ArrayList<Uplata>();
        BigDecimal ostatak = iznos;
        final String pb = t.getPozivNaBroj();
        Query q = this.createQuery(k, em, "f");
        FetchGroup grp = new FetchGroup();
        grp.addAttribute("iznos");
        grp.addAttribute("stornoIznos");
        grp.addAttribute("uplata");
        grp.addAttribute("idDok");
        grp.addAttribute("oznDokumenta");
        grp.addAttribute("datum");
        grp.addAttribute("tip");
        grp.addAttribute("podTip");
        grp.addAttribute("pb");
        grp.addAttribute("radnajedinica");
        q.setHint("eclipselink.fetch-group", (Object)grp);
        List fakture = q.getResultList();
        Collections.sort(fakture, new Comparator<Faktura>(){

            @Override
            public int compare(Faktura o1, Faktura o2) {
                String pb1 = o1.getPb();
                String pb2 = o2.getPb();
                if (pb1 != null && pb1.equals(pb)) {
                    return -1;
                }
                if (pb2 != null && pb2.equals(pb)) {
                    return 1;
                }
                return o1.getDatValute().compareTo(o2.getDatValute());
            }
        });
        boolean jos = true;
        Iterator iterator = fakture.iterator();
        while (iterator.hasNext() && jos) {
            Faktura faktura = (Faktura)iterator.next();
            Uplata uplata = this.createUplataFaktura(faktura, k);
            if (ostatak.compareTo(new BigDecimal("0")) > 0) {
                if (faktura.getDug().compareTo(ostatak) <= 0) {
                    uplata.setIznos(faktura.getDug());
                    ostatak = ostatak.subtract(faktura.getDug());
                    faktura.setUplata(faktura.getUplata().add(faktura.getDug()));
                } else {
                    faktura.setUplata(faktura.getUplata().add(ostatak));
                    uplata.setIznos(ostatak);
                    ostatak = new BigDecimal("0");
                }
            }
            uplate.add(uplata);
            if (faktura.getPb() == null || !faktura.getPb().equals(pb) || ostatak.compareTo(new BigDecimal("0.00")) != 0) continue;
            jos = false;
        }
        return uplate;
    }

    @Override
    public void rebuildUplate(List<Uplata> uplate, String strana, BigDecimal iznos) {
        BigDecimal ostatak = iznos;
        for (Uplata uplata : uplate) {
            Faktura faktura = (Faktura)uplata.getDokumentUpl();
            if (ostatak.compareTo(new BigDecimal("0")) <= 0) continue;
            if (faktura.getDug().compareTo(ostatak) <= 0) {
                uplata.setIznos(faktura.getDug());
                ostatak = ostatak.subtract(faktura.getDug());
                faktura.setUplata(faktura.getUplata().add(faktura.getDug()));
                continue;
            }
            faktura.setUplata(faktura.getUplata().add(ostatak));
            uplata.setIznos(ostatak);
            ostatak = new BigDecimal("0");
        }
    }

    @Override
    public boolean primenjujeSe(Komitent k, TransakcijaIzvodaBanke t, EntityManager em) {
        return t.getStrana().equals("ODOBRENJE") && (Long)this.createQuery(k, em, "COUNT(f)").getSingleResult() > 0L;
    }

    private Uplata createUplataFaktura(Faktura faktura, Komitent k) {
        Uplata uplata = new Uplata();
        uplata.setDatum(PzDateUtility.getCurrentDate());
        uplata.setPoDokumentu(faktura.getIdDok());
        uplata.setOznDokumenta(faktura.getOznDokumenta());
        uplata.setTipDokumentaUpl(faktura.getTip());
        uplata.setKomitent(k);
        uplata.setRadnajedinica(faktura.getRadnajedinica());
        uplata.setTip(TipDokumentConfig.get().UPLATA_KUPCA);
        uplata.setPodTip(TipDokumentConfig.get().PODTIP_UPLATA_VIRMAN);
        uplata.setDokumentUpl((PzDokument)faktura);
        return uplata;
    }

    @Override
    public UplataComponent getGUIComponent(Uplata u) {
        return new PnlUplataPoRacunu(u);
    }

    private Query createQuery(Komitent k, EntityManager em, String e) {
        ArrayList<String> tipovi = new ArrayList<String>();
        tipovi.add(TipDokumentConfig.get().FAKTURA);
        tipovi.add(TipDokumentConfig.get().FAKTURA_USLUGA);
        tipovi.add(TipDokumentConfig.get().FAKTURA_SERVISA);
        Query q = em.createQuery("SELECT " + e + " FROM Faktura f JOIN FETCH f.radnajedinica WHERE f.arhiviran=1 AND f.komitent=:k AND f.iznos-f.stornoIznos-f.uplata > 0 AND f.tip IN :tipovi AND f.storno=0 ORDER by f.datValute ASC");
        q.setParameter("k", (Object)k);
        q.setParameter("tipovi", tipovi);
        return q;
    }
}

