/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.entity.Nzk;
import rs.pezar.finansije.PzExtensionLoader;
import rs.pezar.finansije.gui.PzDialogUpitUNalogZaKnjizenje;
import rs.pezar.finansije.gui.nalogZaKnjizenje.IzmenaOpisa;
import rs.pezar.finansije.gui.nalogZaKnjizenje.PzDialogIzradaNaloga;
import rs.pezar.finansije.gui.util.LockUtility;
import rs.pezar.finansije.gui.util.NaloziTableCellRenderer;
import rs.pezar.finansije.gui.util.Tools;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogNalozi
extends PzDialog {
    private static final long serialVersionUID = 4397023903288929764L;
    private final JPanel contentPanel = new JPanel();
    private PzToolBar toolbar;
    private PzPanel pnlTable;
    private JScrollPane scp;
    private PzTable table;
    private JLabel numUkupnoNaloga;
    private JLabel lblUkupnoNaloga;
    private PzToolBarIcon icnNovNalog;
    private EntityManager em;
    private PzStatusBar statusBar;
    private PzToolBarIcon icnIzmena;

    public PzDialogNalozi() {
        this.initGUI();
    }

    public PzDialogNalozi(JFrame frame) {
        super(frame);
    }

    public boolean shouldBeShown() {
        this.em = PzEntityManagerFactory.getInstance().createEm();
        this.getSession().putParameter("em", (Object)this.em);
        this.initGUI();
        this.setTableData();
        return true;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        this.em.close();
        super.thisWindowClosing(evt);
    }

    private void initGUI() {
        this.setTitle("Nalozi za knji\u017eenje");
        this.setBounds(100, 100, 450, 300);
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.toolbar = new PzToolBar();
        this.contentPanel.add((Component)this.toolbar, "North");
        this.icnNovNalog = new PzToolBarIcon();
        this.icnNovNalog.addActionListener((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = -5378169203543812683L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzDialogNalozi.this.actionPerformedicnNovNalog(arg0);
            }
        });
        this.icnNovNalog.setShortcut("insert");
        this.icnNovNalog.setText("Novi nalog|(INS)");
        this.icnNovNalog.setIcon((Icon)new ImageIcon(PzDialogNalozi.class.getResource("/rs/pezar/finansije/resource/img/nzk.png")));
        this.toolbar.add((Component)this.icnNovNalog);
        this.icnIzmena = new PzToolBarIcon();
        this.icnIzmena.addActionListener((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = -5378169203543812683L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzDialogNalozi.this.actionPerformedicnIzmena(arg0);
            }
        });
        this.icnIzmena.setShortcut("F3");
        this.icnIzmena.setText("Izmeni opis|(F3)");
        this.icnIzmena.setIcon((Icon)new ImageIcon(PzDialogNalozi.class.getResource("/rs/pezar/finansije/resource/img/nzk.png")));
        this.toolbar.add((Component)this.icnIzmena);
        this.pnlTable = new PzPanel();
        this.contentPanel.add((Component)this.pnlTable, "Center");
        GridBagLayout gbl_pnlTable = new GridBagLayout();
        gbl_pnlTable.columnWidths = new int[2];
        gbl_pnlTable.rowHeights = new int[2];
        gbl_pnlTable.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_pnlTable.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.pnlTable.setLayout((LayoutManager)gbl_pnlTable);
        this.scp = new JScrollPane();
        GridBagConstraints gbc_scp = new GridBagConstraints();
        gbc_scp.insets = new Insets(10, 10, 10, 10);
        gbc_scp.fill = 1;
        gbc_scp.gridx = 0;
        gbc_scp.gridy = 0;
        this.pnlTable.add((Component)this.scp, (Object)gbc_scp);
        this.table = new PzTable();
        this.scp.setViewportView((Component)this.table);
        this.statusBar = new PzStatusBar();
        this.contentPanel.add((Component)this.statusBar, "South");
        this.lblUkupnoNaloga = new JLabel("Ukupno naloga:");
        this.statusBar.add((Component)this.lblUkupnoNaloga);
        this.numUkupnoNaloga = new JLabel();
        this.statusBar.add((Component)this.numUkupnoNaloga);
        Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setBounds(r);
        this.setSize(300, (int)r.getHeight());
    }

    private void setTableData() {
        try {
            String cfr_ignored_0 = (String)this.em.createNativeQuery("SELECT column_name FROM information_schema.columns WHERE table_name='nzk' and column_name='opis'").getSingleResult();
        }
        catch (NoResultException noResultException) {
            this.em.getTransaction().begin();
            this.em.createNativeQuery("ALTER TABLE nzk ADD COLUMN opis character varying(255)").executeUpdate();
            this.em.getTransaction().commit();
        }
        this.table.setData(Tools.getNalozi(this.em), Nzk.class);
        this.table.getColumn(0).setCellRenderer(new NaloziTableCellRenderer());
        this.table.getColumn(0).setMinWidth(20);
        this.table.getColumn(0).setMaxWidth(20);
        this.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Nzk nzk = (Nzk)PzDialogNalozi.this.table.getSelectedEntity();
                    if (nzk.getArhiviran() == 0) {
                        LockUtility.lock(nzk);
                        PzDialogNalozi.this.getSession().putParameter("nzk", (Object)PzDialogNalozi.this.table.getSelectedEntity());
                        PzDialogNalozi.this.showDialog(PzDialogIzradaNaloga.class);
                    } else {
                        PzDialogNalozi.this.getSession().putParameter("idNalog", (Object)nzk.getIdNalog());
                        PzDialogNalozi.this.showDialog(PzDialogUpitUNalogZaKnjizenje.class);
                    }
                }
                catch (LockUtility.NzkLockException e1) {
                    PzSwingUtility.showErrorMessage((Component)((Object)PzDialogNalozi.this), (String)e1.getMessage());
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle((Component)((Object)PzDialogNalozi.this), (Throwable)e1);
                }
            }
        });
        this.numUkupnoNaloga.setText(String.valueOf(this.table.getRowCount()));
    }

    public void actionPerformed(ActionEvent e) {
    }

    private void actionPerformedicnIzmena(ActionEvent arg0) {
        Nzk nzk = (Nzk)this.table.getSelectedEntity();
        this.getSession().putParameter("opis", (Object)nzk.getOpis());
        this.showDialog(IzmenaOpisa.class);
        String opis = (String)this.getSession().getParameter("opis");
        this.getSession().putParameter("opis", null);
        if (opis == null) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                nzk.setOpis(opis);
                this.table.updateSelectedEntity((PzEntity)nzk, em);
                em.getTransaction().commit();
                this.table.commitUpdate();
                this.numUkupnoNaloga.setText(String.valueOf(this.table.getRowCount()));
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    protected void actionPerformedicnNovNalog(ActionEvent arg0) {
        int option = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li \u017eelite da otvorite novi nalog?", (String)"Otvaranje novog naloga", null, (boolean)false);
        if (option != 0) {
            return;
        }
        this.showDialog(IzmenaOpisa.class);
        String opis = (String)this.getSession().getParameter("opis");
        this.getSession().putParameter("opis", null);
        if (opis == null) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                Nzk nzk = new Nzk();
                nzk.setIdNalog(Integer.valueOf(PzIdGen.getNextId((String)"NZK_ID", (int)1, (EntityManager)em).getIdVal()));
                nzk.setOpis(opis);
                nzk.setArhiviran(Integer.valueOf(0));
                nzk.setBrojac(Integer.valueOf(0));
                nzk.setBrSheme(Integer.valueOf(-1));
                nzk.setDatum(PzDateUtility.getCurrentDate());
                nzk.setDuguje(new BigDecimal(0));
                nzk.setPotrazuje(new BigDecimal(0));
                nzk.setPzuser(PzExtensionLoader.getLoggedUser());
                this.table.insert((PzEntity)nzk, em);
                em.getTransaction().commit();
                this.table.commitInsert();
                this.numUkupnoNaloga.setText(String.valueOf(this.table.getRowCount()));
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

