/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRException;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Nzk;
import rs.pezar.finansije.gui.util.Tools;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.fields.PzIntegerField;

public class PzDialogPregledProknjizenog
extends PzDialog {
    private static final long serialVersionUID = -6581109754727983109L;
    private PzPanel mainPanel;
    private PzButton btnOk;
    private PzIntegerField brojNalogaField;
    private JLabel jLabel1;
    private Integer brojNaloga;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPregledProknjizenog inst = new PzDialogPregledProknjizenog(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPregledProknjizenog(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogPregledProknjizenog(PzDialog frame) {
        super(frame);
        this.initGUI();
    }

    protected void initGUI() {
        try {
            this.setTitle("Pregled proknji\u017eenog");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.1, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.btnOk = new PzButton();
            this.mainPanel.add((Component)this.btnOk, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("OK");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/check.png")));
            this.btnOk.setActionCommand("OK");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.brojNalogaField = new PzIntegerField();
            this.mainPanel.add((Component)this.brojNalogaField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.brojNalogaField.setPreferredSize(new Dimension(80, 25));
            this.brojNalogaField.setFont(new Font("Tahoma", 0, 14));
            this.jLabel1 = new JLabel();
            this.mainPanel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 30, 0, 0), 0, 0));
            this.jLabel1.setText("Broj naloga:");
            this.pack();
            this.setResizable(false);
            this.setRestorable(false);
            this.setSize(399, 164);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("OK")) {
            this.brojNaloga = this.brojNalogaField.getVal();
            if (this.brojNaloga == 0) {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nalog broj 0 pogledajte u opciji za po\u010detna stanja.", "Obave\u0161tenje", 1);
                this.brojNalogaField.requestFocus();
                return;
            }
            EntityManager em = PzEntityManager.getEm();
            Query q = em.createQuery("SELECT e FROM Nzk e WHERE e.idNalog =:rbroj");
            q.setParameter("rbroj", (Object)this.brojNaloga);
            List rezultat = q.getResultList();
            if (rezultat.size() != 0) {
                Nzk nalog = (Nzk)rezultat.get(0);
                if (nalog.getArhiviran() == 0) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nalog broj " + nalog.getIdNalog() + " je jo\u0161 u pripremi.", "Obave\u0161tenje", 1);
                    this.brojNalogaField.requestFocus();
                    return;
                }
                try {
                    Tools.prikaziIzvestaje(rezultat, this, false);
                }
                catch (JRException e1) {
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Tra\u017eeni nalog za knji\u017eenje ne postoji.", "Obave\u0161tenje", 1);
                this.brojNalogaField.requestFocus();
                return;
            }
            this.dispose();
        }
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPregledProknjizenog(Boolean.FALSE);
    }

    public PzDialogPregledProknjizenog(Boolean initGUI) {
    }
}

