/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.StringUtils;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Shema;
import rs.pezar.db.entity.Stavkasheme;
import rs.pezar.finansije.gui.shemeKnjizenja.PzDialogNovaShema;
import rs.pezar.finansije.gui.shemeKnjizenja.PzDialogStavke;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzFileUtility;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogShemeKnjizenja
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanjeKalkulacije;
    private PzToolBarIcon icnIzmenaKalk;
    private PzToolBarIcon icnDodKalk;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzToolBarIcon icnStavkeSheme;
    private PzComponentGroup kIcnGroup;
    private Shema shemaBrisanje;
    private PzToolBarIcon icnBackup;
    private PzToolBarIcon icnImport;
    private PzToolBarIcon icnKopiraj;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogShemeKnjizenja inst = new PzDialogShemeKnjizenja(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogShemeKnjizenja(JFrame frame) {
        super(frame);
        this.initGUI();
        this.table = new PzTable(Shema.class);
        if (this.table == null) {
            this.table = new PzTable();
        }
        this.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1880389972583904214L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PzDialogShemeKnjizenja.this.getSession().putParameter("shema", (Object)PzDialogShemeKnjizenja.this.table.getSelectedEntity());
                PzDialogShemeKnjizenja.this.showDialog(PzDialogStavke.class);
            }
        });
        this.table.setCheckboxColumn(0);
        this.scrollPane.setViewportView((Component)this.table);
    }

    public PzDialogShemeKnjizenja() {
        this.initGUI();
    }

    public PzDialogShemeKnjizenja(JFrame frame, String parameter) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.toolbar = new JToolBar();
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.getContentPane().add((Component)this.toolbar, "North");
            this.kIcnGroup = new PzComponentGroup();
            this.setTitle("Sheme knji\u017eenja");
            this.icnDodKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodKalk);
            this.toolbar.add((Component)this.icnDodKalk);
            this.icnDodKalk.setText("Nova shema|(ins)");
            this.icnDodKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/document.png")));
            this.icnDodKalk.addActionListener((ActionListener)((Object)this));
            this.icnDodKalk.setActionCommand("insert_shema");
            this.icnDodKalk.setShortcut("insert");
            this.icnDodKalk.setPreferredSize(new Dimension(65, 80));
            this.icnIzmenaKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaKalk);
            this.toolbar.add((Component)this.icnIzmenaKalk);
            this.icnIzmenaKalk.setText("Izmena sheme|(f3)");
            this.icnIzmenaKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/document.png")));
            this.icnIzmenaKalk.setActionCommand("update_shema");
            this.icnIzmenaKalk.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaKalk.setShortcut("f3");
            this.icnBrisanjeKalkulacije = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanjeKalkulacije);
            this.toolbar.add((Component)this.icnBrisanjeKalkulacije);
            this.icnBrisanjeKalkulacije.setText("Brisanje sheme |(del)");
            this.icnBrisanjeKalkulacije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/document.png")));
            this.icnBrisanjeKalkulacije.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeKalkulacije.setActionCommand("delete_shema");
            this.icnBrisanjeKalkulacije.setShortcut("delete");
            this.icnBrisanjeKalkulacije.setPreferredSize(new Dimension(81, 80));
            this.icnStavkeSheme = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnStavkeSheme);
            this.toolbar.add((Component)this.icnStavkeSheme);
            this.icnStavkeSheme.setText("Stavke sheme |knjizenja(f2)");
            this.icnStavkeSheme.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/document.png")));
            this.icnStavkeSheme.addActionListener((ActionListener)((Object)this));
            this.icnStavkeSheme.setActionCommand("stavke_sheme");
            this.icnStavkeSheme.setShortcut("f2");
            this.icnBackup = new PzToolBarIcon();
            this.icnBackup.setIcon((Icon)new ImageIcon(PzDialogShemeKnjizenja.class.getResource("/rs/pezar/finansije/resource/img/document.png")));
            this.icnBackup.setText("Izvoz sheme|(ctrl+i)");
            this.icnBackup.setShortcut("ctrl+i");
            this.icnBackup.setActionCommand("export");
            this.icnBackup.addActionListener((ActionListener)((Object)this));
            this.toolbar.add((Component)this.icnBackup);
            this.icnImport = new PzToolBarIcon();
            this.icnImport.setIcon((Icon)new ImageIcon(PzDialogShemeKnjizenja.class.getResource("/rs/pezar/finansije/resource/img/document.png")));
            this.icnImport.setText("Uvoz sheme|(ctrl+u)");
            this.icnImport.setShortcut("ctrl+u");
            this.icnImport.setActionCommand("import");
            this.icnImport.addActionListener((ActionListener)((Object)this));
            this.toolbar.add((Component)this.icnImport);
            this.icnKopiraj = new PzToolBarIcon();
            this.icnKopiraj.setIcon((Icon)new ImageIcon(PzDialogShemeKnjizenja.class.getResource("/rs/pezar/finansije/resource/img/document.png")));
            this.icnKopiraj.setText("Kopiraj shemu|(ctrl+k)");
            this.icnKopiraj.setShortcut("ctrl+k");
            this.icnKopiraj.setActionCommand("kopiraj");
            this.icnKopiraj.addActionListener((ActionListener)((Object)this));
            this.toolbar.add((Component)this.icnKopiraj);
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.setSize(1024, 768);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        boolean izmena = false;
        Class action = PzDialogNovaShema.class;
        if (actionCommand.equals("update_shema")) {
            izmena = true;
        } else {
            if (actionCommand.equals("delete_shema")) {
                boolean result;
                EntityManager em = PzEntityManager.getEm();
                this.shemaBrisanje = (Shema)this.table.getSelectedEntity();
                if (this.shemaBrisanje == null) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali shemu za brisanje.", "Obave\u0161tenje", 1);
                    return;
                }
                boolean bl = result = JOptionPane.showConfirmDialog((Component)((Object)this), "Da li ste sigurni?", "Brisanje", 0) == 0;
                if (!result) {
                    return;
                }
                try {
                    em.getTransaction().begin();
                    em.remove(em.find(Shema.class, (Object)this.shemaBrisanje.getId()));
                    em.getTransaction().commit();
                    this.table.removeSelectedEntity(false, false);
                    return;
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
                finally {
                    em.close();
                }
            }
            if (actionCommand.equals("stavke_sheme")) {
                action = PzDialogStavke.class;
            } else {
                if (actionCommand.equals("export")) {
                    List sheme = this.table.getCheckedEntities();
                    if (sheme.size() == 0) {
                        return;
                    }
                    try {
                        File dir = PzFileUtility.selectDirectory((String)"Izaberite direktorijum u koji se snimaju sheme", (PzDialog)this);
                        if (dir == null) {
                            return;
                        }
                        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Shema.class});
                        Marshaller m = context.createMarshaller();
                        m.setProperty("jaxb.formatted.output", (Object)true);
                        int i = 0;
                        while (i < sheme.size()) {
                            m.marshal(sheme.get(i), new File(String.valueOf(dir.getPath()) + File.separator + ((Shema)sheme.get(i)).getOpis() + ".shema"));
                            ++i;
                        }
                    }
                    catch (Exception e1) {
                        PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    }
                    return;
                }
                if (actionCommand.equals("import")) {
                    block36: {
                        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                        try {
                            try {
                                Integer n;
                                File[] files = PzFileUtility.selectFiles((String[])new String[]{"shema"}, (String)"Izaberite shemu koja se uvozi", (PzDialog)this);
                                if (files == null || files.length <= 0) break block36;
                                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Shema.class});
                                Unmarshaller u = jc.createUnmarshaller();
                                em.getTransaction().begin();
                                ArrayList<String> nepostojecaKonta = new ArrayList<String>();
                                try {
                                    n = (Integer)em.createQuery("SELECT MAX(s.rBroj) FROM Shema s").getResultList().get(0);
                                    if (n == null) {
                                        n = new Integer(0);
                                    }
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                    n = new Integer(0);
                                }
                                n = n + 1;
                                File[] fileArray = files;
                                int n2 = files.length;
                                int n3 = 0;
                                while (n3 < n2) {
                                    int choice;
                                    File f = fileArray[n3];
                                    Shema shema = (Shema)u.unmarshal((InputStream)new FileInputStream(f));
                                    shema.setrBroj(n);
                                    n = n + 1;
                                    if (em.find(Shema.class, (Object)shema.getId()) == null || (choice = JOptionPane.showConfirmDialog((Component)((Object)this), "Shema '" + shema.getOpis() + "' ve\u0107 postoji. \u017delite li da je prepi\u0161ete?", "Prepis sheme?", 0)) == 0) {
                                        if (shema.getStavkashemes() != null || shema.getStavkashemes().size() > 0) {
                                            for (Stavkasheme stavka : shema.getStavkashemes()) {
                                                Konto k = (Konto)em.find(Konto.class, (Object)new KontoPK(stavka.getOznKonto(), ""));
                                                if (k != null) {
                                                    stavka.setTipAnalitike(k.getTipAnalitike());
                                                    continue;
                                                }
                                                nepostojecaKonta.add(stavka.getOznKonto());
                                            }
                                        }
                                        em.merge((Object)shema);
                                    }
                                    ++n3;
                                }
                                em.getTransaction().commit();
                                this.table.setData(em.createQuery("SELECT s FROM Shema s").getResultList(), Shema.class);
                                if (nepostojecaKonta.size() > 0) {
                                    PzSwingUtility.showInformationMessage((Component)((Object)this), (String)("Slede\u0107a konta ne postoje u \u0161ifarniku i trebalo bi ih dodati \n kako bi se izbegli problemi u prenosu iz robnog u finansijsko:\n" + StringUtils.join(nepostojecaKonta, (char)'\n')));
                                }
                            }
                            catch (Exception e1) {
                                if (em.getTransaction().isActive()) {
                                    em.getTransaction().rollback();
                                }
                                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                                em.close();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                    return;
                }
                if (actionCommand.equals("kopiraj")) {
                    this.getSession().putParameter("copy", (Object)true);
                    izmena = true;
                }
            }
        }
        this.getSession().putParameter("update", (Object)izmena);
        this.getSession().putParameter("table", (Object)this.table);
        this.getSession().putParameter("shema", (Object)this.table.getSelectedEntity());
        this.showDialog(action);
        this.getSession().putParameter("copy", (Object)false);
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogShemeKnjizenja(Boolean.FALSE);
    }

    public PzDialogShemeKnjizenja(Boolean initGUI) {
    }
}

