/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.finansije.PzExtensionLoader;
import rs.pezar.finansije.gui.PzDialogIzborBrojaNaloga;
import rs.pezar.finansije.gui.util.Tools;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;

public class PzDialogUpitUNalogZaKnjizenje
extends PzDialog {
    private static final long serialVersionUID = 4223967333003254765L;
    private PzPanel pzPanelN;
    private JScrollPane jScrollPane;
    private PzToolBarIcon icnSlika;
    private PzDoubleField dugujeField;
    private JLabel jLabel2;
    private PzDoubleField potrazujeField;
    private PzDoubleField saldoField;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel3;
    private PzPanel pzPanelC;
    private JToolBar jToolBar;
    private Nzk nalog;
    private boolean izmena;
    private PzTable table;
    private PzDateField datumField;
    private PzToolBarIcon icnStampa;
    private PzPanel mainPanel;
    private PzStatusBar statusBar;
    private JLabel lblBrojStavki;
    private JLabel lbl1;
    private String brojStavki;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogUpitUNalogZaKnjizenje inst = new PzDialogUpitUNalogZaKnjizenje(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogUpitUNalogZaKnjizenje() {
        this.initGUI();
    }

    public PzDialogUpitUNalogZaKnjizenje(JFrame frame) {
        super(frame);
    }

    public PzDialogUpitUNalogZaKnjizenje(PzDialog parent) {
        super(parent);
    }

    public PzDialogUpitUNalogZaKnjizenje(PzDialog parent, Nzk nzk, int idDok) {
        super(parent);
        this.nalog = nzk;
        this.setTitle("Upit u nalog za knjizenje broj " + nzk.getIdNalog());
        this.initGUI();
        if (idDok != 0) {
            Integer rBroj = (Integer)PzEntityManager.getEm().createQuery("SELECT MIN(s.id.rBroj) FROM Stavkanzk s WHERE s.id.idNalog=:idNalog AND s.dokument.idDok=:idDok".replace(":idNalog", "" + nzk.getIdNalog()).replace(":idDok", String.valueOf(idDok))).getSingleResult();
            int i = 0;
            while (i < this.table.getRowCount()) {
                if (((Stavkanzk)this.table.getEntity(i)).getId().getrBroj().intValue() == rBroj.intValue()) {
                    this.table.scrollRowToVisible(i);
                    this.table.setRowSelectionInterval(i, i);
                    break;
                }
                ++i;
            }
        }
    }

    protected void initGUI() {
        try {
            this.setPreferredSize(new Dimension(1024, 786));
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.columnWidths = new int[]{7};
            mainPanelLayout.rowHeights = new int[]{33, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1};
            mainPanelLayout.rowWeights = new double[]{0.0, 0.5, 20.0, 0.1};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setPaintGradient(true);
            this.pzPanelN = new PzPanel();
            GridBagLayout pzPanelNLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pzPanelN, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pzPanelNLayout.rowWeights = new double[]{14.0, 0.0, 0.0, 0.0, 14.0};
            pzPanelNLayout.rowHeights = new int[]{7, 19, 7, 22, 7};
            pzPanelNLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pzPanelNLayout.columnWidths = new int[]{130, 100, 16, 77, 100, 8, 100, 100, 20};
            this.pzPanelN.setBounds(0, 777, 1008, 22);
            this.pzPanelN.setLayout((LayoutManager)pzPanelNLayout);
            this.jLabel1 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel1.setText("Duguje:");
            this.jLabel10 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel10, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel10.setText("Datum naloga:");
            this.datumField = new PzDateField();
            this.pzPanelN.add((Component)this.datumField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.datumField.setEditable(false);
            this.datumField.setFocusable(false);
            this.datumField.setVal((Object)this.nalog.getDatum());
            this.dugujeField = new PzDoubleField();
            this.pzPanelN.add((Component)this.dugujeField, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dugujeField.setEditable(false);
            this.dugujeField.setFocusable(false);
            this.dugujeField.setVal((Object)this.nalog.getDuguje());
            this.jLabel2 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel2, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel2.setText("Potra\u017euje:");
            this.potrazujeField = new PzDoubleField();
            this.pzPanelN.add((Component)this.potrazujeField, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.potrazujeField.setEditable(false);
            this.potrazujeField.setFocusable(false);
            this.potrazujeField.setVal((Object)this.nalog.getPotrazuje());
            this.jLabel3 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel3, (Object)new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel3.setText("SALDO:");
            this.saldoField = new PzDoubleField();
            this.pzPanelN.add((Component)this.saldoField, (Object)new GridBagConstraints(7, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.saldoField.setEditable(false);
            this.saldoField.setFocusable(false);
            this.saldoField.setVal((Object)this.nalog.getDuguje().subtract(this.nalog.getPotrazuje()).doubleValue());
            this.statusBar = new PzStatusBar();
            GridBagConstraints gbc_statusBar = new GridBagConstraints();
            gbc_statusBar.fill = 2;
            gbc_statusBar.gridx = 0;
            gbc_statusBar.gridy = 4;
            this.mainPanel.add((Component)this.statusBar, (Object)gbc_statusBar);
            this.lbl1 = new JLabel("Broj stavki na nalogu");
            this.statusBar.add((Component)this.lbl1);
            this.lblBrojStavki = new JLabel("");
            this.statusBar.add((Component)this.lblBrojStavki);
            this.lblBrojStavki.setText(this.brojStavki);
            this.pzPanelC = new PzPanel();
            GridBagLayout pzPanelCLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pzPanelC, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanelC.setLayout((LayoutManager)pzPanelCLayout);
            this.pzPanelC.setBounds(1030, 0, 8, 604);
            pzPanelCLayout.rowWeights = new double[]{0.1};
            pzPanelCLayout.rowHeights = new int[]{7};
            pzPanelCLayout.columnWeights = new double[]{0.1};
            pzPanelCLayout.columnWidths = new int[]{7};
            this.jScrollPane = new JScrollPane();
            this.pzPanelC.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.table = new PzTable(this.nalog.getStavkanzks(), Stavkanzk.class);
            this.jScrollPane.setViewportView((Component)this.table);
            this.lblBrojStavki.setText("" + this.table.getRowCount());
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.jToolBar.setOpaque(false);
            this.icnSlika = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnSlika);
            this.icnSlika.setText("Slika dokumenta|(F2)");
            this.icnSlika.setPreferredSize(new Dimension(90, 90));
            this.icnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/document.png")));
            this.icnSlika.setActionCommand("slika_dokumenta");
            this.icnSlika.addActionListener((ActionListener)((Object)this));
            this.icnSlika.setShortcut("f2");
            this.icnStampa = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnStampa);
            this.icnStampa.setText("\u0160tampa|ALT+S");
            this.icnStampa.setPreferredSize(new Dimension(90, 90));
            this.icnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/printer_preferences.png")));
            this.icnStampa.setActionCommand("stampa");
            this.icnStampa.addActionListener((ActionListener)((Object)this));
            this.icnStampa.setShortcut("ALT+S");
            this.setSize(1024, 786);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        block12: {
            EntityManager em = PzEntityManager.getEm();
            try {
                String actionCommand = ((PzButton)e.getSource()).getActionCommand();
                if (actionCommand.equals("slika_dokumenta")) {
                    if (this.nalog.getStavkanzks() != null) {
                        if (this.table.getSelectedEntity() == null) break block12;
                        Dokument dokument = ((Stavkanzk)this.table.getSelectedEntity()).getDokument();
                        if (dokument != null) {
                            PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)dokument);
                            break block12;
                        }
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Dokument nije na\u0111en u arhivi dokumenata.", "Obave\u0161tenje", 1);
                        return;
                    }
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Dokument nije na\u0111en u arhivi dokumenata.", "Obave\u0161tenje", 1);
                    return;
                }
                try {
                    if (actionCommand.equals("stampa")) {
                        Tools.prikaziIzvestaj(this.nalog, this, true);
                    }
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
            }
            finally {
                em.close();
            }
        }
    }

    public boolean shouldBeShown() {
        if (this.izmena) {
            return true;
        }
        boolean result = false;
        Integer brojNaloga = null;
        if (this.getSession().getParameter("idNalog") != null) {
            brojNaloga = Integer.valueOf(this.getSession().getParameter("idNalog").toString());
            this.getSession().putParameter("idNalog", null);
        } else {
            brojNaloga = PzDialogIzborBrojaNaloga.getIzbor(this);
        }
        if (brojNaloga != null) {
            if (brojNaloga == 0) {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Tra\u017eeni nalog za knji\u017eenje ne postoji.", "Obave\u0161tenje", 1);
                return false;
            }
            EntityManager em = PzEntityManager.getEm();
            Query q = em.createQuery("SELECT e FROM Nzk e WHERE e.idNalog =:rbroj");
            q.setParameter("rbroj", (Object)brojNaloga);
            List rezultat = q.getResultList();
            if (rezultat.size() != 0) {
                this.nalog = (Nzk)rezultat.get(0);
                this.setTitle("UPIT U NALOG ZA KNJI\u017dENJE BROJ " + this.nalog.getIdNalog());
                if (this.nalog.getArhiviran() == 0) {
                    if (this.nalog.getPzuser().getPzusername().equals(PzExtensionLoader.getLoggedUser().getPzusername())) {
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nalog broj " + this.nalog.getIdNalog() + " je jo\u0161 u pripremi.", "Obave\u0161tenje", 1);
                    }
                    this.setTitle("UPIT U NALOG ZA KNJI\u017dENJE U PRIPREMI BROJ " + this.nalog.getIdNalog());
                }
            } else {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Tra\u017eeni nalog za knji\u017eenje ne postoji.", "Obave\u0161tenje", 1);
                return false;
            }
            result = true;
            this.initGUI();
            em.close();
        }
        return result;
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogUpitUNalogZaKnjizenje(Boolean.FALSE);
    }

    public PzDialogUpitUNalogZaKnjizenje(Boolean initGUI) {
    }

    public static void prikaziNalog(int idNalog, PzDokument dokument, PzDialog parent) {
        Nzk nzk = (Nzk)PzEntityManager.findEntity(Nzk.class, (Object)idNalog);
        PzDialogUpitUNalogZaKnjizenje dlg = new PzDialogUpitUNalogZaKnjizenje(parent, nzk, dokument.getIdDok());
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setLocationRelativeTo((Component)parent);
        dlg.setVisible(true);
    }
}

