/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.nalogZaKnjizenje.akcije;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.db.entity.Slobodnaanalitika;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.finansije.gui.nalogZaKnjizenje.PzDialogIzradaNaloga;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzComponentFactory;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzDialogAkcija;
import rs.pezar.globals.TipAnalitika;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.sifarnici.gui.kontniPlan.PzDialogAnalitikaKonta;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.beanConverters.BBBigDecimalConverter;
import rs.pezar.util.beanConverters.BBDateConverter;

public class KnjizenjeBezAnalitike
extends PzDialogAkcija {
    private static final long serialVersionUID = -4946878880917611410L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader pnlHeader;
    private PzPanel pnlForm;
    private PzNumericOnlyTextField numKonto;
    private JLabel lblKonto;
    private JLabel lblDuguje;
    private PzDoubleField dblDuguje;
    private PzDoubleField dblPotrazuje;
    private JLabel lblPotrazuje;
    private JLabel lblOpis;
    private PzTextField txtOpis;
    private JLabel lblDatum;
    private PzDateField dateField;
    private PzTextField txtAnalitika;
    private Stavkanzk stavka = new Stavkanzk();
    private Konto konto;
    private PzTextField txtNazivKonta;

    public static void main(String[] args) {
        try {
            KnjizenjeBezAnalitike dialog = new KnjizenjeBezAnalitike();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public KnjizenjeBezAnalitike() {
        this.initGUI();
    }

    public KnjizenjeBezAnalitike(PzDialog parent) {
        super(parent);
        this.stavka = (Stavkanzk)this.getSession().getParameter("stavka");
        this.initGUI();
        this.contentPanel.setPaintGradient(true);
        this.contentPanel.setGradient(Color.WHITE, PzComponentFactory.COLOR_BLUE_LIGHT, PzPanel.GRADIENT_WEST_EAST);
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new BorderLayout());
        this.contentPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new FlowLayout(1));
        this.contentPanel.add((Component)buttonPane, (Object)"South");
        JButton okButton = new JButton("OK");
        okButton.setIcon(new ImageIcon(KnjizenjeBezAnalitike.class.getResource("/rs/pezar/finansije/resource/img/check.png")));
        okButton.setActionCommand("OK");
        okButton.addActionListener((ActionListener)((Object)this));
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.pnlHeader = new PzPanelHeader();
        this.pnlHeader.setOpaque(false);
        this.pnlHeader.setTitle("Knji\u017eenje bez analitike");
        this.contentPanel.add((Component)this.pnlHeader, (Object)"North");
        this.pnlForm = new PzPanel();
        this.pnlForm.setOpaque(false);
        this.contentPanel.add((Component)this.pnlForm, (Object)"Center");
        GridBagLayout gbl_pnlForm = new GridBagLayout();
        int[] nArray = new int[8];
        nArray[0] = 93;
        nArray[1] = 99;
        nArray[2] = 32;
        nArray[3] = 66;
        nArray[4] = 128;
        nArray[5] = 36;
        nArray[6] = 52;
        gbl_pnlForm.columnWidths = nArray;
        gbl_pnlForm.rowHeights = new int[5];
        gbl_pnlForm.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_pnlForm.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.pnlForm.setLayout((LayoutManager)gbl_pnlForm);
        this.lblKonto = new JLabel("Konto:");
        GridBagConstraints gbc_lblKonto = new GridBagConstraints();
        gbc_lblKonto.insets = new Insets(0, 0, 5, 5);
        gbc_lblKonto.anchor = 13;
        gbc_lblKonto.gridx = 0;
        gbc_lblKonto.gridy = 0;
        this.pnlForm.add((Component)this.lblKonto, (Object)gbc_lblKonto);
        this.numKonto = new PzNumericOnlyTextField();
        GridBagConstraints gbc_numKonto = new GridBagConstraints();
        gbc_numKonto.insets = new Insets(0, 0, 5, 5);
        gbc_numKonto.fill = 1;
        gbc_numKonto.gridx = 1;
        gbc_numKonto.gridy = 0;
        this.pnlForm.add((Component)this.numKonto, (Object)gbc_numKonto);
        this.txtAnalitika = new PzTextField();
        this.txtAnalitika.setFocusable(false);
        this.txtAnalitika.setEditable(false);
        GridBagConstraints gbc_txtAnalitika = new GridBagConstraints();
        gbc_txtAnalitika.insets = new Insets(0, 0, 5, 5);
        gbc_txtAnalitika.fill = 2;
        gbc_txtAnalitika.gridx = 3;
        gbc_txtAnalitika.gridy = 0;
        this.pnlForm.add((Component)this.txtAnalitika, (Object)gbc_txtAnalitika);
        this.txtNazivKonta = new PzTextField();
        this.txtNazivKonta.setFocusable(false);
        this.txtNazivKonta.setEditable(false);
        GridBagConstraints gbc_txtNazivKonta = new GridBagConstraints();
        gbc_txtNazivKonta.gridwidth = 3;
        gbc_txtNazivKonta.insets = new Insets(0, 0, 5, 5);
        gbc_txtNazivKonta.fill = 2;
        gbc_txtNazivKonta.gridx = 4;
        gbc_txtNazivKonta.gridy = 0;
        this.pnlForm.add((Component)this.txtNazivKonta, (Object)gbc_txtNazivKonta);
        this.lblDuguje = new JLabel("Duguje:");
        GridBagConstraints gbc_lblDuguje = new GridBagConstraints();
        gbc_lblDuguje.anchor = 13;
        gbc_lblDuguje.insets = new Insets(0, 0, 5, 5);
        gbc_lblDuguje.gridx = 0;
        gbc_lblDuguje.gridy = 1;
        this.pnlForm.add((Component)this.lblDuguje, (Object)gbc_lblDuguje);
        this.dblDuguje = new PzDoubleField();
        GridBagConstraints gbc_dblDuguje = new GridBagConstraints();
        gbc_dblDuguje.gridwidth = 2;
        gbc_dblDuguje.insets = new Insets(0, 0, 5, 5);
        gbc_dblDuguje.fill = 1;
        gbc_dblDuguje.gridx = 1;
        gbc_dblDuguje.gridy = 1;
        this.pnlForm.add((Component)this.dblDuguje, (Object)gbc_dblDuguje);
        this.lblPotrazuje = new JLabel("Potra\u017euje:");
        GridBagConstraints gbc_lblPotrazuje = new GridBagConstraints();
        gbc_lblPotrazuje.insets = new Insets(0, 0, 5, 5);
        gbc_lblPotrazuje.anchor = 13;
        gbc_lblPotrazuje.gridx = 3;
        gbc_lblPotrazuje.gridy = 1;
        this.pnlForm.add((Component)this.lblPotrazuje, (Object)gbc_lblPotrazuje);
        this.dblPotrazuje = new PzDoubleField();
        GridBagConstraints gbc_dblPotrazuje = new GridBagConstraints();
        gbc_dblPotrazuje.insets = new Insets(0, 0, 5, 5);
        gbc_dblPotrazuje.fill = 1;
        gbc_dblPotrazuje.gridx = 4;
        gbc_dblPotrazuje.gridy = 1;
        this.pnlForm.add((Component)this.dblPotrazuje, (Object)gbc_dblPotrazuje);
        this.lblOpis = new JLabel("Opis promene:");
        GridBagConstraints gbc_lblOpis = new GridBagConstraints();
        gbc_lblOpis.anchor = 13;
        gbc_lblOpis.insets = new Insets(0, 0, 5, 5);
        gbc_lblOpis.gridx = 0;
        gbc_lblOpis.gridy = 2;
        this.pnlForm.add((Component)this.lblOpis, (Object)gbc_lblOpis);
        this.txtOpis = new PzTextField();
        this.txtOpis.setVerifyInput(true);
        this.txtOpis.setMaxLength(255);
        GridBagConstraints gbc_txtOpis = new GridBagConstraints();
        gbc_txtOpis.insets = new Insets(0, 0, 5, 0);
        gbc_txtOpis.gridwidth = 6;
        gbc_txtOpis.fill = 1;
        gbc_txtOpis.gridx = 1;
        gbc_txtOpis.gridy = 2;
        this.pnlForm.add((Component)this.txtOpis, (Object)gbc_txtOpis);
        this.lblDatum = new JLabel("Datum knji\u017eenja:");
        GridBagConstraints gbc_lblDatum = new GridBagConstraints();
        gbc_lblDatum.anchor = 13;
        gbc_lblDatum.insets = new Insets(0, 0, 0, 5);
        gbc_lblDatum.gridx = 0;
        gbc_lblDatum.gridy = 3;
        this.pnlForm.add((Component)this.lblDatum, (Object)gbc_lblDatum);
        this.dateField = new PzDateField();
        GridBagConstraints gbc_dateField = new GridBagConstraints();
        gbc_dateField.insets = new Insets(0, 0, 0, 5);
        gbc_dateField.fill = 1;
        gbc_dateField.gridx = 1;
        gbc_dateField.gridy = 3;
        this.pnlForm.add((Component)this.dateField, (Object)gbc_dateField);
        this.initDataBindings();
        PzComponentFactory.installOznKontoField(this.numKonto, this.txtAnalitika, this, true);
        this.pack();
        this.setSize(680, 263);
        this.setMinimumSize(new Dimension(680, 263));
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        this.konto = (Konto)entity;
        this.numKonto.setVal((Object)this.konto.getId().getOznKonto());
        this.txtNazivKonta.setVal((Object)this.konto.getNaziv());
        if (!"".equals(this.konto.getId().getAnalitika())) {
            this.txtAnalitika.setVal((Object)this.konto.getId().getAnalitika());
        }
        this.numKonto.transferFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.pnlForm.validateForm(true)) {
            return;
        }
        if (this.dblDuguje.getVal().equals(this.dblPotrazuje.getVal()) && this.dblPotrazuje.getVal().equals(0.0)) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nije dozvoljeno da oba polja, duguje i potra\u017euje, imaju vrednost 0.");
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            if (!((Boolean)this.getSession().getParameter("update")).booleanValue()) {
                em.getTransaction().begin();
                Konto k = (Konto)em.find(Konto.class, (Object)new KontoPK(this.numKonto.getText(), this.txtAnalitika.getVal()));
                if (k == null) {
                    k = new Konto(this.numKonto.getText(), this.txtAnalitika.getVal(), null, this.konto.getNaziv());
                    em.persist((Object)k);
                }
                this.stavka.getId().setOznKonto(this.numKonto.getText());
                this.stavka.setKonto(k);
                this.stavka.getId().setAnalitika(k.getId().getAnalitika());
                this.stavka.getId().setrBroj(Integer.valueOf(this.getBrojac() + 1));
                this.stavka.setNazivKonta(this.konto.getNaziv());
                this.stavka.setNazivAnalitike(this.getNazivAnalitike(this.konto));
                this.stavka.setSfrKnjizenja(Integer.valueOf(this.getSfrKnjizenja()));
                ((PzDialogIzradaNaloga)this.getParentDialog()).getTableStavke().insert((PzEntity)this.stavka, em);
                em.getTransaction().commit();
                ((PzDialogIzradaNaloga)this.getParentDialog()).getTableStavke().commitInsert();
            } else {
                ((PzDialogIzradaNaloga)this.getParentDialog()).getTableStavke().updateSelectedEntity((PzEntity)this.stavka, true);
            }
            this.getSession().putParameter("opis_promene", (Object)this.txtOpis.getVal());
            this.setDatKnjizenjaTemp(this.dateField.getVal());
            this.dispose();
        }
        catch (Exception ex) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            ((PzDialogIzradaNaloga)this.getParentDialog()).getTableStavke().rollBack();
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    private String getNazivAnalitike(Konto k) {
        if (TipAnalitika.ANALITIKA_RJ.equals(k.getTipAnalitike())) {
            String oznRj = this.txtAnalitika.getVal().substring(0, 3);
            Radnajedinica rj = (Radnajedinica)this.getEm().find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", String.valueOf(Integer.parseInt(oznRj))));
            return rj.getNaziv();
        }
        if (TipAnalitika.ANALITIKA_KOMINTENTI.equals(k.getTipAnalitike())) {
            return ((Komitent)this.getEm().find(Komitent.class, (Object)this.txtAnalitika.getVal())).getNaziv();
        }
        if (TipAnalitika.ANALITIKA_SLOBODNA.equals(k.getTipAnalitike())) {
            return ((Slobodnaanalitika)this.getEm().find(Slobodnaanalitika.class, (Object)this.txtAnalitika.getVal())).getNaziv();
        }
        if (TipAnalitika.ANALITIKA_POREZ.equals(k.getTipAnalitike())) {
            Tarifnagrupa tg = (Tarifnagrupa)this.getEm().find(Tarifnagrupa.class, (Object)this.txtAnalitika.getVal());
            return String.valueOf(tg.getVrstatg().getOznVrstaTG()) + " " + tg.getStopa();
        }
        return null;
    }

    private boolean validateKonto() throws Exception {
        if (this.konto == null) {
            return false;
        }
        if (this.konto.getTipAnalitike() != null && !this.konto.getTipAnalitike().equals("")) {
            boolean ok = false;
            if (this.konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_RJ)) {
                Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)this);
                if (rj != null) {
                    ok = true;
                    this.txtAnalitika.setVal((Object)(String.valueOf(PzEntityUtil.strZero((String)rj.getId().getOznRj(), (int)3)) + rj.getgTip()));
                } else {
                    this.numKonto.requestFocusInWindow();
                }
            } else if (this.konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_KOMINTENTI)) {
                Komitent komitent = (Komitent)this.launchSifarnik((PzDialog)new PzDialogKomintenti((PzDialog)this));
                if (komitent != null) {
                    ok = true;
                    this.txtAnalitika.setVal((Object)PzEntityUtil.strZero((String)komitent.getSfrKomitent(), (int)5));
                } else {
                    this.numKonto.requestFocusInWindow();
                }
            } else if (this.konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_POREZ)) {
                Tarifnagrupa tg = (Tarifnagrupa)this.launchSifarnik((PzDialog)new PzDialogStopePoreza((PzDialog)this));
                if (tg != null) {
                    ok = true;
                    this.txtAnalitika.setVal((Object)tg.getOznTarGr());
                } else {
                    this.numKonto.requestFocusInWindow();
                }
            } else if (this.konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_SLOBODNA)) {
                Slobodnaanalitika analitika = (Slobodnaanalitika)this.launchSifarnik((PzDialog)new PzDialogAnalitikaKonta((PzDialog)this));
                if (analitika != null) {
                    ok = true;
                    this.txtAnalitika.setVal((Object)analitika.getOznAnalitika());
                } else {
                    this.numKonto.requestFocusInWindow();
                }
            }
            if (ok) {
                this.numKonto.setVal((Object)this.konto.getId().getOznKonto());
            }
        } else {
            this.numKonto.setVal((Object)this.konto.getId().getOznKonto());
            this.txtAnalitika.setVal((Object)this.konto.getId().getAnalitika());
        }
        return true;
    }

    private PzEntity launchSifarnik(PzDialog dlg) {
        dlg.setLocationRelativeTo((Component)((Object)this));
        dlg.setModal(true);
        dlg.setCloseOnEnter(true);
        dlg.restoreSize();
        dlg.setVisible(true);
        PzEntity entity = PzTable.selectedEntity;
        PzTable.selectedEntity = null;
        return entity;
    }

    protected BindingGroup initDataBindings() {
        BeanProperty stavkanzkBeanProperty = BeanProperty.create((String)"id.oznKonto");
        BeanProperty pzNumericOnlyTextFieldBeanProperty = BeanProperty.create((String)"text_ON_FOCUS_LOST");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.stavka, (Property)stavkanzkBeanProperty, (Object)this.numKonto, (Property)pzNumericOnlyTextFieldBeanProperty);
        autoBinding.bind();
        BeanProperty stavkanzkBeanProperty_1 = BeanProperty.create((String)"id.analitika");
        BeanProperty pzTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.stavka, (Property)stavkanzkBeanProperty_1, (Object)this.txtAnalitika, (Property)pzTextFieldBeanProperty);
        autoBinding_1.bind();
        BeanProperty stavkanzkBeanProperty_4 = BeanProperty.create((String)"opis");
        BeanProperty pzTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.stavka, (Property)stavkanzkBeanProperty_4, (Object)this.txtOpis, (Property)pzTextFieldBeanProperty_1);
        autoBinding_4.bind();
        BeanProperty stavkanzkBeanProperty_2 = BeanProperty.create((String)"duguje");
        BeanProperty pzDoubleFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.stavka, (Property)stavkanzkBeanProperty_2, (Object)this.dblDuguje, (Property)pzDoubleFieldBeanProperty);
        autoBinding_2.setConverter((Converter)new BBBigDecimalConverter());
        autoBinding_2.bind();
        BeanProperty stavkanzkBeanProperty_3 = BeanProperty.create((String)"potrazuje");
        BeanProperty pzDoubleFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.stavka, (Property)stavkanzkBeanProperty_3, (Object)this.dblPotrazuje, (Property)pzDoubleFieldBeanProperty_1);
        autoBinding_3.setConverter((Converter)new BBBigDecimalConverter());
        autoBinding_3.bind();
        BeanProperty stavkanzkBeanProperty_5 = BeanProperty.create((String)"datKnjizenja");
        BeanProperty pzDateFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.stavka, (Property)stavkanzkBeanProperty_5, (Object)this.dateField, (Property)pzDateFieldBeanProperty);
        autoBinding_5.setConverter((Converter)new BBDateConverter());
        autoBinding_5.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)autoBinding);
        bindingGroup.addBinding((Binding)autoBinding_1);
        bindingGroup.addBinding((Binding)autoBinding_4);
        bindingGroup.addBinding((Binding)autoBinding_2);
        bindingGroup.addBinding((Binding)autoBinding_3);
        bindingGroup.addBinding((Binding)autoBinding_5);
        return bindingGroup;
    }

    @Override
    public Date getDatKnjizenja() {
        return null;
    }

    @Override
    public PzDokument getNewDokument() {
        return null;
    }

    public boolean shouldBeShown() {
        if (this.getSession().getParameter("opis_promene") != null && !((Boolean)this.getSession().getParameter("update")).booleanValue()) {
            this.txtOpis.setVal(this.getSession().getParameter("opis_promene"));
        }
        if (((Boolean)this.getSession().getParameter("update")).booleanValue()) {
            this.numKonto.setEnabled(false);
        }
        this.dateField.setVal((Object)this.getDatKnjizenjaTemp());
        return true;
    }
}

