/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.util;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.persistence.queries.FetchGroup;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Shema;
import rs.pezar.finansije.engine.internal.PzShemaProvider;

public class DBManager {
    public static List<Dokument> getDokumentiZaKnjizenjeImproved(HashMap<String, Object> filter) throws Exception {
        String tipovi = DBManager.getTipovi((List)filter.get("TIP"));
        String radneJedinice = DBManager.getTipovi((List)filter.get("RJ"));
        String datumP = ((Date)filter.get("P_DATUM")).toString();
        String datumK = ((Date)filter.get("K_DATUM")).toString();
        ArrayList<Dokument> result = new ArrayList<Dokument>();
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        List<Shema> sheme = DBManager.getSheme();
        String upit = "SELECT d FROM Dokument d left join d.radnajedinica rj left join d.komitent k WHERE d.arhiviran=1 AND d.proknjizen=0 and d.datum>='%datumP%' and d.datum<='%datumK%' %tipDok% %tipRj% ORDER BY d.tip, rj.id.oznRj, d.datArh, d.rBroj";
        upit = upit.replace("%datumP%", datumP);
        upit = upit.replace("%datumK%", datumK);
        upit = upit.replace("%tipDok%", tipovi.length() == 0 ? " " : " and d.tip IN (" + tipovi + ") ");
        upit = upit.replace("%tipRj%", radneJedinice.length() == 0 ? " " : " and rj.id.oznRj IN (" + radneJedinice + ") ");
        Query q = em.createQuery(upit);
        FetchGroup grp = new FetchGroup();
        new FetchGroup("id");
        grp.addAttribute("idDok");
        grp.addAttribute("oznDokumenta");
        grp.addAttribute("tip");
        grp.addAttribute("podTip");
        grp.addAttribute("opis");
        grp.addAttribute("cvProdajna");
        grp.addAttribute("rbrDok");
        grp.addAttribute("radnajedinica");
        grp.addAttribute("datArh");
        grp.addAttribute("datum");
        grp.addAttribute("komitent.naziv");
        q.setHint("eclipselink.fetch-group", (Object)grp);
        q.setHint("eclipselink.left-join-fetch", (Object)"d.radnajedinica");
        q.setHint("eclipselink.left-join-fetch", (Object)"d.komitent");
        List dokumenti = q.getResultList();
        for (Dokument dokument : dokumenti) {
            Shema resShema = null;
            int lastLevel = 0;
            for (Shema shema : sheme) {
                int level = 0;
                if (shema.getCena() != null && (!shema.getCena().equals("PROD") || dokument.getCvProdajna() != 1) && (!shema.getCena().equals("PRNC") || dokument.getCvProdajna() != 0) || !shema.getId().getTipDok().equals(dokument.getTip()) || !shema.getId().getPodTipDok().equals("") && !shema.getId().getPodTipDok().equals(dokument.getPodTip())) continue;
                if (dokument.getRadnajedinica() != null && shema.getId().getOznRj().equals(dokument.getRadnajedinica().getId().getOznRj())) {
                    resShema = shema;
                    level = 1000;
                    break;
                }
                Shema tmpShema = null;
                if (!shema.getId().getTipRj().equals("") && dokument.getRadnajedinica() != null) {
                    if (shema.getId().getTipRj().equals(dokument.getRadnajedinica().getgTip())) {
                        if (!shema.getId().getpTipRj().equals("")) {
                            if (shema.getId().getpTipRj().equals(dokument.getRadnajedinica().getpTip())) {
                                if (!shema.getId().getPpTipRj().equals("")) {
                                    if (shema.getId().getPpTipRj().equals(dokument.getRadnajedinica().getPpTip())) {
                                        tmpShema = shema;
                                        level = 4;
                                    }
                                } else {
                                    tmpShema = shema;
                                    level = 3;
                                }
                            }
                        } else {
                            tmpShema = shema;
                            level = 2;
                        }
                    }
                } else {
                    tmpShema = shema;
                    level = 1;
                }
                if (tmpShema == null || level <= lastLevel) continue;
                lastLevel = level;
                resShema = tmpShema;
            }
            if (resShema == null) continue;
            result.add(dokument);
            dokument.setShemaKnjizenja(resShema);
        }
        new Comparator<Dokument>(){

            @Override
            public int compare(Dokument o1, Dokument o2) {
                int res = o1.getTip().compareTo(o2.getTip());
                if (res == 0) {
                    if (o1.getRbrDok() < o2.getRbrDok()) {
                        return -1;
                    }
                    if (o1.getRbrDok() > o2.getRbrDok()) {
                        return 1;
                    }
                    return 0;
                }
                return res;
            }
        };
        return result;
    }

    private static List<Shema> getSheme() {
        Vector<Shema> sheme = new Vector<Shema>();
        List<Shema> tmp = new PzShemaProvider().loadShemas();
        for (Shema s : tmp) {
            if (s.getAbstrakt() != 0) continue;
            sheme.add(s);
        }
        return sheme;
    }

    public static String getTipovi(List<String> tips) {
        String res = "";
        if (tips == null || tips.size() == 0) {
            return res;
        }
        int i = 0;
        while (i < tips.size()) {
            res = String.valueOf(res) + (i == 0 ? "" : ",") + "'" + tips.get(i) + "'";
            ++i;
        }
        return res;
    }
}

