/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.konsignacije.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.konsignacije.gui.PzDialogPovratnicaMaloprodajaPregled;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.data.models.PzTableModelDokument;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogKonsignacijeIzArhive
extends PzDialog {
    private PzPanel pzPanelN;
    private JScrollPane jScrollPane;
    private JLabel jLabel3;
    private PzDoubleField ukupanIznos;
    private PzDoubleField ukupanPDV;
    private PzDoubleField ukupanIznosSaPDV;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel10;
    private PzPanel pnlSouth;
    private JPanel mainPanel;
    private PzToolBarIcon icnStampa;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnUpit;
    private PzToolBarIcon icnTraziDokument;
    private PzToolBarIcon icnTraziDatum;
    private PzToolBarIcon pzPrikaziSve;
    private PzDateField krajnjiDatum;
    private PzDateField pocetniDatum;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private PzNumericOnlyTextField brojDokumenata;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzTable table;
    private PzPanel pzPanelC;
    private JToolBar jToolBar;
    private PzTextField brDokumenta;
    private Radnajedinica rj;
    private PzComponentGroup fieldGroup;
    private String pretraga;
    private String izvestaj;
    private PzButton bntTrazi;
    private String tipDokumenta;
    private String parametar;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPovratnicaMaloprodajaPregled inst = new PzDialogPovratnicaMaloprodajaPregled(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogKonsignacijeIzArhive(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogKonsignacijeIzArhive(JFrame frame, String parameter) {
        super(frame);
        System.out.println("Ulazi u moj dijalog");
        this.parametar = parameter;
        if (parameter.equals("prijemnicaV")) {
            this.tipDokumenta = "KONSIGNACIJA_PRIJEM_V";
        } else if (parameter.equals("prijemnicaM")) {
            this.tipDokumenta = "KONSIGNACIJA_PRIJEM_M";
        } else if (parameter.equals("povratnicaV")) {
            this.tipDokumenta = "KONSIGNACIJA_POVRATNICA_V";
        } else if (parameter.equals("povratnicaM")) {
            this.tipDokumenta = "KONSIGNACIJA_POVRATNICA_M";
        }
        this.initGUI();
        this.postInit();
    }

    public PzDialogKonsignacijeIzArhive(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public void postInit() {
        if (this.tipDokumenta.equals("KONSIGNACIJA_PRIJEM_V") || this.tipDokumenta.equals("KONSIGNACIJA_POVRATNICA_V")) {
            this.jLabel3.setVisible(false);
            this.jLabel9.setText("Ukupan iznos");
            this.jLabel10.setText("Broj dokumenata");
            this.jLabel7.setVisible(false);
            this.ukupanIznos.setVisible(false);
            this.brojDokumenata.setVisible(false);
        }
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(1024, 786));
            this.setTitle("PREGLED POVRATNICA IZ KONSIGNACIJE");
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new JPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.columnWidths = new int[]{7};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1};
            mainPanelLayout.rowWeights = new double[]{0.5, 0.5, 20.0, 2.0};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout(mainPanelLayout);
            this.pzPanelN = new PzPanel();
            this.mainPanel.add((Component)this.pzPanelN, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelNLayout = new GridBagLayout();
            pzPanelNLayout.rowWeights = new double[]{14.0, 0.0, 0.0, 0.0, 0.0, 14.0};
            pzPanelNLayout.rowHeights = new int[]{7, 23, 23, 7, 23, 7};
            pzPanelNLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pzPanelNLayout.columnWidths = new int[]{150, 99, 24, 33, 123, 99, 324};
            this.pzPanelN.setLayout((LayoutManager)pzPanelNLayout);
            this.pzPanelN.setBounds(0, 777, 1008, 22);
            this.jLabel1 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Pocetni datum:");
            this.jLabel2 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel2, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Krajnji datum:");
            this.jLabel8 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel8, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel8.setText("Dokument:");
            this.fieldGroup = new PzComponentGroup();
            this.brDokumenta = new PzTextField();
            this.fieldGroup.add((Component)this.brDokumenta);
            this.pzPanelN.add((Component)this.brDokumenta, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.brDokumenta.setMaxLength(15);
            this.brDokumenta.setPreferredSize(new Dimension(47, 21));
            this.pocetniDatum = new PzDateField();
            this.fieldGroup.add((Component)this.pocetniDatum);
            this.pzPanelN.add((Component)this.pocetniDatum, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.krajnjiDatum = new PzDateField();
            this.fieldGroup.add((Component)this.krajnjiDatum);
            this.pzPanelN.add((Component)this.krajnjiDatum, (Object)new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.bntTrazi = new PzButton();
            this.pzPanelN.add((Component)this.bntTrazi, (Object)new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.bntTrazi.setText("Tra\u017ei");
            this.bntTrazi.setBounds(90, 6, 126, 33);
            this.bntTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/find.png")));
            this.bntTrazi.addActionListener((ActionListener)((Object)this));
            this.bntTrazi.setActionCommand("trazi");
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.jToolBar.setBounds(0, -51, 1008, 13);
            this.pzPrikaziSve = new PzToolBarIcon();
            this.jToolBar.add((Component)this.pzPrikaziSve);
            this.pzPrikaziSve.setText("Prika\u017ei sve|(F5)");
            this.pzPrikaziSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/find_pib.png")));
            this.pzPrikaziSve.setActionCommand("prikazi_sve");
            this.pzPrikaziSve.addActionListener((ActionListener)((Object)this));
            this.pzPrikaziSve.setShortcut("f5");
            this.pzPrikaziSve.setPreferredSize(new Dimension(77, 80));
            this.jSeparator1 = new JSeparator();
            this.jToolBar.add(this.jSeparator1);
            this.jSeparator1.setOrientation(1);
            this.jSeparator1.setPreferredSize(new Dimension(8, 75));
            this.icnTraziDokument = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnTraziDokument);
            this.icnTraziDokument.setText("Tra\u017ei po|dokumentu (F8)");
            this.icnTraziDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/find_text.png")));
            this.icnTraziDokument.setActionCommand("trazidokument");
            this.icnTraziDokument.addActionListener((ActionListener)((Object)this));
            this.icnTraziDokument.setShortcut("f8");
            this.icnTraziDatum = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnTraziDatum);
            this.icnTraziDatum.setText("Tra\u017ei po|datumu (F9)");
            this.icnTraziDatum.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/find_pib.png")));
            this.icnTraziDatum.setActionCommand("trazidatum");
            this.icnTraziDatum.addActionListener((ActionListener)((Object)this));
            this.icnTraziDatum.setShortcut("f9");
            this.icnTraziDatum.setPreferredSize(new Dimension(76, 80));
            this.jSeparator2 = new JSeparator();
            this.jToolBar.add(this.jSeparator2);
            this.jSeparator2.setOrientation(1);
            this.jSeparator2.setPreferredSize(new Dimension(8, 75));
            this.icnArhiva = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Slika iz|arhive (F2)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/address_book.png")));
            this.icnArhiva.setPreferredSize(new Dimension(79, 90));
            this.icnArhiva.setActionCommand("slika");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("F2");
            this.icnUpit = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnUpit);
            this.icnUpit.setText("Upit u NZK|(F5)");
            this.icnUpit.setPreferredSize(new Dimension(82, 90));
            this.icnUpit.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/nzk.png")));
            this.icnUpit.setShortcut("f5");
            this.icnUpit.setActionCommand("nzk");
            this.icnUpit.addActionListener((ActionListener)((Object)this));
            this.icnStampa = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnStampa);
            this.icnStampa.setText("Priprema za|stampu (Alt+S)");
            this.icnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/printer_preferences.png")));
            this.icnStampa.setPreferredSize(new Dimension(100, 90));
            this.icnStampa.setActionCommand("stampa");
            this.icnStampa.addActionListener((ActionListener)((Object)this));
            this.icnStampa.setShortcut("alt+s");
            this.pzPanelC = new PzPanel();
            GridBagLayout pzPanelCLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pzPanelC, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanelC.setLayout((LayoutManager)pzPanelCLayout);
            this.pzPanelC.setBounds(1030, 0, 8, 604);
            pzPanelCLayout.rowWeights = new double[]{0.1};
            pzPanelCLayout.rowHeights = new int[]{7};
            pzPanelCLayout.columnWeights = new double[]{0.1};
            pzPanelCLayout.columnWidths = new int[]{7};
            this.jScrollPane = new JScrollPane();
            this.pzPanelC.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.table = new PzTable();
            this.jScrollPane.setViewportView((Component)this.table);
            this.pnlSouth = new PzPanel();
            GridBagLayout pnlSouthLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlSouth, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlSouthLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlSouthLayout.rowHeights = new int[]{7, 20, 20, 7};
            pnlSouthLayout.columnWeights = new double[]{1.0, 1.0, 2.0};
            pnlSouthLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlSouth.setLayout((LayoutManager)pnlSouthLayout);
            this.jLabel3 = new JLabel();
            this.pnlSouth.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel3.setText("Iznos bez PDV-a");
            this.jLabel9 = new JLabel();
            this.pnlSouth.add((Component)this.jLabel9, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel9.setText("Ukupan PDV");
            this.jLabel10 = new JLabel();
            this.pnlSouth.add((Component)this.jLabel10, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel10.setText("Iznos sa PDV-om");
            this.jLabel7 = new JLabel();
            this.pnlSouth.add((Component)this.jLabel7, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel7.setText("Broj dokumenata");
            this.ukupanIznos = new PzDoubleField();
            this.pnlSouth.add((Component)this.ukupanIznos, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.ukupanIznos.setPreferredSize(new Dimension(100, 24));
            this.ukupanIznos.setEditable(false);
            this.ukupanPDV = new PzDoubleField();
            this.pnlSouth.add((Component)this.ukupanPDV, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.ukupanPDV.setPreferredSize(new Dimension(100, 24));
            this.ukupanPDV.setEditable(false);
            this.ukupanIznosSaPDV = new PzDoubleField();
            this.pnlSouth.add((Component)this.ukupanIznosSaPDV, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.ukupanIznosSaPDV.setPreferredSize(new Dimension(100, 24));
            this.ukupanIznosSaPDV.setEditable(false);
            this.brojDokumenata = new PzNumericOnlyTextField();
            this.pnlSouth.add((Component)this.brojDokumenata, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.brojDokumenata.setPreferredSize(new Dimension(100, 24));
            this.brojDokumenata.setEditable(false);
            this.fieldGroup.disableAll();
            this.setSize(1024, 786);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzTable data1 = null;
        PzEntity data2 = null;
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equalsIgnoreCase("trazidokument")) {
            this.fieldGroup.enable((Component)this.brDokumenta);
            this.pretraga = "po_dokumentu";
            return;
        }
        if (actionCommand.equalsIgnoreCase("trazidatum")) {
            Vector<PzDateField> dates = new Vector<PzDateField>();
            dates.add(this.pocetniDatum);
            dates.add(this.krajnjiDatum);
            this.fieldGroup.enable(dates);
            this.krajnjiDatum.setVal((Object)new Date(new java.util.Date().getTime()));
            this.pretraga = "po_datumu";
            return;
        }
        if (actionCommand.equals("trazi")) {
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            if (this.pretraga.equals("po_dokumentu")) {
                q = em.createQuery("SELECT k FROM Konsignacija k where k.oznDokumenta like :oznDokumenta AND k.radnajedinica=:rj  AND k.arhiviran=:arh AND k.tip=:tipdok ORDER BY k.datum");
                q.setParameter("oznDokumenta", (Object)(String.valueOf(this.brDokumenta.getVal()) + "%"));
                q.setParameter("rj", (Object)this.rj);
                q.setParameter("arh", (Object)1);
                q.setParameter("tipdok", (Object)this.tipDokumenta);
            } else if (this.pretraga.equals("po_datumu")) {
                q = em.createQuery("SELECT k FROM Konsignacija k where k.datum>=:datumOD AND k.datum<=:datumDO AND k.radnajedinica=:rj  AND k.arhiviran=:arh AND k.tip=:tipdok ORDER BY k.datum");
                q.setParameter("datumOD", (Object)this.pocetniDatum.getVal());
                q.setParameter("datumDO", (Object)this.krajnjiDatum.getVal());
                q.setParameter("rj", (Object)this.rj);
                q.setParameter("arh", (Object)1);
                q.setParameter("tipdok", (Object)this.tipDokumenta);
            }
            Vector data = (Vector)q.getResultList();
            System.out.println(data.size());
            this.table.setData(data, Konsignacija.class);
            em.close();
            this.table.getTableHeader().setFocusable(false);
            this.table.requestFocusInWindow();
            this.popuniPodatke();
            return;
        }
        if (actionCommand.equals("prikazi_sve")) {
            EntityManager em = PzEntityManager.getEm();
            Query q = em.createQuery("SELECT k from Konsignacija k WHERE k.arhiviran=:arh AND k.radnajedinica=:rj AND k.tip=:tipdok ORDER BY k.datum");
            q.setParameter("rj", (Object)this.rj);
            q.setParameter("arh", (Object)1);
            q.setParameter("tipdok", (Object)this.tipDokumenta);
            this.table.setData((Vector)q.getResultList(), Konsignacija.class);
            em.close();
            this.table.requestFocusInWindow();
            System.out.println(this.tipDokumenta);
            if (this.table.getRowCount() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
            this.popuniPodatke();
            return;
        }
        if (actionCommand.equals("slika")) {
            this.izvestaj = "slika";
            this.showReport();
            return;
        }
        if (actionCommand.equals("nzk")) {
            try {
                if (this.table.getRowCount() == 0) {
                    return;
                }
                PzGenericService gs = PzApplication.getApplication().getGenericServiceRegistry().getService("NZK_SERVICE");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("NZK_DOKUMENT", this.table.getSelectedEntity());
                params.put("NZK_PARENT_DIALOG", (Object)this);
                gs.run(params);
                return;
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                return;
            }
        }
        if (actionCommand.equals("stampa")) {
            this.izvestaj = "stampa";
            this.showReport();
            return;
        }
        data1 = this.table;
        data2 = this.table.getSelectedEntity();
        this.showDialog(actionCommand, false, data1, data2);
    }

    public boolean shouldBeShown() {
        boolean result = false;
        this.rj = this.parametar.equals("prijemnicaV") || this.parametar.equals("povratnicaV") ? PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"T"}) : PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"ET"});
        if (this.rj != null) {
            result = true;
            this.setTitle("PREGLED POVRATNICA SA KONSIGNACIJE  " + this.rj.getId().getOznRj() + "(" + this.rj.getgTip() + ") " + this.rj.getNaziv() + "  KOMITENT: " + this.rj.getKomitent().getNaziv());
            try {
                PzTableModelDokument model = new PzTableModelDokument(new Vector(), Konsignacija.class);
                this.table.setModel((TableModel)model);
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        return result;
    }

    public void showReport() {
        block12: {
            try {
                if (this.izvestaj.equalsIgnoreCase("slika")) {
                    Konsignacija konsignacija = (Konsignacija)this.table.getSelectedEntity();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)konsignacija);
                    break block12;
                }
                if (!this.izvestaj.equalsIgnoreCase("stampa")) break block12;
                Vector<Object> data = new Vector<Object>();
                try {
                    data.add(PzFirma.getFirma());
                    data.add(this.rj);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
                HashMap<String, Object> params = new HashMap<String, Object>();
                Vector vector = (Vector)this.table.getAllEntities();
                Date datumP = ((Konsignacija)vector.firstElement()).getDatum();
                Date datumK = ((Konsignacija)vector.lastElement()).getDatum();
                params.put("datumOd", datumP);
                params.put("datumDo", datumK);
                String title = null;
                String fname = null;
                if (this.tipDokumenta.equals("KONSIGNACIJA_PRIJEM_V")) {
                    title = "Pregled uradjenih prijemnica";
                    fname = "rs/pezar/reports/compiled/konsignacija.tudjaroba.prijem.VP.stampa.jasper";
                } else if (this.tipDokumenta.equals("KONSIGNACIJA_PRIJEM_M")) {
                    title = "Pregled uradjenih prijemnica";
                    fname = "rs/pezar/reports/compiled/konsignacija.tudjaroba.prijem.MP.stampa.jasper";
                } else if (this.tipDokumenta.equals("KONSIGNACIJA_POVRATNICA_V")) {
                    title = "Pregled uradjenih povratnica";
                    fname = "rs/pezar/reports/compiled/konsignacija.tudjaroba.povratnica.VP.stampa.jasper";
                } else if (this.tipDokumenta.equals("KONSIGNACIJA_POVRATNICA_M")) {
                    title = "Pregled uradjenih prijemnica";
                    fname = "rs/pezar/reports/compiled/konsignacija.tudjaroba.povratnica.MP.stampa.jasper";
                }
                params.put("title", title);
                PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)fname, params, (String)title);
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
    }

    private void popuniPodatke() {
        List podaci = this.table.getAllEntities();
        BigDecimal vredMagacina = new BigDecimal(0);
        int brojDok = 0;
        BigDecimal pdv = new BigDecimal(0);
        BigDecimal iznosSaPDV = new BigDecimal(0);
        for (PzEntity akons : podaci) {
            Konsignacija kons = (Konsignacija)akons;
            vredMagacina = vredMagacina.add(kons.getIznosBezPoreza());
            iznosSaPDV = iznosSaPDV.add(kons.getIznosSaPorezom());
            pdv = pdv.add(kons.getIznosSaPorezom().subtract(kons.getIznosBezPoreza()));
            ++brojDok;
        }
        if (this.tipDokumenta.equals("KONSIGNACIJA_PRIJEM_V") || this.tipDokumenta.equals("KONSIGNACIJA_POVRATNICA_V")) {
            this.ukupanIznosSaPDV.setVal((Object)brojDok);
            this.ukupanPDV.setVal((Object)vredMagacina);
        } else {
            this.ukupanIznos.setVal((Object)vredMagacina);
            this.ukupanIznosSaPDV.setVal((Object)iznosSaPDV);
            this.ukupanPDV.setVal((Object)pdv);
            this.brojDokumenata.setVal((Object)brojDok);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPovratnicaMaloprodajaPregled(Boolean.FALSE);
    }

    public PzDialogKonsignacijeIzArhive(Boolean initGUI) {
    }
}

