/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.konsignacije.gui.obracun;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalobracunkonsignacije;
import rs.pezar.db.entity.Obracunkonsignacije;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.util.PzMathUtility;

public class PzDialogIzmenaProvizije
extends PzDialogInsert {
    private PzPanel mainPanel;
    private PzPanel pnlCenter;
    private PzButton btnOk;
    private PzDoubleField iznosProvizijeField;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JLabel jLabelNazivArtikla;
    private JLabel jLabelNaziv;
    private PzPanel pnlButtons;
    private PzTextField tfSifraArtikla;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogIzmenaProvizije inst = new PzDialogIzmenaProvizije(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogIzmenaProvizije(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogIzmenaProvizije(PzDialog frame) {
        super(frame);
        this.initGUI();
        Artikalobracunkonsignacije artob = (Artikalobracunkonsignacije)this.getSession().getParameter("stavka");
        this.tfSifraArtikla.setVal((Object)artob.getSifra());
        this.jLabelNazivArtikla.setText(String.valueOf(artob.getNaziv()) + artob.getBliziOpis());
        this.iznosProvizijeField.setVal((Object)artob.getProvizija());
        this.tfSifraArtikla.setFocusable(false);
        this.iznosProvizijeField.requestFocus();
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            this.setTitle("Izmena provizije");
            this.mainPanel = new PzPanel();
            AnchorLayout mainPanelLayout = new AnchorLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pnlCenter = new PzPanel();
            GridBagLayout pnlCenterLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlCenter, (Object)new AnchorConstraint(86, 1001, 636, 1, 1, 1, 1, 1));
            pnlCenterLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlCenterLayout.rowHeights = new int[]{13, 24, 25, 25, 20};
            pnlCenterLayout.columnWeights = new double[]{0.1, 0.0, 0.0, 0.0, 2.0};
            pnlCenterLayout.columnWidths = new int[]{20, 126, 129, 91, 7};
            this.pnlCenter.setLayout((LayoutManager)pnlCenterLayout);
            this.pnlCenter.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pnlCenter.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("\u0160ifra artikla:");
            this.jLabel2 = new JLabel();
            this.pnlCenter.add((Component)this.jLabel2, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Provizija:");
            this.jLabelNaziv = new JLabel();
            this.pnlCenter.add((Component)this.jLabelNaziv, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabelNaziv.setText("Naziv artikla");
            this.jLabelNazivArtikla = new JLabel();
            this.pnlCenter.add((Component)this.jLabelNazivArtikla, (Object)new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.jLabelNazivArtikla.setText(" ");
            this.iznosProvizijeField = new PzDoubleField();
            this.pnlCenter.add((Component)this.iznosProvizijeField, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.iznosProvizijeField.setFont(new Font("Tahoma", 0, 14));
            this.tfSifraArtikla = new PzTextField();
            this.pnlCenter.add((Component)this.tfSifraArtikla, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfSifraArtikla.setFont(new Font("Tahoma", 0, 14));
            this.tfSifraArtikla.setSize(60, 24);
            this.pnlButtons = new PzPanel();
            GridBagLayout pnlButtonsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlButtons, (Object)new AnchorConstraint(664, 1001, 997, 1, 1, 1, 1, 1));
            pnlButtonsLayout.rowWeights = new double[]{0.1};
            pnlButtonsLayout.rowHeights = new int[]{7};
            pnlButtonsLayout.columnWeights = new double[]{0.1, 0.0, 0.0, 0.1, 0.1};
            pnlButtonsLayout.columnWidths = new int[]{20, 77, 132, 20, 20};
            this.pnlButtons.setLayout((LayoutManager)pnlButtonsLayout);
            this.pnlButtons.setOpaque(false);
            this.btnOk = new PzButton();
            this.pnlButtons.add((Component)this.btnOk, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("OK");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/konsignacije/resource/img/check.png")));
            this.btnOk.setPreferredSize(new Dimension(120, 32));
            this.btnOk.setActionCommand("OK");
            this.btnOk.setSize(120, 40);
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setResizable(false);
            this.setSize(424, 233);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("OK")) {
            double novaProvizija = this.iznosProvizijeField.getVal();
            Artikalobracunkonsignacije ao = (Artikalobracunkonsignacije)this.getSession().getParameter("stavka");
            double staraProvizija = ao.getProvizija();
            Obracunkonsignacije obracunKons = (Obracunkonsignacije)this.getSession().getParameter("obracun");
            ao.setProvizija(novaProvizija);
            obracunKons.setProvizija(obracunKons.getProvizija().subtract(PzMathUtility.roundToBigDecimal((double)(ao.getKolicina() * ao.getCena() * staraProvizija / 100.0))).add(PzMathUtility.roundToBigDecimal((double)(ao.getKolicina() * ao.getCena() * novaProvizija / 100.0))));
            obracunKons.setZaPlacanje(obracunKons.getIznos().subtract(obracunKons.getProvizija()));
            em.getTransaction().begin();
            em.merge((Object)obracunKons);
            ((PzTable)this.getSession().getParameter("table")).updateSelectedEntity((PzEntity)ao, em);
            em.getTransaction().commit();
            ((PzTable)this.getSession().getParameter("table")).commitUpdate();
            this.dispose();
        }
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogIzmenaProvizije(Boolean.FALSE);
    }

    public PzDialogIzmenaProvizije(Boolean initGUI) {
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }
}

