/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.net.URI;

public class Util {
    private static boolean desktopCreationAttempted;
    private static Object desktop;
    private static final Object LOCK_DESKTOP_CREATION;

    static {
        LOCK_DESKTOP_CREATION = new Object();
    }

    public static boolean browse(URI uri) {
        Object desktop;
        boolean success = false;
        if (uri != null && (desktop = Util.getDesktop()) != null) {
            try {
                Method m = desktop.getClass().getDeclaredMethod("browse", URI.class);
                m.invoke(desktop, uri);
                success = true;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exception) {}
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getDesktop() {
        Object object = LOCK_DESKTOP_CREATION;
        synchronized (object) {
            if (!desktopCreationAttempted) {
                desktopCreationAttempted = true;
                try {
                    Class<?> desktopClazz = Class.forName("java.awt.Desktop");
                    Method m = desktopClazz.getDeclaredMethod("isDesktopSupported", null);
                    boolean supported = (Boolean)m.invoke(null, null);
                    if (supported) {
                        m = desktopClazz.getDeclaredMethod("getDesktop", null);
                        desktop = m.invoke(null, null);
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception exception) {}
            }
        }
        return desktop;
    }

    public static String getHexString(Color c) {
        if (c == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer("#");
        int r = c.getRed();
        if (r < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(r));
        int g = c.getGreen();
        if (g < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(g));
        int b = c.getBlue();
        if (b < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(b));
        return sb.toString();
    }

    public static Rectangle getScreenBoundsForPoint(int x, int y) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        int i = 0;
        while (i < devices.length) {
            GraphicsConfiguration config = devices[i].getDefaultConfiguration();
            Rectangle gcBounds = config.getBounds();
            if (gcBounds.contains(x, y)) {
                return gcBounds;
            }
            ++i;
        }
        return env.getMaximumWindowBounds();
    }

    public static boolean startsWithIgnoreCase(String str, String start) {
        int startLen = start.length();
        if (str.length() >= startLen) {
            int i = 0;
            while (i < startLen) {
                char c1 = str.charAt(i);
                char c2 = start.charAt(i);
                if (Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

