/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.commporthandler;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TooManyListenersException;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import rs.pezar.kasa.commporthandler.DriverInstaller;
import rs.pezar.kasa.exceptions.GeneralException;

public abstract class DevicePort {
    public static final int MAX_MESSAGE = 1024;
    public static final String BAUD = "BAUD";
    public static final String DATA_BITS = "DATA_BITS";
    public static final String STOP_BITS = "STOP_BITS";
    public static final String PARITY = "PARITY";
    public static final String PORT_NAME = "PORT_NAME";
    public static final int WAIT_FOREVER = -1;
    private int portBaudRate = 19200;
    private int portDataBits = 8;
    private int portStopBits = 1;
    private int portParity = 0;
    private OutputStream outputStream;
    private Semaphore readyReceived;
    private String portName;
    public byte[] message;
    private SerialPort serialPort;

    public DevicePort(HashMap<String, Object> portParams) {
        this.portBaudRate = (Integer)portParams.get(BAUD);
        this.portDataBits = (Integer)portParams.get(DATA_BITS);
        this.portStopBits = (Integer)portParams.get(STOP_BITS);
        this.portParity = (Integer)portParams.get(PARITY);
        this.portName = (String)portParams.get(PORT_NAME);
        this.readyReceived = new Semaphore(0, true);
        this.message = new byte[1024];
    }

    public DevicePort() {
        this.readyReceived = new Semaphore(0, true);
        this.message = new byte[1024];
    }

    private Vector<CommPortIdentifier> getAvailableCOMPorts() {
        Vector<CommPortIdentifier> ports = new Vector<CommPortIdentifier>();
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            ports.addElement(portId);
        }
        return ports;
    }

    public CommPortIdentifier OpenPort(String port) throws GeneralException, PortInUseException, IOException, UnsupportedCommOperationException, TooManyListenersException {
        Vector<CommPortIdentifier> ports = this.getAvailableCOMPorts();
        if (ports.isEmpty()) {
            throw new GeneralException("Ne postoje portovi na ovoj masini!");
        }
        int i = 0;
        while (i < ports.size()) {
            CommPortIdentifier portId = ports.elementAt(i);
            if (portId.getName().equals(port)) {
                this.serialPort = (SerialPort)portId.open("CashRegisterFSM", 2000);
                this.outputStream = this.serialPort.getOutputStream();
                InputStream inputStream = this.serialPort.getInputStream();
                this.serialPort.setSerialPortParams(this.portBaudRate, this.portDataBits, this.portStopBits, this.portParity);
                SerialReader listener = new SerialReader(inputStream);
                this.serialPort.addEventListener((SerialPortEventListener)listener);
                this.serialPort.notifyOnDataAvailable(true);
                return portId;
            }
            ++i;
        }
        return null;
    }

    public CommPortIdentifier OpenPort() throws GeneralException, PortInUseException, IOException, UnsupportedCommOperationException, TooManyListenersException {
        return this.OpenPort(this.portName);
    }

    public void writeToPort(String message, int length) throws IOException {
        byte[] bytes = message.getBytes("Cp1252");
        if (this.outputStream == null) {
            throw new IOException("Port nije otvoren");
        }
        this.outputStream.write(bytes, 0, length);
    }

    public void writeToPort(byte[] message, int length) throws IOException {
        byte[] bytes = message;
        if (this.outputStream == null) {
            throw new IOException("Port nije otvoren");
        }
        this.outputStream.write(bytes, 0, length);
    }

    public byte[] readFromPort(int secondsToWait) throws GeneralException, InterruptedException {
        boolean permitted = false;
        if (secondsToWait >= 0) {
            permitted = this.readyReceived.tryAcquire(secondsToWait, TimeUnit.SECONDS);
        } else {
            this.readyReceived.acquire();
            permitted = true;
        }
        if (!permitted) {
            throw new GeneralException("Vreme isteklo");
        }
        return this.message;
    }

    public void closePort() {
        if (this.serialPort != null) {
            this.serialPort.removeEventListener();
            this.serialPort.close();
            this.serialPort = null;
        }
    }

    public static Vector<String> getAvailablePortNames() {
        Vector<String> v_recognizedPorts = new Vector<String>();
        if (!v_recognizedPorts.isEmpty()) {
            v_recognizedPorts.clear();
        }
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            String portName = portId.getName();
            v_recognizedPorts.addElement(portName);
        }
        return v_recognizedPorts;
    }

    protected abstract boolean handleData(InputStream var1, SerialPortEvent var2);

    public abstract HashMap<String, String> probe() throws IOException;

    public static boolean isInstalled() throws Exception {
        return DriverInstaller.isInstalled();
    }

    public static void install() throws IOException {
        DriverInstaller.install();
    }

    public static void install(JDialog parent) throws IOException {
        DriverInstaller.install(parent);
    }

    public class SerialReader
    implements SerialPortEventListener {
        private InputStream in;
        String temp;

        public SerialReader(InputStream in) {
            this.in = in;
        }

        public void serialEvent(SerialPortEvent arg0) {
            if (DevicePort.this.handleData(this.in, arg0)) {
                DevicePort.this.readyReceived.release();
            }
        }
    }
}

