/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.util;

import java.io.File;
import java.io.IOException;
import net.sourceforge.jiu.codecs.BMPCodec;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageLoader;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedCodecModeException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.MemoryByteChannelImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.geometry.Resample;
import net.sourceforge.jiu.gui.awt.ToolkitLoader;
import net.sourceforge.jiu.ops.BatchProcessorOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class ImageLoadTester
extends BatchProcessorOperation {
    public static final byte IMAGE_THRASHOLD = 125;
    private boolean useToolkit;
    private int numFailed;
    private int numSuccess;
    private int[][] pixelMatrix = new int[432][96];
    private byte[][] luminanceMatrix = new byte[96][56];

    public static void main(String[] args) throws Exception {
        ImageLoadTester tester = new ImageLoadTester();
        boolean useToolkit = true;
        tester.setUseToolkit(useToolkit);
        tester.processFile("c:\\", "bla.jpg", "c:\\temp");
        tester.process();
    }

    public byte[][] ReturnMatrix() {
        int j;
        int k = 0;
        int i = 0;
        while (i < 96) {
            j = 0;
            while (j < 54) {
                this.luminanceMatrix[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 432) {
            j = 0;
            while (j < 96) {
                if (this.pixelMatrix[i][j] > 125) {
                    byte[] byArray = this.luminanceMatrix[j];
                    int n = k;
                    byArray[n] = (byte)(byArray[n] << 1);
                    byte[] byArray2 = this.luminanceMatrix[j];
                    int n2 = k;
                    byArray2[n2] = (byte)(byArray2[n2] | 1);
                } else {
                    byte[] byArray = this.luminanceMatrix[j];
                    int n = k;
                    byArray[n] = (byte)(byArray[n] << 1);
                }
                ++j;
            }
            if ((i + 1) % 8 == 0) {
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < 96) {
            j = 0;
            while (j < 54) {
                this.luminanceMatrix[i][j] = (byte)(this.luminanceMatrix[i][j] ^ 0xFF);
                ++j;
            }
            ++i;
        }
        return this.luminanceMatrix;
    }

    public void processFile(String inputDirectory, String inputFileName, String outputDirectory) {
        int j;
        MemoryByteChannelImage image;
        File file = new File(inputDirectory, inputFileName);
        String name = file.getAbsolutePath();
        MemoryByteChannelImage imageout = null;
        try {
            image = this.useToolkit ? (MemoryByteChannelImage)ToolkitLoader.loadViaToolkitOrCodecs((String)name, (boolean)true, null) : (MemoryByteChannelImage)ImageLoader.load((String)name);
        }
        catch (Exception exception) {
            image = null;
        }
        if (image == null) {
            ++this.numFailed;
            System.out.println(" Failed.");
        } else {
            ++this.numSuccess;
            System.out.println(" OK. Width=" + image.getWidth() + ", height=" + image.getHeight() + " pixels.");
        }
        Resample res = new Resample();
        res.setInputImage((PixelImage)image);
        res.setSize(432, 96);
        try {
            res.process();
        }
        catch (MissingParameterException e1) {
            e1.printStackTrace();
        }
        catch (WrongParameterException e1) {
            e1.printStackTrace();
        }
        imageout = (MemoryByteChannelImage)res.getOutputImage();
        int i = 0;
        while (i < 432) {
            j = 0;
            while (j < 96) {
                this.pixelMatrix[i][j] = (int)(0.3 * (double)imageout.getSample(0, i, j)) + (int)(0.59 * (double)imageout.getSample(1, i, j)) + (int)(0.11 * (double)imageout.getSample(2, i, j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 432) {
            j = 0;
            while (j < 96) {
                imageout.putSample(0, i, j, (int)(0.3 * (double)imageout.getSample(1, i, j)));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 432) {
            j = 0;
            while (j < 96) {
                imageout.putSample(0, i, j, (int)(0.59 * (double)imageout.getSample(2, i, j)));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 432) {
            j = 0;
            while (j < 96) {
                imageout.putSample(0, i, j, (int)(0.11 * (double)imageout.getSample(0, i, j)));
                ++j;
            }
            ++i;
        }
        BMPCodec codec = new BMPCodec();
        codec.setImage((PixelImage)imageout);
        try {
            codec.setFile("aaa.bmp", CodecMode.SAVE);
        }
        catch (UnsupportedCodecModeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            codec.process();
        }
        catch (InvalidFileStructureException e) {
            e.printStackTrace();
        }
        catch (MissingParameterException e) {
            e.printStackTrace();
        }
        catch (UnsupportedTypeException e) {
            e.printStackTrace();
        }
        catch (WrongFileFormatException e) {
            e.printStackTrace();
        }
        catch (OperationFailedException e) {
            e.printStackTrace();
        }
    }

    public void setUseToolkit(boolean newValue) {
        this.useToolkit = newValue;
    }
}

