/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class NativeLibraries {
    private final Field loadedLibraryNames = ClassLoader.class.getDeclaredField("loadedLibraryNames");
    private final Field systemNativeLibraries;
    private final Field nativeLibraries;
    private final Field nativeLibraryFromClass;
    private final Field nativeLibraryName;

    public NativeLibraries() throws NoSuchFieldException {
        this.loadedLibraryNames.setAccessible(true);
        this.systemNativeLibraries = ClassLoader.class.getDeclaredField("systemNativeLibraries");
        this.systemNativeLibraries.setAccessible(true);
        this.nativeLibraries = ClassLoader.class.getDeclaredField("nativeLibraries");
        this.nativeLibraries.setAccessible(true);
        Class<?> nativeLibrary = null;
        Class<?>[] classArray = ClassLoader.class.getDeclaredClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> nested = classArray[n2];
            if (nested.getSimpleName().equals("NativeLibrary")) {
                nativeLibrary = nested;
                break;
            }
            ++n2;
        }
        this.nativeLibraryFromClass = nativeLibrary.getDeclaredField("fromClass");
        this.nativeLibraryFromClass.setAccessible(true);
        this.nativeLibraryName = nativeLibrary.getDeclaredField("name");
        this.nativeLibraryName.setAccessible(true);
    }

    public List<String> getLoadedLibraries() {
        try {
            Vector result = (Vector)this.loadedLibraryNames.get(null);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Map<String, Class<?>> getSystemNativeLibraries() {
        try {
            HashMap result = new HashMap();
            Vector libraries = (Vector)this.systemNativeLibraries.get(null);
            for (Object nativeLibrary : libraries) {
                String libraryName = (String)this.nativeLibraryName.get(nativeLibrary);
                Class fromClass = (Class)this.nativeLibraryFromClass.get(nativeLibrary);
                result.put(libraryName, fromClass);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Map<String, Class<?>> getNativeLibraries(ClassLoader loader) {
        try {
            HashMap result = new HashMap();
            Vector libraries = (Vector)this.nativeLibraries.get(loader);
            for (Object nativeLibrary : libraries) {
                String libraryName = (String)this.nativeLibraryName.get(nativeLibrary);
                Class fromClass = (Class)this.nativeLibraryFromClass.get(nativeLibrary);
                result.put(libraryName, fromClass);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Map<String, Class<?>> getTransitiveNativeLibraries(ClassLoader loader) {
        HashMap result = new HashMap();
        ClassLoader parent = loader.getParent();
        while (parent != null) {
            result.putAll(this.getTransitiveNativeLibraries(parent));
            parent = parent.getParent();
        }
        result.putAll(this.getNativeLibraries(loader));
        return result;
    }

    public Map<String, ClassLoader> getLibraryClassLoaders(Map<String, Class<?>> libraryToClass) {
        HashMap<String, ClassLoader> result = new HashMap<String, ClassLoader>();
        for (Map.Entry<String, Class<?>> entry : libraryToClass.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getClassLoader());
        }
        return result;
    }

    public static List<ClassLoader> getTransitiveClassLoaders(ClassLoader loader) {
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>();
        ClassLoader parent = loader.getParent();
        result.add(loader);
        while (parent != null) {
            result.add(parent);
            parent = parent.getParent();
        }
        return result;
    }
}

