/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Dokumentpotvrda;
import rs.pezar.db.entity.DokumentpotvrdaPK;
import rs.pezar.db.entity.Faktura;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;

public class PzDialogPregledPotvrdaModeratoru
extends PzDialog {
    private PzPanel pnlGlavni;
    private JToolBar toolbar;
    private PzTable tblPotvrde;
    private JScrollPane scrollPane;
    private PzToolBarIcon btnOdobri;
    private PzToolBarIcon brnZabrani;
    private PzStatusBar statusBar;
    private JLabel jlStatusBar = new JLabel();
    private JLabel brStavki = new JLabel();

    public PzDialogPregledPotvrdaModeratoru(JFrame frame) {
        super(frame);
        this.initGUI();
        this.initializeTable();
    }

    public void initializeTable() {
        EntityManager em = PzEntityManager.getEm();
        String pzusername = PzApplication.getApplication().getSession().getLoggedUser().getPzusername();
        List data = em.createQuery("SELECT f From Faktura f where f.idDok in (SELECT p.id.idDok FROM Dokumentpotvrda p WHERE p.pzusername='" + pzusername + "' and p.status=0)").getResultList();
        this.tblPotvrde.setData(data, Faktura.class);
        this.brStavki.setText(Integer.toString(data.size()));
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Zahtevi za izdavanje robe");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{92, 7, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.tblPotvrde = new PzTable();
            this.scrollPane.setViewportView((Component)this.tblPotvrde);
            this.tblPotvrde.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Faktura fak = (Faktura)entity;
                    return new Object[]{fak.getDatum(), fak.getKomitent().getSfrKomitent(), fak.getKomitent().getNaziv(), fak.getUserKraj().getFullName()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Datum", "\u0160ifra komitenta", "Naziv komitenta", "Korisnik"};
                }
            });
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.toolbar.setFloatable(false);
            this.btnOdobri = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnOdobri);
            this.btnOdobri.setText("Odobri arhiviranje|(f5)");
            this.btnOdobri.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/certificate_ok.png")));
            this.btnOdobri.setActionCommand("odobri");
            this.btnOdobri.addActionListener((ActionListener)((Object)this));
            this.btnOdobri.setShortcut("F5");
            this.brnZabrani = new PzToolBarIcon();
            this.toolbar.add((Component)this.brnZabrani);
            this.brnZabrani.setText("Zabrani arhiviranje|(f6)");
            this.brnZabrani.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/certificate_delete.png")));
            this.brnZabrani.setActionCommand("zabrani");
            this.brnZabrani.addActionListener((ActionListener)((Object)this));
            this.brnZabrani.setShortcut("F6");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj zahteva");
            this.statusBar.add((Component)this.brStavki);
            this.brStavki.setFocusable(false);
            this.brStavki.setOpaque(false);
            this.setSize(746, 517);
            this.setMinimumSize(new Dimension(746, 517));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        block7: {
            PzButton button = (PzButton)e.getSource();
            String actionCommand = button.getActionCommand();
            EntityManager em = PzEntityManager.getEm();
            PzApplication.getApplication().getSession().getLoggedUser();
            try {
                try {
                    if (actionCommand.equals("odobri")) {
                        em.getTransaction().begin();
                        Faktura fak = (Faktura)this.tblPotvrde.getSelectedEntity();
                        fak.setArhiviran((short)0);
                        Dokumentpotvrda dok = (Dokumentpotvrda)em.find(Dokumentpotvrda.class, (Object)new DokumentpotvrdaPK(fak.getIdDok(), "FAKTURISANJE"));
                        dok.setStatus(Integer.valueOf(1));
                        em.merge((Object)dok);
                        em.merge((Object)fak);
                        PzProdajaUtil.sendMessage(fak.getUserKraj(), "Vas zahtev za izdavanjem robe kupcu [" + fak.getKomitent().getSfrKomitent() + "] " + fak.getKomitent().getNaziv() + " iz kriti\u010dne liste je odobren.");
                        em.getTransaction().commit();
                        this.initializeTable();
                        break block7;
                    }
                    em.getTransaction().begin();
                    Faktura fak = (Faktura)this.tblPotvrde.getSelectedEntity();
                    fak.setArhiviran((short)0);
                    Dokumentpotvrda dok = (Dokumentpotvrda)em.find(Dokumentpotvrda.class, (Object)new DokumentpotvrdaPK(fak.getIdDok(), "FAKTURISANJE"));
                    dok.setStatus(Integer.valueOf(2));
                    em.merge((Object)dok);
                    em.merge((Object)fak);
                    PzProdajaUtil.sendMessage(fak.getUserKraj(), "Vas zahtev za izdavanjem robe kupcu [" + fak.getKomitent().getSfrKomitent() + "] " + fak.getKomitent().getNaziv() + " iz kriti\u010dne liste je odbijen.");
                    em.getTransaction().commit();
                    this.initializeTable();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }
}

