/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureUsluga;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.prodaja.util.ProdajaGradientUtil;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;

public class FakturaUI
extends PzDialog {
    private static final long serialVersionUID = -4734471008231143192L;
    private static String IZVOZ = "Faktura izvoza";
    private static String UVOZ = "Faktura uvoza";
    private PzRadioGroup<String> panelRBs;
    private JLabel labelVozilo;
    private PzButton btnOk;
    private PzDoubleField fieldKurs;
    private PzTextField fieldCMR;
    private PzTextField fieldRelacijaOd;
    private JLabel labelDatum;
    private JLabel labelRelacija;
    private JLabel labelDo;
    private PzTextField fieldVozilo;
    private PzDateField fieldDatum;
    private PzTextField fieldRelacijaDo;
    private JLabel labelKurs;
    private JLabel labelCMR;
    private PzPanel mainPanel;
    private JLabel labelPolazna;
    private PzDoubleField fieldMinusPolazna;
    private JLabel labelCenaPolazna;
    private PzDoubleField fieldCenaPolazna;
    private JLabel labelDolazna;
    private PzDoubleField fieldMinusDolazna;
    private JLabel labelCenaDolazna;
    private PzDoubleField fieldCenaDolazna;
    private double iznosBezPoreza;

    public FakturaUI(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.setEnabledFieldsUvoz(false);
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(ProdajaGradientUtil.FAKTURA_USLUGA_GRADIENT);
    }

    private void initGUI() {
        this.setTitle("Faktura uvoza/izvoza");
        this.mainPanel = new PzPanel();
        this.mainPanel.setLayout((LayoutManager)new BorderLayout());
        try {
            this.setContentPane((Container)this.mainPanel);
            GridBagLayout thisLayout = new GridBagLayout();
            thisLayout.columnWidths = new int[]{10, 100, 80, 70, 50, 100, 70, 10};
            thisLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            thisLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            thisLayout.rowHeights = new int[]{60, 25, 25, 25, 25, 25, 25, 25, 30, 10};
            this.mainPanel.setLayout((LayoutManager)thisLayout);
            this.panelRBs = new PzRadioGroup((Object[])new String[]{IZVOZ, UVOZ});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRBs, 1);
            this.panelRBs.setOpaque(false);
            this.panelRBs.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRBs, (Object)new GridBagConstraints(2, 0, 4, 1, 0.0, 0.0, 17, 1, new Insets(7, -5, 0, 0), 0, 0));
            this.panelRBs.setSelectedValue((Object)IZVOZ);
            this.panelRBs.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getValue().equals(IZVOZ)) {
                        FakturaUI.this.setEnabledFieldsUvoz(false);
                    } else {
                        FakturaUI.this.setEnabledFieldsUvoz(true);
                    }
                }
            });
            this.labelRelacija = new JLabel();
            this.mainPanel.add((Component)this.labelRelacija, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.labelRelacija.setText("Relacija");
            this.labelRelacija.setPreferredSize(new Dimension(80, 24));
            this.fieldRelacijaOd = new PzTextField();
            this.mainPanel.add((Component)this.fieldRelacijaOd, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.fieldRelacijaOd.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (((String)FakturaUI.this.panelRBs.getSelectedValue()).equals(UVOZ)) {
                        FakturaUI.this.labelPolazna.setText(FakturaUI.this.fieldRelacijaOd.getText());
                    }
                    return true;
                }
            });
            this.labelDo = new JLabel();
            this.labelDo.setHorizontalAlignment(0);
            this.mainPanel.add((Component)this.labelDo, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.labelDo.setPreferredSize(new Dimension(30, 24));
            this.labelDo.setText("Do");
            this.fieldRelacijaDo = new PzTextField();
            this.mainPanel.add((Component)this.fieldRelacijaDo, (Object)new GridBagConstraints(5, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.fieldRelacijaDo.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (((String)FakturaUI.this.panelRBs.getSelectedValue()).equals(UVOZ)) {
                        FakturaUI.this.labelDolazna.setText(FakturaUI.this.fieldRelacijaDo.getText());
                    }
                    return true;
                }
            });
            this.labelDatum = new JLabel();
            this.mainPanel.add((Component)this.labelDatum, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.labelDatum.setText("Datum utovara");
            this.labelDatum.setPreferredSize(new Dimension(80, 24));
            this.fieldDatum = new PzDateField();
            this.mainPanel.add((Component)this.fieldDatum, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.labelVozilo = new JLabel();
            this.mainPanel.add((Component)this.labelVozilo, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.labelVozilo.setText("Vozilo");
            this.labelVozilo.setPreferredSize(new Dimension(80, 24));
            this.fieldVozilo = new PzTextField();
            this.mainPanel.add((Component)this.fieldVozilo, (Object)new GridBagConstraints(2, 3, 5, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.labelCMR = new JLabel();
            this.mainPanel.add((Component)this.labelCMR, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.labelCMR.setPreferredSize(new Dimension(80, 24));
            this.labelCMR.setText("CMR");
            this.fieldCMR = new PzTextField();
            this.mainPanel.add((Component)this.fieldCMR, (Object)new GridBagConstraints(2, 4, 5, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.labelKurs = new JLabel();
            this.mainPanel.add((Component)this.labelKurs, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.labelKurs.setPreferredSize(new Dimension(80, 24));
            this.labelKurs.setText("Kurs evra");
            this.fieldKurs = new PzDoubleField();
            this.fieldKurs.setDecimalFormat(PzFormatFactory.getKursFormat());
            this.mainPanel.add((Component)this.fieldKurs, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.labelPolazna = new JLabel();
            this.mainPanel.add((Component)this.labelPolazna, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.labelPolazna.setText("Polazna -");
            this.labelPolazna.setPreferredSize(new Dimension(80, 24));
            this.fieldMinusPolazna = new PzDoubleField();
            this.fieldMinusPolazna.setDecimalFormat(PzFormatFactory.getProdCenaFormat());
            this.mainPanel.add((Component)this.fieldMinusPolazna, (Object)new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.fieldMinusPolazna.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (((String)FakturaUI.this.panelRBs.getSelectedValue()).equals(UVOZ)) {
                        FakturaUI.this.fieldMinusDolazna.setVal((Object)FakturaUI.this.fieldMinusPolazna.getVal());
                    }
                    return true;
                }
            });
            this.labelCenaPolazna = new JLabel();
            this.labelCenaPolazna.setHorizontalAlignment(0);
            this.mainPanel.add((Component)this.labelCenaPolazna, (Object)new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.labelCenaPolazna.setText("Cena");
            this.fieldCenaPolazna = new PzDoubleField();
            this.fieldCenaPolazna.setDecimalFormat(PzFormatFactory.getProdCenaFormat());
            this.mainPanel.add((Component)this.fieldCenaPolazna, (Object)new GridBagConstraints(5, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.fieldMinusDolazna = new PzDoubleField();
            this.fieldMinusDolazna.setDecimalFormat(PzFormatFactory.getProdCenaFormat());
            this.mainPanel.add((Component)this.fieldMinusDolazna, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.labelDolazna = new JLabel();
            this.mainPanel.add((Component)this.labelDolazna, (Object)new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.labelDolazna.setText("- Dolazna");
            this.labelDolazna.setHorizontalAlignment(4);
            this.labelDolazna.setPreferredSize(new Dimension(80, 24));
            this.labelCenaDolazna = new JLabel();
            this.labelCenaDolazna.setHorizontalAlignment(0);
            this.mainPanel.add((Component)this.labelCenaDolazna, (Object)new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.labelCenaDolazna.setText("Cena");
            this.fieldCenaDolazna = new PzDoubleField();
            this.fieldCenaDolazna.setDecimalFormat(PzFormatFactory.getProdCenaFormat());
            this.mainPanel.add((Component)this.fieldCenaDolazna, (Object)new GridBagConstraints(5, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.btnOk = new PzButton();
            this.mainPanel.add((Component)this.btnOk, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOk.setText("Dalje|(Ctrl+W)");
            this.btnOk.setShortcut("ctrl+w");
            this.pack();
            this.paintPanel();
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setEnabledFieldsUvoz(boolean enable) {
        this.fieldCenaDolazna.setEnabled(enable);
        this.fieldCenaPolazna.setEnabled(enable);
        this.fieldMinusDolazna.setEnabled(enable);
        this.fieldMinusPolazna.setEnabled(enable);
        this.labelCenaDolazna.setEnabled(enable);
        this.labelCenaPolazna.setEnabled(enable);
        this.labelDolazna.setEnabled(enable);
        this.labelPolazna.setEnabled(enable);
        this.fieldKurs.setEnabled(!enable);
        this.labelKurs.setEnabled(!enable);
        if (enable) {
            this.labelDolazna.setText("- Dolazna");
            this.labelPolazna.setText("Polazna -");
        }
    }

    public void actionPerformed(ActionEvent e) {
        String poruka = "";
        poruka = String.valueOf(poruka) + "RELACIJA: " + this.fieldRelacijaOd.getText() + " - " + this.fieldRelacijaDo.getText();
        poruka = String.valueOf(poruka) + "\nDATUM UTOVARA: " + this.fieldDatum.getText() + ".";
        poruka = String.valueOf(poruka) + "\nVOZILO: " + this.fieldVozilo.getText();
        poruka = String.valueOf(poruka) + "\nCMR: " + this.fieldCMR.getText();
        if (((String)this.panelRBs.getSelectedValue()).equals(IZVOZ)) {
            if (this.iznosBezPoreza > 0.0 && this.fieldKurs.getVal() > 0.0) {
                BigDecimal cenaEUR = BDConverter.getProdCena((double)(this.iznosBezPoreza / this.fieldKurs.getVal()));
                poruka = String.valueOf(poruka) + "\nCENA: " + cenaEUR + " EUR";
            }
            this.getSession().putParameter("iznos", null);
        } else {
            poruka = String.valueOf(poruka) + "\n" + this.fieldRelacijaOd.getText() + " - " + BDConverter.getProdCena((double)this.fieldMinusPolazna.getVal()) + ": " + BDConverter.getProdCena((double)this.fieldCenaPolazna.getVal());
            poruka = String.valueOf(poruka) + "\n" + BDConverter.getProdCena((double)this.fieldMinusPolazna.getVal()) + " - " + this.fieldRelacijaDo.getText() + ": " + BDConverter.getProdCena((double)this.fieldCenaDolazna.getVal());
            this.iznosBezPoreza = this.fieldCenaPolazna.getVal() + this.fieldCenaDolazna.getVal();
            this.getSession().putParameter("iznos", (Object)this.iznosBezPoreza);
        }
        this.getSession().putParameter("poruka", (Object)poruka);
        this.setVisible(false);
    }

    public void setIznosBezPoreza(double iznos) {
        this.iznosBezPoreza = iznos;
    }

    public void setKurs(Date datumPrometa) {
        try {
            Kurs k = (Kurs)PzEntityManager.find(Kurs.class, (Object)new KursPK("EUR", datumPrometa));
            this.fieldKurs.setVal((Object)k.getSrednji());
        }
        catch (Exception exception) {}
    }

    public static Object getGUIBuilderInstance() {
        return new FakturaUI(Boolean.FALSE);
    }

    public FakturaUI(Boolean initGUI) {
    }
}

