/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureUsluga;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.commons.beanutils.BeanUtils;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Standardnaporuka;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.db.entity.Valuta;
import rs.pezar.db.management.PzPorukeManager;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzIntegerField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class GrupnoFakturisanjeArhiviranje
extends PzDialog {
    private final PzPanel contentPanel = new PzPanel();
    private PzPanel pnlCenter;
    private JLabel lblOpisNaFakturi;
    private PzTextAreaPanel txtOpis;
    private JLabel lblDatumFakture;
    private PzTextAreaPanel pnlStandardnaPoruka;
    private JScrollPane scrollPane1;
    private PzComboBox comboValuta;
    private JLabel lblValuta;
    private JLabel lblDatumDpo;
    private JLabel lblBrojDanaValute;
    private JLabel lblDatumValute;
    private JLabel lblTekuciRauni;
    private PzDateField datFakture;
    private PzDateField datDPO;
    private PzIntegerField intBrDanaValute;
    private PzDateField datValute;
    private JScrollPane scpRacuni;
    private PzTable tblRacuni;
    private PzTable table;
    private Radnajedinica rj;
    private Kurs kurs;
    private String poruka;

    public GrupnoFakturisanjeArhiviranje() {
        this.initGUI();
    }

    public GrupnoFakturisanjeArhiviranje(PzDialog parent) {
        super(parent);
        this.table = (PzTable)this.getSession().getParameter("table_fakture");
        this.rj = (Radnajedinica)this.getSession().getParameter("rj");
        this.initGUI();
        this.postInit();
        this.initTable();
    }

    private void postInit() {
        try {
            int saPorezom = -1;
            List definicije = this.table.getCheckedEntities();
            for (Fakturausluga definicija : definicije) {
                if (saPorezom == -1) {
                    saPorezom = definicija.getSaPorezom();
                    continue;
                }
                if (definicija.getSaPorezom() != saPorezom) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ne mo\u017eete istovremeno da fakturi\u0161ete fakturu sa i bez poreza.");
                    this.dispose();
                    continue;
                }
                saPorezom = definicija.getSaPorezom();
            }
            Fakturausluga fu = (Fakturausluga)BeanUtils.cloneBean(this.table.getCheckedEntities().get(0));
            fu.setTip(TipDokumentConfig.get().FAKTURA_USLUGA);
            this.poruka = PzPorukeManager.getStandardnaPoruka((PzDokument)fu);
            this.pnlStandardnaPoruka.getArea().setText(this.poruka);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initTable() {
        try {
            List data = PzFirma.getFirma().getTekuciracuns();
            this.tblRacuni.setData(data, Tekuciracun.class);
            this.tblRacuni.hideColumnByName("Podrazumevani");
            if (this.tblRacuni.getDataSize() > 0) {
                int index = -1;
                int i = 0;
                while (i < this.tblRacuni.getDataSize()) {
                    index = Integer.parseInt(this.tblRacuni.getModel().getValueAt(this.tblRacuni.convertRowIndexToModel(i), 0).toString());
                    if (index == 1) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                this.tblRacuni.setRowSelectionInterval(index, index);
            }
            try {
                Standardnaporuka sp = (Standardnaporuka)PzEntityManager.getList((String)"SELECT sp FROM Standardnaporuka sp WHERE sp.tipDokumenta='GRUPNO_FAKTURISANJE'").get(0);
                if (sp != null) {
                    this.txtOpis.setVal((Object)sp.getSadrzaj());
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initGUI() {
        this.setTitle("Arhiva i \u0161tampa");
        this.setBounds(0, 0, 677, 612);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        this.contentPanel.add((Component)buttonPane, (Object)"South");
        buttonPane.setLayout(new FlowLayout(1));
        PzButton okButton = new PzButton("OK");
        okButton.addActionListener((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = -5465117509967167656L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GrupnoFakturisanjeArhiviranje.this.okButtonactionPerformed(arg0);
            }
        });
        okButton.setShortcut("ctrl+w");
        okButton.setText("Arhiviraj (CTRL+W)");
        okButton.setIcon((Icon)new ImageIcon(GrupnoFakturisanjeArhiviranje.class.getResource("/rs/pezar/prodaja/resource/img/check.png")));
        okButton.setActionCommand("OK");
        buttonPane.add((Component)okButton);
        this.getRootPane().setDefaultButton((JButton)okButton);
        this.pnlCenter = new PzPanel();
        GridBagLayout gbl_pnlCenter = new GridBagLayout();
        this.pnlCenter.setOpaque(false);
        this.pnlCenter.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
        this.contentPanel.add((Component)this.pnlCenter, (Object)"Center");
        int[] nArray = new int[5];
        nArray[0] = 102;
        nArray[1] = 94;
        nArray[2] = 282;
        gbl_pnlCenter.columnWidths = nArray;
        int[] nArray2 = new int[10];
        nArray2[3] = 25;
        nArray2[4] = 25;
        nArray2[5] = 25;
        nArray2[6] = 25;
        nArray2[7] = 25;
        nArray2[8] = 128;
        gbl_pnlCenter.rowHeights = nArray2;
        gbl_pnlCenter.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_pnlCenter.rowWeights = new double[]{0.0, 0.1, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.pnlCenter.setLayout((LayoutManager)gbl_pnlCenter);
        this.lblOpisNaFakturi = new JLabel("Opis na fakturi:");
        GridBagConstraints gbc_lblOpisNaFakturi = new GridBagConstraints();
        gbc_lblOpisNaFakturi.anchor = 13;
        gbc_lblOpisNaFakturi.insets = new Insets(0, 0, 5, 5);
        gbc_lblOpisNaFakturi.gridx = 0;
        gbc_lblOpisNaFakturi.gridy = 0;
        this.pnlCenter.add((Component)this.lblOpisNaFakturi, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.txtOpis = new PzTextAreaPanel();
        GridBagConstraints gbc_txtOpis = new GridBagConstraints();
        gbc_txtOpis.gridwidth = 4;
        gbc_txtOpis.insets = new Insets(0, 0, 5, 5);
        gbc_txtOpis.fill = 1;
        gbc_txtOpis.gridx = 0;
        gbc_txtOpis.gridy = 1;
        this.pnlCenter.add((Component)this.txtOpis, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.lblDatumFakture = new JLabel("Datum fakture:");
        GridBagConstraints gbc_lblDatumFakture = new GridBagConstraints();
        gbc_lblDatumFakture.anchor = 13;
        gbc_lblDatumFakture.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumFakture.gridx = 0;
        gbc_lblDatumFakture.gridy = 2;
        this.pnlCenter.add((Component)this.lblDatumFakture, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.datFakture = new PzDateField();
        this.datFakture.setColumns(20);
        GridBagConstraints gbc_datFakture = new GridBagConstraints();
        gbc_datFakture.fill = 2;
        gbc_datFakture.insets = new Insets(0, 0, 5, 5);
        gbc_datFakture.gridx = 1;
        gbc_datFakture.gridy = 2;
        this.pnlCenter.add((Component)this.datFakture, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.lblDatumDpo = new JLabel("Datum prometa:");
        GridBagConstraints gbc_lblDatumDpo = new GridBagConstraints();
        gbc_lblDatumDpo.anchor = 13;
        gbc_lblDatumDpo.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumDpo.gridx = 0;
        gbc_lblDatumDpo.gridy = 3;
        this.pnlCenter.add((Component)this.lblDatumDpo, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.datDPO = new PzDateField();
        this.datDPO.setColumns(8);
        GridBagConstraints gbc_datDPO = new GridBagConstraints();
        gbc_datDPO.fill = 2;
        gbc_datDPO.insets = new Insets(0, 0, 5, 5);
        gbc_datDPO.gridx = 1;
        gbc_datDPO.gridy = 3;
        this.pnlCenter.add((Component)this.datDPO, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.lblBrojDanaValute = new JLabel("Broj dana valute:");
        GridBagConstraints gbc_lblBrojDanaValute = new GridBagConstraints();
        gbc_lblBrojDanaValute.anchor = 13;
        gbc_lblBrojDanaValute.insets = new Insets(0, 0, 5, 5);
        gbc_lblBrojDanaValute.gridx = 0;
        gbc_lblBrojDanaValute.gridy = 4;
        this.pnlCenter.add((Component)this.lblBrojDanaValute, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.intBrDanaValute = new PzIntegerField();
        this.intBrDanaValute.setColumns(8);
        GridBagConstraints gbc_intBrDanaValute = new GridBagConstraints();
        gbc_intBrDanaValute.fill = 2;
        gbc_intBrDanaValute.insets = new Insets(0, 0, 5, 5);
        gbc_intBrDanaValute.gridx = 1;
        gbc_intBrDanaValute.gridy = 4;
        this.pnlCenter.add((Component)this.intBrDanaValute, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.intBrDanaValute.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GrupnoFakturisanjeArhiviranje.this.keyRel(evt);
            }
        });
        this.lblDatumValute = new JLabel("Datum valute:");
        GridBagConstraints gbc_lblDatumValute = new GridBagConstraints();
        gbc_lblDatumValute.anchor = 13;
        gbc_lblDatumValute.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumValute.gridx = 0;
        gbc_lblDatumValute.gridy = 5;
        this.pnlCenter.add((Component)this.lblDatumValute, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.datValute = new PzDateField();
        this.datValute.setColumns(10);
        GridBagConstraints gbc_datValute = new GridBagConstraints();
        gbc_datValute.fill = 2;
        gbc_datValute.insets = new Insets(0, 0, 5, 5);
        gbc_datValute.gridx = 1;
        gbc_datValute.gridy = 5;
        this.pnlCenter.add((Component)this.datValute, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.lblTekuciRauni = new JLabel("Teku\u0107i ra\u010duni:");
        GridBagConstraints gbc_lblTekuiRauni = new GridBagConstraints();
        gbc_lblTekuiRauni.anchor = 13;
        gbc_lblTekuiRauni.insets = new Insets(0, 0, 0, 5);
        gbc_lblTekuiRauni.gridx = 0;
        gbc_lblTekuiRauni.gridy = 6;
        this.pnlCenter.add((Component)this.lblTekuciRauni, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.scpRacuni = new JScrollPane();
        GridBagConstraints gbc_scpRacuni = new GridBagConstraints();
        gbc_scpRacuni.gridwidth = 2;
        gbc_scpRacuni.insets = new Insets(0, 0, 0, 5);
        gbc_scpRacuni.fill = 1;
        gbc_scpRacuni.gridx = 1;
        gbc_scpRacuni.gridy = 6;
        this.pnlCenter.add((Component)this.scpRacuni, (Object)new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tblRacuni = new PzTable();
        this.scpRacuni.setViewportView((Component)this.tblRacuni);
        this.lblValuta = new JLabel();
        this.pnlCenter.add((Component)this.lblValuta, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.lblValuta.setText("Valuta za prera\u010dun deviznih iznosa:");
        this.comboValuta = new PzComboBox();
        this.pnlCenter.add((Component)this.comboValuta, (Object)new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        for (Valuta v : q.getResultList()) {
            this.comboValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
        String defaultValuta = PzParameter.getParameterValue((String)"DEF_VALUTA");
        if (defaultValuta != null) {
            int j = 0;
            while (j < this.comboValuta.getItemCount()) {
                PzChoice currChoice = (PzChoice)this.comboValuta.getItemAt(j);
                if (currChoice.getValue().equals(defaultValuta)) {
                    this.comboValuta.setSelectedIndex(j);
                    break;
                }
                ++j;
            }
        }
        this.scrollPane1 = new JScrollPane();
        this.pnlCenter.add((Component)this.scrollPane1, (Object)new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.pnlStandardnaPoruka = new PzTextAreaPanel();
        this.pnlStandardnaPoruka.getArea().setBorder((Border)BorderFactory.createTitledBorder("Standardna poruka"));
        this.scrollPane1.setViewportView((Component)this.pnlStandardnaPoruka);
        this.pnlStandardnaPoruka.getArea().setText(this.poruka);
        this.pack();
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            Date date1 = this.datDPO.getVal();
            int val = this.intBrDanaValute.getVal();
            this.datValute.setVal((Object)PzDateUtility.add((Date)date1, (int)val));
        }
    }

    protected void okButtonactionPerformed(ActionEvent arg0) {
        this.arhivirajFakture();
    }

    private void arhivirajFakture() {
        EntityManager em = PzEntityManager.getEm();
        try {
            List definicije = this.table.getCheckedEntities();
            if (!this.proveriKurs(definicije)) {
                JOptionPane.showMessageDialog((Component)this.pnlCenter, "Me\u0111u odabranim definicijama postoji definicija u deviznom iznosu!\nMora postojati definisan srednji kurs odabrane valute na uneti datum prometa!", "Informacija", 1);
                return;
            }
            try {
                Standardnaporuka sp;
                ArrayList<Fakturausluga> fakture = new ArrayList<Fakturausluga>();
                em.getTransaction().begin();
                for (Fakturausluga definicija : definicije) {
                    Fakturausluga fu = (Fakturausluga)BeanUtils.cloneBean((Object)definicija);
                    fu.setIdDok(0);
                    fu.setArhiviran((short)0);
                    fu.setDokument(null);
                    fu.setTip(TipDokumentConfig.get().FAKTURA_USLUGA);
                    fu.setPodTip(TipDokumentConfig.get().PODTIP_FAKTURA_USLUGA);
                    ((Stavkafaktureusl)fu.getStavkafaktureusls().get(0)).setNaziv(this.txtOpis.getArea().getText());
                    fu.setDatPrometa(this.datDPO.getVal());
                    fu.setDatum(this.datFakture.getVal());
                    fu.setDatValute(this.datValute.getVal());
                    fu.setTekuciRacun(((Tekuciracun)this.tblRacuni.getSelectedEntity()).getBrRacuna());
                    fu.setRadnajedinica(this.rj);
                    fu.setPoruka(this.pnlStandardnaPoruka.getArea().getText());
                    fu.adjust();
                    List stavke = fu.getStavkafaktureusls();
                    List troskovi = fu.getPutnitrosaks();
                    fu.setStavkafaktureusls(null);
                    fu.setPutnitrosaks(null);
                    if (definicija.getPodTip().equals("DEV")) {
                        BigDecimal iznos = BDConverter.getIznos((BigDecimal)fu.getVrednostUsluga().multiply(this.kurs.getSrednji()));
                        fu.setVrednostUsluga(iznos);
                        ((Stavkafaktureusl)stavke.get(0)).setCena(iznos.doubleValue());
                    }
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)fu, true, null, em);
                    em.flush();
                    fu.setStavkafaktureusls(stavke);
                    fu.setPutnitrosaks(troskovi);
                    PzEntityUtil.addTaksaDokuments((PzDokument)fu, (String)"PDV");
                    if (fu.getTaksafakturas() != null && fu.getTaksafakturas().size() != 0) {
                        fu.setSaPorezom(1);
                    }
                    fu.adjust();
                    fu.getDokument().update((PzDokument)fu, true);
                    em.merge((Object)fu);
                    em.flush();
                    fakture.add(fu);
                }
                try {
                    sp = (Standardnaporuka)em.createQuery("SELECT sp FROM Standardnaporuka sp WHERE sp.tipDokumenta='GRUPNO_FAKTURISANJE'").getResultList().get(0);
                    sp.setSadrzaj(this.txtOpis.getVal());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    sp = new Standardnaporuka();
                    Integer id = (Integer)PzEntityManager.getList((String)"SELECT MAX(p.oznPoruka) FROM Standardnaporuka p").get(0);
                    if (id == null) {
                        id = new Integer(0);
                    }
                    id = id + 1;
                    sp.setOznPoruka(id.intValue());
                    sp.setTipDokumenta("GRUPNO_FAKTURISANJE");
                    sp.setNaziv("Grupno fakturisanje");
                    sp.setSadrzaj(this.txtOpis.getVal());
                    sp.setUslov("");
                    em.persist((Object)sp);
                }
                em.getTransaction().commit();
                PzReportManager.ReportDescriptor rd = new PzReportManager.ReportDescriptor(){

                    public String getTitle(PzDokument d) {
                        return "Faktura usluga " + d.getOznDokumenta();
                    }
                };
                PzReportManager.createAndShowReports((PzDialog)this, fakture, (PzReportManager.ReportDescriptor)rd, null);
                this.getParentDialog().dispose();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        finally {
            em.close();
        }
    }

    private boolean proveriKurs(List<Fakturausluga> definicije) throws Exception {
        for (Fakturausluga fakUsl : definicije) {
            if (!fakUsl.getPodTip().equals("DEV")) continue;
            Kurs k = (Kurs)PzEntityManager.find(Kurs.class, (Object)new KursPK(this.comboValuta.getSelectedChoice().getValue().toString(), this.datDPO.getVal()));
            if (k == null) {
                return false;
            }
            this.kurs = k;
            return true;
        }
        return true;
    }

    public void actionPerformed(ActionEvent e) {
    }
}

