/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;

public class KonvertovanjeFakture
extends PzDialog {
    private Radnajedinica rjU;
    private PzPanel panelMain;
    private JLabel jlTekst;
    private JLabel jlURJ;
    private JLabel jlIzRJ;
    private PzButton btnOk;
    private Faktura f;

    public KonvertovanjeFakture(PzDialog dialog) {
        super(dialog);
        this.f = (Faktura)this.getSession().getParameter("faktura");
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.panelMain.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.panelMain.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.panelMain.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.panelMain = new PzPanel();
            GridBagLayout thisLayout = new GridBagLayout();
            this.setTitle("Konvertovanje fakture iz velikoprodaje u maloprodaju");
            thisLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            thisLayout.rowHeights = new int[]{10, 25, 25, 25, 40};
            thisLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            thisLayout.columnWidths = new int[]{10, 390, 10};
            this.panelMain.setLayout((LayoutManager)thisLayout);
            this.getContentPane().add((Component)this.panelMain);
            this.btnOk = new PzButton();
            this.panelMain.add((Component)this.btnOk, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.btnOk.setPreferredSize(new Dimension(100, 27));
            this.btnOk.setName("btnOk");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.jlTekst = new JLabel();
            this.panelMain.add((Component)this.jlTekst, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jlTekst.setName("jlTekst");
            this.jlTekst.setHorizontalAlignment(0);
            this.jlIzRJ = new JLabel();
            this.panelMain.add((Component)this.jlIzRJ, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jlIzRJ.setName("jlIzRJ");
            this.jlIzRJ.setText("<html><strong>IZ</strong> radne jedinice: <strong>" + this.f.getRadnajedinica().getPunNaziv() + "</strong></html>");
            this.jlIzRJ.setHorizontalAlignment(0);
            this.jlURJ = new JLabel();
            this.panelMain.add((Component)this.jlURJ, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jlURJ.setName("jlURJ");
            this.jlURJ.setHorizontalAlignment(0);
            this.setSize(300, 250);
            this.setResizable(false);
            this.pack();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                Interniracun interniNalog = PzEntityUtil.createInterniNalog((Faktura)this.f, (Radnajedinica)this.rjU, (EntityManager)em);
                PzDokumentManager.getInstance().arhivirajDokument((PzDokument)interniNalog, true, null, em);
                this.f.setRadnajedinica(this.rjU);
                em.merge((Object)this.f);
                em.getTransaction().commit();
                interniNalog.setVrsta("N");
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)interniNalog);
                this.getSession().putParameter("konvertovano", (Object)true);
                this.dispose();
            }
            catch (Exception ex) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public boolean shouldBeShown() {
        this.rjU = PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"E", "EV", "EL", "ET"});
        if (this.rjU != null) {
            this.setVisible(false);
            this.jlURJ.setText("<html><strong>U</strong> radnu jedinicu: <strong>" + this.rjU.getPunNaziv() + "?</strong></html>");
            return true;
        }
        this.setVisible(false);
        return false;
    }

    public static Object getGUIBuilderInstance() {
        return new KonvertovanjeFakture(Boolean.FALSE);
    }

    public KonvertovanjeFakture(Boolean initGUI) {
    }
}

