/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.db.entity.Stavkaporudzbine;
import rs.pezar.db.util.WebPorudzbina;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.preuzimanjePorudzbine.IspravkaPodataka;
import rs.pezar.prodaja.util.PreuzimanjePorudzbineUtil;
import rs.pezar.sifarnici.gui.artikli.Upit;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzMathUtility;

public class PreuzimanjePorudzbine
extends PzDialog {
    private static final long serialVersionUID = -7206069507582469344L;
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);
    private Faktura f = null;
    private PzToolBarIcon icnIzjednaciCene;
    private PzTable table;
    private JScrollPane scrpTable;
    private PzPanel pnlTable;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnBrisanjeSvega;
    private PzToolBarIcon icnIzjednaciSveCene;
    private PzToolBarIcon icnPreuzimanjeIzKonsignacije;
    private PzToolBarIcon icnOsvezavanjeKolicine;
    private PzToolBarIcon icnUpitUStanjeArtikla;
    private PzToolBarIcon icnIspravkaPodataka;
    private PzToolBarIcon icnBrisanjeDokumenta;
    private JToolBar toolbar;
    private PzPanel pnlContent;
    private PzStatusBar pzStatusBar;
    private JLabel lblBrojStavki;
    private JScrollPane jScrollPane1;
    private JTextArea txtKomentar;
    private PzTextField txtKomitent;
    private JPanel pnlKomitent;
    private JLabel numBrojStavki;
    private boolean arhiviranje;
    private WebPorudzbina wp;

    public PreuzimanjePorudzbine(PzDialog dialog) {
        super(dialog);
        this.f = (Faktura)this.getSession().getParameter("faktura");
        this.initGUI();
    }

    public PreuzimanjePorudzbine() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Preuzimanje porud\u017ebine");
            this.pnlContent = new PzPanel();
            this.pnlContent.setLayout((LayoutManager)new BorderLayout());
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.toolbar = new JToolBar();
            this.pnlContent.add((Component)this.toolbar, (Object)"North");
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.icnIspravkaPodataka = new PzToolBarIcon();
            this.icnIspravkaPodataka.setText("Ispravka|podataka (F3)");
            this.toolbar.add((Component)this.icnIspravkaPodataka);
            this.icnIspravkaPodataka.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/note_edit.png")));
            this.icnIspravkaPodataka.setActionCommand("ispravka");
            this.icnIspravkaPodataka.addActionListener((ActionListener)((Object)this));
            this.icnIspravkaPodataka.setShortcut("F3");
            this.icnIspravkaPodataka.setName("icnIspravkaPodataka");
            this.icnBrisanjeDokumenta = new PzToolBarIcon();
            this.icnBrisanjeDokumenta.setText("Brisanje|(DEL)");
            this.toolbar.add((Component)this.icnBrisanjeDokumenta);
            this.icnBrisanjeDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/note_delete.png")));
            this.icnBrisanjeDokumenta.setActionCommand("brisanje");
            this.icnBrisanjeDokumenta.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeDokumenta.setShortcut("delete");
            this.icnBrisanjeDokumenta.setName("icnBrisanjeDokumenta");
            this.icnUpitUStanjeArtikla = new PzToolBarIcon();
            this.icnUpitUStanjeArtikla.setText("Upit u|stanje (F2)");
            this.toolbar.add((Component)this.icnUpitUStanjeArtikla);
            this.icnUpitUStanjeArtikla.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/message_edit.png")));
            this.icnUpitUStanjeArtikla.setActionCommand("upit");
            this.icnUpitUStanjeArtikla.addActionListener((ActionListener)((Object)this));
            this.icnUpitUStanjeArtikla.setShortcut("F2");
            this.icnUpitUStanjeArtikla.setName("icnUpitUStanjeArtikla");
            this.icnOsvezavanjeKolicine = new PzToolBarIcon();
            this.icnOsvezavanjeKolicine.setText("Osve\u017eavanje|koli\u010dine (F4)");
            this.toolbar.add((Component)this.icnOsvezavanjeKolicine);
            this.icnOsvezavanjeKolicine.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/businessman_view.png")));
            this.icnOsvezavanjeKolicine.setActionCommand("osvezavanje");
            this.icnOsvezavanjeKolicine.addActionListener((ActionListener)((Object)this));
            this.icnOsvezavanjeKolicine.setShortcut("F4");
            this.icnOsvezavanjeKolicine.setName("icnOsvezavanjeKolicine");
            this.icnPreuzimanjeIzKonsignacije = new PzToolBarIcon();
            this.icnPreuzimanjeIzKonsignacije.setText("Uzmi sa|konsignacije (F5)");
            this.icnPreuzimanjeIzKonsignacije.setActionCommand("preuzimanje");
            this.icnPreuzimanjeIzKonsignacije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/note_edit.png")));
            this.icnPreuzimanjeIzKonsignacije.addActionListener((ActionListener)((Object)this));
            this.icnPreuzimanjeIzKonsignacije.setShortcut("F5");
            this.icnPreuzimanjeIzKonsignacije.setName("icnPreuzimanjeIzKonsignacije");
            this.icnIzjednaciSveCene = new PzToolBarIcon();
            this.icnIzjednaciSveCene.setText("Izjedna\u010di cene|sa cenama iz|magacina(F10)");
            this.icnIzjednaciSveCene.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/businessman2.png")));
            this.icnIzjednaciSveCene.setActionCommand("izjednaciSve");
            this.icnIzjednaciSveCene.addActionListener((ActionListener)((Object)this));
            this.icnIzjednaciSveCene.setShortcut("F10");
            this.icnIzjednaciSveCene.setName("icnIzjednaciSveCene");
            this.icnArhiva = new PzToolBarIcon();
            this.icnArhiva.setText("Spremi fakturu|(CTRL+W)");
            this.toolbar.add((Component)this.icnArhiva);
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/printer_preferences.png")));
            this.icnArhiva.setActionCommand("arhiviranje");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("CTRL+W");
            this.icnArhiva.setName("btnArhivaIStampa");
            this.pnlTable = new PzPanel();
            this.pnlTable.setBorder((Border)new EmptyBorder(5, 10, 5, 10));
            this.pnlContent.add((Component)this.pnlTable, (Object)"Center");
            GridBagLayout pnlTableLayout = new GridBagLayout();
            pnlTableLayout.columnWidths = new int[]{7};
            pnlTableLayout.rowHeights = new int[]{114, 7};
            pnlTableLayout.columnWeights = new double[]{0.1};
            pnlTableLayout.rowWeights = new double[]{0.0, 0.1};
            this.pnlTable.setLayout((LayoutManager)pnlTableLayout);
            this.scrpTable = new JScrollPane();
            this.pnlTable.add((Component)this.scrpTable, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.table = new PzTable();
            this.table.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent arg0) {
                    PreuzimanjePorudzbine.this.numBrojStavki.setText("" + PreuzimanjePorudzbine.this.table.getRowCount());
                }
            });
            this.scrpTable.setViewportView((Component)this.table);
            this.pzStatusBar = new PzStatusBar();
            this.pnlContent.add((Component)this.pzStatusBar, (Object)"South");
            this.lblBrojStavki = new JLabel("Broj stavki:");
            this.pzStatusBar.add((Component)this.lblBrojStavki);
            this.numBrojStavki = new JLabel("0");
            this.pzStatusBar.add((Component)this.numBrojStavki);
            this.table.getTableHeader().setFocusable(false);
            this.pnlKomitent = new JPanel();
            GridBagLayout pnlKomitentLayout = new GridBagLayout();
            this.pnlTable.add((Component)this.pnlKomitent, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
            pnlKomitentLayout.rowWeights = new double[]{0.0, 0.1};
            pnlKomitentLayout.rowHeights = new int[]{7, 7};
            pnlKomitentLayout.columnWeights = new double[]{0.1};
            pnlKomitentLayout.columnWidths = new int[]{7};
            this.pnlKomitent.setLayout(pnlKomitentLayout);
            this.txtKomitent = new PzTextField();
            this.txtKomitent.setFocusable(false);
            this.txtKomitent.setFont(new Font("SansSerif", 1, 16));
            this.pnlKomitent.add((Component)this.txtKomitent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.jScrollPane1 = new JScrollPane();
            this.pnlKomitent.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtKomentar = new JTextArea();
            this.txtKomentar.setFocusable(false);
            this.txtKomentar.setFont(new Font("SansSerif", 1, 12));
            this.jScrollPane1.setViewportView(this.txtKomentar);
            this.setSize(1024, 800);
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            PzButton button = (PzButton)e.getSource();
            String actionCommand = button.getActionCommand();
            Stavkaporudzbine stavka = (Stavkaporudzbine)this.table.getSelectedEntity();
            this.getSession().putParameter("table", (Object)this.table);
            if (actionCommand.equalsIgnoreCase("preuzimanje")) {
                Integer br;
                if (stavka != null && (br = Integer.valueOf(Integer.parseInt(this.table.getValueAt(this.table.getSelectedRow(), 0).toString()))) == 0) {
                    this.preuzmiIzKonsignacije();
                }
            } else if (actionCommand.equalsIgnoreCase("izjednaci")) {
                if (stavka != null) {
                    this.izjednaciCenu(stavka);
                    this.table.updateSelectedEntity((PzEntity)stavka, true);
                }
            } else if (actionCommand.equalsIgnoreCase("osvezavanje")) {
                this.osvezi();
            } else if (actionCommand.equalsIgnoreCase("izjednaciSve")) {
                for (Stavkaporudzbine st : this.f.getStavkaporudzbines()) {
                    if (st.getStanjeartikal().getProdCena() == st.getCenaPorucena().doubleValue()) continue;
                    this.izjednaciCenu(st);
                }
                this.table.refreshData();
            } else if (actionCommand.equalsIgnoreCase("brisanje")) {
                this.brishiStavku();
            } else if (actionCommand.equalsIgnoreCase("ispravka")) {
                this.showDialog(IspravkaPodataka.class);
            } else if (actionCommand.equalsIgnoreCase("upit")) {
                Upit.upit((PzDialog)this, (Stanjeartikal)stavka.getStanjeartikal());
            } else if (actionCommand.equalsIgnoreCase("brisiSve")) {
                this.brisiSveStavke();
            } else if (actionCommand.equalsIgnoreCase("arhiviranje")) {
                this.arhiviranje = true;
                List stavke = this.f.getStavkaporudzbines();
                PreuzimanjePorudzbineUtil.transformToArtikalFakturas(this.f.getStavkaporudzbines(), this.f, this);
                PzGenericService service = PzApplication.getApplication().getGenericServiceRegistry().getService("ORDER_GETTER_SERVICE");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("COMMAND", "END");
                params.put("ID", this.wp.getId());
                service.run(params);
                if (this.f.getKomitent().getEmail() == null || !EMAIL_PATTERN.matcher(this.f.getKomitent().getEmail()).matches()) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Komitent nema definisanu validnu email adresu tako da slanje potvrde nije moguce");
                } else if (PzParameter.getBoolean((String)"PORUDZBINA_POTVRDA", (boolean)true).booleanValue()) {
                    PreuzimanjePorudzbineUtil.posaljiMejl(stavke, this.txtKomentar.getText(), String.valueOf(this.wp.getId()), this.f.getKomitent().getEmail());
                }
            }
        }
        catch (Exception ex) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    private void osvezi() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        for (Stavkaporudzbine stavka : this.f.getStavkaporudzbines()) {
            stavka.setStanjeartikal((Stanjeartikal)em.find(Stanjeartikal.class, (Object)new StanjeartikalPK(stavka.getStanjeartikal().getId().getSfrProizvod(), stavka.getStanjeartikal().getRadnajedinica())));
        }
        int row = this.table.getSelectedRow();
        this.table.refreshData();
        this.table.setRowSelectionInterval(row, row);
        em.close();
    }

    private void brishiStavku() {
        if (!this.dozvoljenoBrisanje()) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                PreuzimanjePorudzbineUtil.vratiKolicine((Stavkaporudzbine)this.table.getSelectedEntity(), em);
                this.table.removeSelectedEntity(false, em);
                em.getTransaction().commit();
                this.table.commitRemove();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void brisiSveStavke() {
        if (!this.dozvoljenoBrisanje()) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                for (Stavkaporudzbine stavka : this.f.getStavkaporudzbines()) {
                    PreuzimanjePorudzbineUtil.vratiKolicine(stavka, em);
                }
                Faktura f = (Faktura)em.find(Faktura.class, (Object)this.f.getIdDok());
                f.setStavkaporudzbines(new Vector());
                em.getTransaction().commit();
                this.dispose();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private boolean dozvoljenoBrisanje() {
        return JOptionPane.showConfirmDialog((Component)((Object)this), "Da li ste sigurni?", "Brisanje?", 0) == 0;
    }

    private void izjednaciCenu(Stavkaporudzbine st) throws Exception {
        Stanjeartikal s = st.getStanjeartikal();
        if (s.getProdCena() == 0.0) {
            throw new Exception("Artikal " + st.getStanjeartikal().getId().getSfrProizvod() + " do sada nije imao promet u izabranoj radnoj jedinici!");
        }
        st.setCenaPorucena(PzMathUtility.roundToBigDecimal((double)s.getProdCena()));
    }

    private void preuzmiIzKonsignacije() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                PreuzimanjePorudzbineUtil.preuzmiIzKonsignacije((Stavkaporudzbine)this.table.getSelectedEntity(), em, this, this.table);
                em.getTransaction().commit();
                this.table.commitUpdate();
            }
            catch (Exception ex) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public boolean shouldBeShown() {
        Radnajedinica rj = (Radnajedinica)this.getSession().getParameter("RJ_PORUDZBINA");
        if (rj == null) {
            return false;
        }
        this.wp = (WebPorudzbina)this.getSession().getParameter("PORUDZBINA");
        if (this.wp == null) {
            return false;
        }
        this.getSession().putParameter("PORUDZBINA", null);
        PreuzimanjePorudzbineUtil.ucitajPorudzbinu(this.wp, rj, this.table, this);
        Komitent k = (Komitent)PzEntityManager.findEntity(Komitent.class, (Object)this.wp.getSfrKomitent());
        this.txtKomitent.setVal((Object)("[ " + k.getSfrKomitent() + "] " + k.getNaziv()));
        this.txtKomentar.setText(this.wp.getComment());
        return true;
    }

    public static Object getGUIBuilderInstance() {
        return new PreuzimanjePorudzbine(Boolean.FALSE);
    }

    public PreuzimanjePorudzbine(Boolean initGUI) {
    }

    public void setRenderers() {
        this.table.getColumn(0).setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean isSelected, boolean arg3, int arg4, int arg5) {
                JLabel renderer = new JLabel();
                Integer kol = (Integer)value;
                if (kol < 0) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/forbidden_small.png")));
                } else if (kol == 0) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/warning_small.png")));
                } else if (kol > 0) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check_small.png")));
                }
                if (isSelected) {
                    renderer.setBackground(Color.GRAY);
                }
                renderer.setOpaque(true);
                renderer.setHorizontalAlignment(0);
                return renderer;
            }
        });
        this.table.getColumn(6).setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean isSelected, boolean arg3, int arg4, int arg5) {
                JLabel renderer = new JLabel();
                Integer ind = (Integer)value;
                if (ind == 0) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/forbidden_small.png")));
                } else {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check_small.png")));
                }
                if (isSelected) {
                    Color col = PreuzimanjePorudzbine.this.table.getDefaultRenderer(Object.class).getTableCellRendererComponent((JTable)PreuzimanjePorudzbine.this.table, value, isSelected, arg3, arg4, arg5).getBackground();
                    renderer.setBackground(col);
                }
                renderer.setOpaque(true);
                renderer.setHorizontalAlignment(0);
                return renderer;
            }
        });
    }

    public void setFaktura(Faktura fak) {
        this.f = fak;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        block3: {
            super.thisWindowClosing(evt);
            if (!this.arhiviranje) {
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                try {
                    em.getTransaction().begin();
                    PreuzimanjePorudzbineUtil.vratiKolicine(this.f, em);
                    em.getTransaction().commit();
                }
                catch (Exception exception) {
                    if (!em.getTransaction().isActive()) break block3;
                    em.getTransaction().rollback();
                }
            }
        }
    }
}

