/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Stanje;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;

public class ProdajaKupcuIOrijentacionaRazlika
extends PzDialog {
    private static final long serialVersionUID = 3914215384473094536L;
    private JScrollPane spScroll;
    private PzDoubleField dfUkupno;
    private PzTable tblTabela;
    private PzPanel pnlGlavni;
    private JLabel lblUkupno;
    private PzPanel pnlDugmad;
    private Faktura f;
    private Artikalfaktura af;
    private String tableID = "";

    public ProdajaKupcuIOrijentacionaRazlika(PzDialog dialog) {
        super(dialog);
        String title;
        this.f = (Faktura)this.getSession().getParameter("faktura");
        this.af = (Artikalfaktura)this.getSession().getParameter("artikal");
        if (this.getSession().getParameter("orijentacija") != null) {
            this.tableID = "TABLE_ORIJENTACIJA";
            this.setId("ORIJENTACIJA");
            title = "Orijentaciona razlika u ceni";
        } else {
            this.tableID = "TABLE_PRODAJA";
            this.setId("PRODAJA");
            title = "Prodaja artikla " + this.af.getId().getSfrProizvod() + ", kupcu: " + this.f.getKomitent().getSfrKomitent();
        }
        this.initGUI();
        this.paintPanel();
        this.setTitle(title);
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.1, 0.0};
            pnlGlavniLayout.rowHeights = new int[]{7, 30};
            pnlGlavniLayout.columnWeights = new double[]{0.1};
            pnlGlavniLayout.columnWidths = new int[]{7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setOpaque(false);
            this.pnlDugmad = new PzPanel();
            this.pnlGlavni.add((Component)this.pnlDugmad, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            GridBagLayout pnlDugmadLayout = new GridBagLayout();
            pnlDugmadLayout.rowWeights = new double[]{0.1};
            pnlDugmadLayout.rowHeights = new int[]{7};
            pnlDugmadLayout.columnWeights = new double[]{0.0, 0.1};
            pnlDugmadLayout.columnWidths = new int[]{107, 7};
            this.pnlDugmad.setLayout((LayoutManager)pnlDugmadLayout);
            this.pnlDugmad.setOpaque(false);
            this.lblUkupno = new JLabel();
            this.pnlDugmad.add((Component)this.lblUkupno, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.lblUkupno.setText("Ukupno");
            this.lblUkupno.setFont(new Font("Tahoma", 1, 12));
            this.dfUkupno = new PzDoubleField();
            this.pnlDugmad.add((Component)this.dfUkupno, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.dfUkupno.setPreferredSize(new Dimension(123, 25));
            this.dfUkupno.setFont(new Font("Tahoma", 1, 14));
            this.dfUkupno.setFocusable(false);
            this.dfUkupno.setEditable(false);
            this.spScroll = new JScrollPane();
            this.pnlGlavni.add((Component)this.spScroll, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.tblTabela = new PzTable();
            if (this.getSession().getParameter("orijentacija") != null) {
                this.tblTabela.setFilter(new PzEntityFilter(){

                    public Object[] getValues(PzEntity entity) {
                        Artikalfaktura af = (Artikalfaktura)entity;
                        double nabavnaCena = 0.0;
                        for (Stanje s : af.getArtikal().getStanjes()) {
                            if (!s.getRadnajedinica().equals(ProdajaKupcuIOrijentacionaRazlika.this.f.getRadnajedinica())) continue;
                            nabavnaCena = s.getZadNabCena();
                        }
                        double razlika = af.getKolicina() * Math.abs(nabavnaCena - af.getCena());
                        return new Object[]{af.getId().getSfrProizvod(), af.getNaziv(), af.getKolicina(), nabavnaCena, af.getCena(), razlika};
                    }

                    public String[] getColumnNames() {
                        return new String[]{"\u0160ifra", "Naziv", "Koli\u010dina", "Nabavna cena", "Prodajna cena", "Razlika"};
                    }
                });
                this.tblTabela.setData(this.f.getArtikalfakturas(), Artikalfaktura.class);
                this.lblUkupno.setText("Ukupna razlika");
            } else {
                this.tblTabela.setFilter(new PzEntityFilter(){

                    public Object[] getValues(PzEntity entity) {
                        Artikalfaktura af = (Artikalfaktura)entity;
                        return new Object[]{af.getFaktura().getDatum(), af.getFaktura().getOznDokumenta(), af.getKolicina(), af.getProcRabata(), af.getCena(), af.naracunajIznosBezRabata()};
                    }

                    public String[] getColumnNames() {
                        return new String[]{"Datum", "Faktura", "Koli\u010dina", "% rabata", "Cena", "Vrednost"};
                    }
                });
                EntityManager em = PzEntityManager.getEm();
                Query q = null;
                q = em.createQuery("SELECT af FROM Artikalfaktura af where af.id.sfrProizvod=:artikal and af.faktura.komitent=:komitent and af.faktura.radnajedinica=:rj and af.faktura.tip=:tip and af.faktura.arhiviran = 1 and af.faktura.storno = 0");
                q.setParameter("artikal", (Object)this.af.getId().getSfrProizvod());
                q.setParameter("komitent", (Object)this.f.getKomitent());
                q.setParameter("rj", (Object)this.f.getRadnajedinica());
                q.setParameter("tip", (Object)"FAKTURA");
                Vector data = (Vector)q.getResultList();
                this.tblTabela.setData(data, Artikalfaktura.class);
                em.close();
            }
            this.tblTabela.setId(this.tableID);
            this.spScroll.setViewportView((Component)this.tblTabela);
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.setRowSelectionAllowed(false);
            this.tblTabela.setColumnSelectionAllowed(false);
            this.tblTabela.setCellSelectionEnabled(false);
            if (this.tblTabela.getDataSize() > 0) {
                this.dfUkupno.setVal((Object)this.getUkupno());
            }
            this.setSize(800, 400);
            this.setMinimumSize(new Dimension(800, 400));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    private double getUkupno() {
        double iznos = 0.0;
        int i = 0;
        while (i < this.tblTabela.getDataSize()) {
            if (this.tblTabela.getValueAt(i, this.tblTabela.getColumnCount() - 1) != null) {
                iznos += Double.valueOf(this.tblTabela.getValueAt(i, this.tblTabela.getColumnCount() - 1).toString()).doubleValue();
            }
            ++i;
        }
        return iznos;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public static Object getGUIBuilderInstance() {
        return new ProdajaKupcuIOrijentacionaRazlika(Boolean.FALSE);
    }

    public ProdajaKupcuIOrijentacionaRazlika(Boolean initGUI) {
    }
}

