/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.IzradaFaktureIzRJ;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogTrosak
extends PzDialog {
    private PzPanel mainPanel;
    private PzPanel pnlFields;
    private PzTextField tfOpis;
    private PzTextField tfProcenat;
    private PzFieldIndikator indTg;
    private PzDoubleField tfIznosPdv;
    private PzTextField tfTarifnaGrupa;
    private JLabel lblTarifnaTrupa;
    private JLabel lblIznosPdv;
    private PzDoubleField tfOsnovica;
    private JLabel lblOsnovica;
    private PzButton btnPotvrdi;
    private PzDoubleField dfIznos;
    private JLabel lblIznos;
    private JLabel lblOpis;
    private PzPanelHeader header;
    private final Faktura faktura = (Faktura)this.getSession().getParameter("faktura");
    private Boolean maloprodaja = false;
    private Tarifnagrupa entTarifnaGrupa;
    private Fakturaparameter dTrosak;
    private Fakturaparameter dTrosakIznos;
    private Fakturaparameter dTrosakTg;
    private Fakturaparameter dTrosakTgIznos;
    private PzButton btnObrisi;
    private PropertiesConfiguration props;
    private File confFile;
    private String OPIS = "OPIS";
    private Firma firma;
    private PzButton btnSnimi;

    public PzDialogTrosak(PzDialog dialog) {
        super(dialog);
        if (this.faktura.getRadnajedinica().getgTip().equals("E")) {
            this.maloprodaja = true;
        }
        try {
            this.firma = PzFirma.getFirma();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.OPIS = String.valueOf(this.OPIS) + "_" + this.firma.getMatBroj();
        this.initGUI();
        this.postInit();
        this.loadProperties();
        this.paintPanel();
        this.tfOpis.setText(this.props.getProperty(this.OPIS) == null ? "" : this.props.getProperty(this.OPIS).toString());
    }

    private void loadProperties() {
        this.props = new PropertiesConfiguration();
        this.confFile = new File(String.valueOf(PzApplication.getApplication().getDataFolder().getAbsolutePath()) + File.separator + "PzDialogTrosak.properties");
        try {
            if (!this.confFile.exists()) {
                this.props.load(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/gui/faktureZaProdajuRobe/resources/PzDialogTrosak.properties"));
            } else {
                this.props.load(this.confFile);
            }
        }
        catch (ConfigurationException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void postInit() {
        this.dTrosak = this.faktura.getFakturaparameter(this.faktura.getIdDok(), "DOD_TROS_NAZIV");
        if (this.dTrosak != null) {
            this.tfOpis.setVal((Object)this.dTrosak.getValue());
            this.dTrosakIznos = this.faktura.getFakturaparameter(this.faktura.getIdDok(), "DOD_TROS_IZNOS");
            if (this.dTrosakIznos != null) {
                this.dfIznos.setVal((Object)new Double(this.dTrosakIznos.getValue()));
            }
            this.dTrosakTg = this.faktura.getFakturaparameter(this.faktura.getIdDok(), "DOD_TROS_TG");
            this.dTrosakTgIznos = this.faktura.getFakturaparameter(this.faktura.getIdDok(), "DOD_TROS_TG_IZNOS");
            if (this.dTrosakTg != null) {
                this.entTarifnaGrupa = (Tarifnagrupa)PzEntityManager.getEm().find(Tarifnagrupa.class, (Object)this.dTrosakTg.getValue());
                if (this.entTarifnaGrupa != null) {
                    this.tfTarifnaGrupa.setVal((Object)this.entTarifnaGrupa.getOznTarGr());
                    this.tfProcenat.setVal((Object)this.entTarifnaGrupa.getStopa());
                    this.indTg.setState(PzFieldIndikator.STATE_VALID);
                }
            }
            if (this.maloprodaja.booleanValue()) {
                double osnovica = 100.0 * this.dfIznos.getVal() / (this.entTarifnaGrupa.getStopa() + 100.0);
                this.tfOsnovica.setVal((Object)osnovica);
                this.tfIznosPdv.setVal((Object)(this.dfIznos.getVal() - osnovica));
            } else {
                this.tfOsnovica.setVal((Object)this.dfIznos.getVal());
                this.tfIznosPdv.setVal((Object)(this.dfIznos.getVal() * this.entTarifnaGrupa.getStopa() / 100.0));
            }
        }
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Dodatni tro\u0161ak");
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setPreferredSize(new Dimension(550, 263));
            mainPanelLayout.rowHeights = new int[]{7};
            mainPanelLayout.columnWidths = new int[]{7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/money_envelope_new.png")));
            this.header.setTitle("Unos dodatnog tro\u0161ka");
            this.mainPanel.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setOpaque(false);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7};
            pnlFieldsLayout.columnWidths = new int[]{7, 112, 107, 7};
            this.mainPanel.add((Component)this.pnlFields, (Object)new GridBagConstraints(3, 4, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlFields.setOpaque(false);
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
            this.lblOpis = new JLabel();
            this.pnlFields.add((Component)this.lblOpis, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblOpis.setText("Opis tro\u0161ka");
            this.tfOpis = new PzTextField();
            this.pnlFields.add((Component)this.tfOpis, (Object)new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.lblTarifnaTrupa = new JLabel();
            this.pnlFields.add((Component)this.lblTarifnaTrupa, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblTarifnaTrupa.setText("Tarifna grupa:");
            this.tfTarifnaGrupa = new PzTextField();
            this.pnlFields.add((Component)this.tfTarifnaGrupa, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 25), 0, 0));
            this.tfTarifnaGrupa.setToUpperCase(true);
            this.tfTarifnaGrupa.setFKField(Tarifnagrupa.class, PzDialogStopePoreza.class, true, null);
            this.tfTarifnaGrupa.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (!PzDialogTrosak.this.tfTarifnaGrupa.getVal().startsWith("U")) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogTrosak.this), (String)"Pogre\u0161na tarifna gurpa. Izaberite tarifnu grupu za usluge.");
                        return false;
                    }
                    return true;
                }
            });
            this.lblIznos = new JLabel();
            this.pnlFields.add((Component)this.lblIznos, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            if (this.maloprodaja.booleanValue()) {
                this.lblIznos.setText("Iznos sa porezom:");
            } else {
                this.lblIznos.setText("Iznos bez poreza:");
            }
            this.dfIznos = new PzDoubleField();
            this.pnlFields.add((Component)this.dfIznos, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfIznos.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogTrosak.this.tfTarifnaGrupa.equals("")) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogTrosak.this), (String)"Niste izabrali tarifnu grupu.");
                        return false;
                    }
                    if (PzDialogTrosak.this.dfIznos.getVal() != 0.0) {
                        if (PzDialogTrosak.this.maloprodaja.booleanValue()) {
                            double osnovica = 100.0 * PzDialogTrosak.this.dfIznos.getVal() / (PzDialogTrosak.this.entTarifnaGrupa.getStopa() + 100.0);
                            PzDialogTrosak.this.tfOsnovica.setVal((Object)osnovica);
                            PzDialogTrosak.this.tfIznosPdv.setVal((Object)(PzDialogTrosak.this.dfIznos.getVal() - osnovica));
                        } else {
                            PzDialogTrosak.this.tfOsnovica.setVal((Object)PzDialogTrosak.this.dfIznos.getVal());
                            PzDialogTrosak.this.tfIznosPdv.setVal((Object)(PzDialogTrosak.this.dfIznos.getVal() * PzDialogTrosak.this.entTarifnaGrupa.getStopa() / 100.0));
                        }
                    }
                    return true;
                }
            });
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnObrisi = new PzButton();
            this.pnlFields.add((Component)this.btnObrisi, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
            this.btnObrisi.setText("Obri\u0161i");
            this.btnObrisi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/forbidden.png")));
            this.btnObrisi.addActionListener((ActionListener)((Object)this));
            this.btnObrisi.setActionCommand("obrisi");
            this.btnSnimi = new PzButton();
            this.pnlFields.add((Component)this.btnSnimi, (Object)new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 180), 0, 0));
            this.btnSnimi.setText("Snimi opis");
            this.btnSnimi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/save.png")));
            this.btnSnimi.addActionListener((ActionListener)((Object)this));
            this.btnSnimi.setShortcut("ctrl+s");
            this.btnSnimi.setActionCommand("snimi");
            this.lblOsnovica = new JLabel();
            this.pnlFields.add((Component)this.lblOsnovica, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblOsnovica.setText("Osnovica:");
            this.tfOsnovica = new PzDoubleField();
            this.pnlFields.add((Component)this.tfOsnovica, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfOsnovica.setBackground(new Color(202, 233, 244));
            this.tfOsnovica.setFocusable(false);
            this.tfOsnovica.setEditable(false);
            this.lblIznosPdv = new JLabel();
            this.pnlFields.add((Component)this.lblIznosPdv, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 10), 0, 0));
            this.lblIznosPdv.setText("Iznos PDV-a:");
            this.tfIznosPdv = new PzDoubleField();
            this.pnlFields.add((Component)this.tfIznosPdv, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfIznosPdv.setBackground(new Color(202, 233, 244));
            this.tfIznosPdv.setFocusable(false);
            this.tfIznosPdv.setEditable(false);
            this.indTg = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indTg, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.tfProcenat = new PzTextField();
            this.pnlFields.add((Component)this.tfProcenat, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 50), 0, 0));
            this.tfProcenat.setFocusable(false);
            this.tfProcenat.setEditable(false);
            this.tfProcenat.setBackground(new Color(202, 233, 244));
            this.tfTarifnaGrupa.setStateIndikator(this.indTg);
            this.setRestorable(false);
            this.setSize(660, 340);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent e) {
        button = (PzButton)e.getSource();
        actionCommand = button.getActionCommand();
        em = PzEntityManagerFactory.getInstance().createEm();
        try {
            if (!actionCommand.equals("potvrdi")) ** GOTO lbl60
            if (this.tfOpis.getVal().equals("") || this.dfIznos.getVal() == 0.0 || this.tfTarifnaGrupa.getVal().equals("")) {
                PzSwingUtility.showErrorMessage((Component)this, (String)"Niste unijeli sva polja.");
lbl8:
                // 2 sources

                return;
            }
            try {
                block27: {
                    em.getTransaction().begin();
                    if (this.dTrosak == null) {
                        this.dTrosak = new Fakturaparameter(this.faktura.getIdDok(), "DOD_TROS_NAZIV", this.tfOpis.getVal(), "");
                        em.persist((Object)this.dTrosak);
                        this.faktura.getFakturaparameters().add(this.dTrosak);
                    } else {
                        this.dTrosak.setValue(this.tfOpis.getVal());
                        em.merge((Object)this.dTrosak);
                    }
                    if (this.dTrosakIznos == null) {
                        this.dTrosakIznos = new Fakturaparameter(this.faktura.getIdDok(), "DOD_TROS_IZNOS", BDConverter.getIznos((double)this.dfIznos.getVal()).toString(), "");
                        em.persist((Object)this.dTrosakIznos);
                        this.faktura.getFakturaparameters().add(this.dTrosakIznos);
                    } else {
                        this.dTrosakIznos.setValue(BDConverter.getIznos((double)this.dfIznos.getVal()).toString());
                        em.merge((Object)this.dTrosakIznos);
                    }
                    if (this.dTrosakTg == null) {
                        this.dTrosakTg = new Fakturaparameter(this.faktura.getIdDok(), "DOD_TROS_TG", this.tfTarifnaGrupa.getVal(), "");
                        em.persist((Object)this.dTrosakTg);
                        this.faktura.getFakturaparameters().add(this.dTrosakTg);
                    } else {
                        this.dTrosakTg.setValue(this.tfTarifnaGrupa.getVal());
                        em.merge((Object)this.dTrosakTg);
                    }
                    if (this.dTrosakTgIznos == null) {
                        this.dTrosakTgIznos = new Fakturaparameter(this.faktura.getIdDok(), "DOD_TROS_TG_IZNOS", BDConverter.getIznos((double)this.tfIznosPdv.getVal()).toString(), "");
                        em.persist((Object)this.dTrosakTgIznos);
                        this.faktura.getFakturaparameters().add(this.dTrosakTgIznos);
                    } else {
                        this.dTrosakTgIznos.setValue(BDConverter.getIznos((double)this.tfIznosPdv.getVal()).toString());
                        em.merge((Object)this.dTrosakTgIznos);
                    }
                    em.merge((Object)this.faktura);
                    em.getTransaction().commit();
                    if (this.maloprodaja.booleanValue()) {
                        ((IzradaFaktureIzRJ)this.getParent()).refreshSaPorezom(this.dfIznos.getVal());
                        ((IzradaFaktureIzRJ)this.getParent()).refreshBezPoreza(this.tfOsnovica.getVal());
                        ((IzradaFaktureIzRJ)this.getParent()).refreshTrosak(this.dfIznos.getVal());
                    } else {
                        ((IzradaFaktureIzRJ)this.getParent()).refreshSaPorezom(this.dfIznos.getVal() + this.tfIznosPdv.getVal());
                        ((IzradaFaktureIzRJ)this.getParent()).refreshBezPoreza(this.dfIznos.getVal());
                        ((IzradaFaktureIzRJ)this.getParent()).refreshTrosak(this.dfIznos.getVal());
                    }
                    break block27;
lbl60:
                    // 1 sources

                    if (actionCommand.equals("obrisi")) {
                        em.getTransaction().begin();
                        if (this.dTrosak != null) {
                            em.remove(em.find(Fakturaparameter.class, (Object)this.dTrosak.getId()));
                            em.remove(em.find(Fakturaparameter.class, (Object)this.dTrosakIznos.getId()));
                            em.remove(em.find(Fakturaparameter.class, (Object)this.dTrosakTg.getId()));
                            em.remove(em.find(Fakturaparameter.class, (Object)this.dTrosakTgIznos.getId()));
                        }
                        em.getTransaction().commit();
                        this.faktura.getFakturaparameters().remove(this.dTrosak);
                        this.faktura.getFakturaparameters().remove(this.dTrosakIznos);
                        this.faktura.getFakturaparameters().remove(this.dTrosakTg);
                        this.faktura.getFakturaparameters().remove(this.dTrosakTgIznos);
                        if (actionCommand.equals("obrisi")) {
                            PzSwingUtility.showInformationMessage((Component)this, (String)"Tro\u0161kovi su obrisani.");
                        }
                    } else if (actionCommand.equals("snimi")) {
                        this.props.setProperty(this.OPIS, (Object)this.tfOpis.getText());
                        try {
                            this.props.save(this.confFile);
                        }
                        catch (ConfigurationException e1) {
                            PzMysqlExceptionHandler.handle((Component)this, (Throwable)e1);
                        }
                        ** continue;
                    }
                }
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)this, (Throwable)e1);
            }
        }
        finally {
            em.close();
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        if (entity instanceof Tarifnagrupa) {
            this.entTarifnaGrupa = (Tarifnagrupa)entity;
            this.tfTarifnaGrupa.setVal((Object)this.entTarifnaGrupa.getOznTarGr());
            this.tfProcenat.setVal((Object)(String.valueOf(this.entTarifnaGrupa.getStopa()) + "%"));
        }
    }
}

