/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.cashregister.galeb.gp100.port;

import gnu.io.SerialPortEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import rs.pezar.cashregister.galeb.gp100.gui.GP100Control;
import rs.pezar.kasa.cashregister.DatecsProtocol;
import rs.pezar.kasa.commporthandler.DevicePort;
import rs.pezar.kasa.util.HexDump;

public class Gp100Port
extends DevicePort {
    public static final byte MSG_PREAMBLE = 1;
    public static final byte MSG_DELIMITER = 4;
    public static final byte MSG_POSTAMBLE = 5;
    public static final byte MSG_TERMINATOR = 3;
    public static final byte SYN_SYNC = 22;
    public static final byte SYN_NAK = 21;
    public static final byte MSG_ERROR = -1;
    private static final int PROBE_DELAY = 3;
    private static final String DEVICE_IDENTIFIER = "2.76SR 21MAY08";
    public static final Vector<String> bauds = new Vector();

    static {
        bauds.add("1200");
        bauds.add("2400");
        bauds.add("4800");
        bauds.add("9600");
        bauds.add("19200");
        bauds.add("38400");
        bauds.add("57600");
        bauds.add("115200");
    }

    public Gp100Port(HashMap<String, Object> portParams) {
        super(portParams);
    }

    public Gp100Port() {
    }

    protected boolean handleData(InputStream in, SerialPortEvent sEvt) {
        int data;
        block9: {
            int len;
            byte[] buffer;
            block8: {
                block7: {
                    buffer = new byte[1024];
                    len = 0;
                    boolean set = false;
                    do {
                        if ((data = in.read()) == -1 && !set) continue;
                        set = true;
                        buffer[len++] = (byte)data;
                    } while (data != 3 && data != 21 && data != 22);
                    if (data != 3) break block7;
                    this.message = Arrays.copyOf(buffer, len);
                    return true;
                }
                if (data != 22) break block8;
                System.out.println("More time needed ( Sync reached )!");
                this.message = "w".getBytes();
                return true;
            }
            if (data != 21) break block9;
            System.out.println("Nak poruka primljena. Moguca greska u poslatim podacima, ukoliko se ponavlja moguce los kabl.");
            this.message = "r".getBytes();
            String temp = HexDump.toString((byte[])buffer, (int)0, (int)len);
            System.out.println(temp);
            return true;
        }
        try {
            if (data == -1) {
                System.out.println("Error detected 0xff!");
            }
        }
        catch (IOException e) {
            System.out.println("Unexpected serial port error!");
            e.printStackTrace();
        }
        return false;
    }

    public static HashMap<String, String> probeDevice() {
        Gp100Port port = new Gp100Port();
        return port.probe();
    }

    public HashMap<String, String> probe() {
        Vector names = Gp100Port.getAvailablePortNames();
        GP100Control cashRegister = new GP100Control();
        DatecsProtocol fp550Protocol = new DatecsProtocol();
        HashMap<String, String> results = null;
        byte[] initialMessage = null;
        int j = 0;
        while (j < bauds.size()) {
            int i = 0;
            while (i < names.size()) {
                block11: {
                    HashMap<String, Object> portParams = new HashMap<String, Object>();
                    portParams.put("BAUD", Integer.parseInt(bauds.get(j)));
                    portParams.put("PARITY", 0);
                    portParams.put("DATA_BITS", 8);
                    portParams.put("STOP_BITS", 1);
                    portParams.put("PORT_NAME", (String)names.get(i));
                    Gp100Port gp550port = new Gp100Port(portParams);
                    try {
                        gp550port.OpenPort();
                    }
                    catch (Exception exception) {
                        System.out.println("Port " + (String)names.get(i) + " je nemoguce otvoriti.");
                        break block11;
                    }
                    try {
                        initialMessage = cashRegister.ControlGetDiagnose();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        String temp = new String(initialMessage);
                        gp550port.writeToPort(temp, temp.lastIndexOf(3) + 1);
                        byte[] returnData = gp550port.readFromPort(3);
                        if (fp550Protocol.CheckMessageIntegrity(returnData) == 0) {
                            if (results == null) {
                                results = new HashMap<String, String>();
                            }
                            if (new String(returnData).contains(DEVICE_IDENTIFIER)) {
                                results.put("PORT", (String)names.get(i));
                            }
                            results.put("BAUD", bauds.get(j));
                        }
                        gp550port.closePort();
                    }
                    catch (Exception e) {
                        gp550port.closePort();
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            ++j;
        }
        return results;
    }

    public static void main(String[] args) {
        new GP100Control();
        Gp100Port fp550port = new Gp100Port();
        HashMap<String, String> printers = null;
        printers = fp550port.probe();
        if (printers != null) {
            System.out.println(printers.get(0));
        } else {
            System.out.println("Nije detektovan printer");
        }
    }
}

