/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici;

import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzExtension;
import rs.pezar.core.gui.defaultWidgets.mainView.MainViewWidget;
import rs.pezar.core.gui.defaultWidgets.mainView.TreeElement;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.podesavanja.PnlArtikli;
import rs.pezar.podesavanja.PnlVidljivostGrupaKomitenata;
import rs.pezar.swing.PzMenu;
import rs.pezar.swing.PzMenuItem;
import rs.pezar.util.PzFileUtility;

public class PzExtensionLoader
implements PzExtension {
    private TreeElement element;
    private PzApplication application;
    private PzMenu menu;
    private static PzExtensionLoader instance;

    public void initExtension(PzApplication application) {
        try {
            instance = this;
            this.application = application;
            application.getTreeElementRegistry().add(this.element);
            application.getMenuRegistry().add(this.menu);
            EntityManager em = application.getEmf().createEm();
            List rgr = em.createQuery("SELECT r.naziv FROM Robnagrupa r").getResultList();
            List modeli = em.createQuery("SELECT m.naziv FROM Model m").getResultList();
            List komitenti = em.createQuery("SELECT k.naziv FROM Komitent k").getResultList();
            application.getSession().getRuntimeStore().put("list_komitenti", (Object)komitenti);
            application.getSession().getRuntimeStore().put("list_rgr", (Object)rgr);
            application.getSession().getRuntimeStore().put("list_modeli", (Object)modeli);
            application.getSettingsManager().getPanelIntList().add(new PnlArtikli());
            application.getSettingsManager().getPanelIntList().add(new PnlVidljivostGrupaKomitenata());
            em.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            Document dok = PzFileUtility.loadXML((String)"rs/pezar/sifarnici/resource/view.xml", (ClassLoader)this.getClass().getClassLoader());
            this.element = new TreeElement((Node)dok.getDocumentElement(), this.getClass().getClassLoader());
            Document m = PzFileUtility.loadXML((String)"rs/pezar/menu/resource/menu.xml", (ClassLoader)this.getClass().getClassLoader());
            this.menu = new PzMenu((Node)m.getDocumentElement(), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unload() {
        ((MainViewWidget)this.application.getWorkbench().getWorkArea().getWidgetById(MainViewWidget.ID)).removeElement(this.element);
        this.element = null;
        PzMenu menu1 = this.getApplication().getWorkbench().getWorkbenchMenuBar().getMenuById(this.menu.getId());
        for (PzMenuItem i : this.menu.getItems()) {
            menu1.remove((JMenuItem)i);
        }
    }

    public PzApplication getApplication() {
        return this.application;
    }

    public static Pzuser getLoggedUser() {
        return instance.getApplication().getSession().getLoggedUser();
    }

    public static PzExtensionLoader getInstance() {
        return instance;
    }
}

