/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.util.ComponentWindowProvider;
import bibliothek.gui.dock.util.WindowProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import rs.pezar.core.PzApplication;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.sifarnici.gui.PzDialogArtikliExtended;
import rs.pezar.sifarnici.gui.artikli.DodavanjeExtended;
import rs.pezar.sifarnici.gui.artikli.NaprednaPretraga;
import rs.pezar.sifarnici.gui.artikli.Upit;
import rs.pezar.sifarnici.gui.artikli.browser.ComponentRegistry;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserComponent;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserSearchPanel;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserTablePanel;
import rs.pezar.sifarnici.gui.artikli.browser.tools.BrowserQueryAction;
import rs.pezar.sifarnici.gui.artikli.browser.tools.QueryTool;
import rs.pezar.sifarnici.util.AnalitikaHelper;
import rs.pezar.sifarnici.util.ProdajaHelper;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzManageableTable;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.RabatnaPolitikaManager;

public class PzArtikliBrowser
extends PzDialog {
    private static final long serialVersionUID = 2997127732453412958L;
    public static Radnajedinica BROWSER_RJ;
    private Boolean pamtiSifru = null;
    private static CControl SHARED_CONTROL;
    private final JPanel contentPanel = new JPanel();
    private PzToolBar toolbar;
    private PzStatusBar statusBar;
    private PzPanel pnlMain;
    private CControl control;
    private BrowserSearchPanel pnlSearch;
    private BrowserTablePanel pnlTable;
    private CGrid grid;
    private Radnajedinica rj;
    private PzToolBarIcon icnOtvoriNovArtikal;
    private PzToolBarIcon icnUpitURadneJedinice;
    private PzToolBarIcon icnIzmeniPostojeceOsnovnePodatke;
    private PzToolBarIcon icnBrisanjeArtikla;
    private PzToolBarIcon icnLokacije;
    private PzToolBarIcon icnNaprednaPretraga;
    private JLabel lblBrPogodaka;
    private PzToolBarIcon icnPozicioniranjeNaziv;
    private PzToolBarIcon icnKarticaArtikla;
    private HashMap<String, Object> services;
    private PzToolBarIcon icnPropustenaProdaja;
    private Komitent komitent;
    private String parameter;
    private PzToolBarIcon icnSifarnik;
    private PzToolBarIcon icnPozicioniranjeSifra;

    static {
        SHARED_CONTROL = null;
    }

    public static void main(String[] args) {
        try {
            PzArtikliBrowser dialog = new PzArtikliBrowser();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PzArtikliBrowser() {
        this.initGUI();
    }

    public PzArtikliBrowser(PzDialog parent) {
        super(parent);
        if (this.getSession().getParameter("browser_rj") != null) {
            this.rj = (Radnajedinica)this.getSession().getParameter("browser_rj");
            this.getSession().putParameter("browser_rj", null);
        } else if (BROWSER_RJ != null) {
            this.rj = BROWSER_RJ;
            BROWSER_RJ = null;
        }
        this.komitent = (Komitent)PzApplication.getApplication().getSession().getRuntimeStore().get("KOMITENT_SA_FAKTURE");
        this.initGUI();
        this.initServices();
        this.search();
    }

    public PzArtikliBrowser(PzDialog parent, boolean izmena, Object data1, Object data2) {
        super(parent);
        this.rj = (Radnajedinica)data1;
        this.komitent = (Komitent)PzApplication.getApplication().getSession().getRuntimeStore().get("KOMITENT_SA_FAKTURE");
        this.initGUI();
        this.initServices();
        this.search();
    }

    public PzArtikliBrowser(JFrame parent) {
        super(parent);
        this.initGUI();
    }

    private void search() {
        if (this.pamtiSifru == null) {
            this.pamtiSifru = PzParameter.getBoolean((String)"PAMTI_SIFRU", (boolean)false);
        }
        if (this.pamtiSifru.booleanValue() && Stanjeartikal.last != null) {
            try {
                this.searchByLast(Stanjeartikal.last);
                Stanjeartikal.last = null;
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.pnlSearch.searchInStanjeartikal();
        }
    }

    private void initGUI() {
        Pzuser u = PzApplication.getApplication().getSession().getLoggedUser();
        boolean imaDozvolu = u.isModerator() || u.getDozvola("TREE", "rs.pezar.sifarnici.gui.PzDialogArtikliExtended[null]") != null;
        this.setTitle("Pretra\u017eiva\u010d artikala");
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.toolbar = new PzToolBar();
        this.contentPanel.add((Component)this.toolbar, "North");
        this.icnOtvoriNovArtikal = new PzToolBarIcon();
        this.toolbar.add((Component)this.icnOtvoriNovArtikal);
        this.icnOtvoriNovArtikal.setText("Otvori nov|artikal|(INS)");
        this.icnOtvoriNovArtikal.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_add.png")));
        this.icnOtvoriNovArtikal.addActionListener((ActionListener)((Object)this));
        this.icnOtvoriNovArtikal.setActionCommand("insert");
        this.icnOtvoriNovArtikal.setShortcut("insert");
        this.icnOtvoriNovArtikal.setEnabled(imaDozvolu);
        this.icnIzmeniPostojeceOsnovnePodatke = new PzToolBarIcon();
        this.toolbar.add((Component)this.icnIzmeniPostojeceOsnovnePodatke);
        this.icnIzmeniPostojeceOsnovnePodatke.setText("Izmeni|podatke| (F3)");
        this.icnIzmeniPostojeceOsnovnePodatke.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_edit.png")));
        this.icnIzmeniPostojeceOsnovnePodatke.setActionCommand("izmeni");
        this.icnIzmeniPostojeceOsnovnePodatke.addActionListener((ActionListener)((Object)this));
        this.icnIzmeniPostojeceOsnovnePodatke.setShortcut("F3");
        this.icnIzmeniPostojeceOsnovnePodatke.setEnabled(imaDozvolu);
        this.icnUpitURadneJedinice = new PzToolBarIcon();
        this.toolbar.add((Component)this.icnUpitURadneJedinice);
        this.icnUpitURadneJedinice.setText("Upit|u stanje|(F2)");
        this.icnUpitURadneJedinice.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_view.png")));
        this.icnUpitURadneJedinice.addActionListener((ActionListener)((Object)this));
        this.icnUpitURadneJedinice.setActionCommand("upit");
        this.icnUpitURadneJedinice.setShortcut("F2");
        if (AnalitikaHelper.getInstance().getHelper() != null) {
            this.icnKarticaArtikla = new PzToolBarIcon();
            this.icnKarticaArtikla.setText("Kartica|artikla|(ALT+F2)");
            this.icnKarticaArtikla.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/address_book2.png")));
            this.icnKarticaArtikla.addActionListener((ActionListener)((Object)this));
            this.icnKarticaArtikla.setActionCommand("kartica");
            this.icnKarticaArtikla.setShortcut("ALT+F2");
            this.toolbar.add((Component)this.icnKarticaArtikla);
        }
        this.icnBrisanjeArtikla = new PzToolBarIcon();
        this.icnBrisanjeArtikla.setVisible(false);
        this.toolbar.add((Component)this.icnBrisanjeArtikla);
        this.icnBrisanjeArtikla.setText("Brisanje|artikla|(DEL)");
        this.icnBrisanjeArtikla.setBounds(58, 42, 107, 16);
        this.icnBrisanjeArtikla.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_delete.png")));
        this.icnBrisanjeArtikla.addActionListener((ActionListener)((Object)this));
        this.icnBrisanjeArtikla.setActionCommand("obrisi");
        this.icnBrisanjeArtikla.setShortcut("delete");
        for (BrowserComponent bc : ComponentRegistry.getInstance().getBrowserComponents()) {
            if (bc.getSwitchIcon() == null) continue;
            this.toolbar.add((Component)bc.getSwitchIcon());
        }
        this.icnLokacije = new PzToolBarIcon();
        this.icnLokacije.setVisible(false);
        this.toolbar.add((Component)this.icnLokacije);
        this.icnLokacije.setText("Lokacije|artikala|(ALT+F11)");
        this.icnLokacije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_signpost.png")));
        this.icnLokacije.addActionListener((ActionListener)((Object)this));
        this.icnLokacije.setActionCommand("lokacije");
        this.icnLokacije.setShortcut("ALT+F11");
        this.icnNaprednaPretraga = new PzToolBarIcon();
        this.toolbar.add((Component)this.icnNaprednaPretraga);
        this.icnNaprednaPretraga.setText("Napredna|pretraga|(ALT+F12)");
        this.icnNaprednaPretraga.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_find.png")));
        this.icnNaprednaPretraga.addActionListener((ActionListener)((Object)this));
        this.icnNaprednaPretraga.setActionCommand("napredna_pretraga");
        this.icnNaprednaPretraga.setShortcut("ALT+F12");
        this.icnPozicioniranjeSifra = new PzToolBarIcon();
        this.icnPozicioniranjeSifra.setIcon((Icon)new ImageIcon(PzArtikliBrowser.class.getResource("/rs/pezar/sifarnici/resource/img/sort_ascending.png")));
        this.icnPozicioniranjeSifra.setText("Pozicioniranje|po \u0161ifri|(ALT+CTRL+S)");
        this.icnPozicioniranjeSifra.setActionCommand("pozicioniranje_sifra");
        this.icnPozicioniranjeSifra.setShortcut("alt+ctrl+s");
        this.icnPozicioniranjeSifra.addActionListener((ActionListener)((Object)this));
        this.toolbar.add((Component)this.icnPozicioniranjeSifra);
        this.icnPozicioniranjeNaziv = new PzToolBarIcon();
        this.icnPozicioniranjeNaziv.setIcon((Icon)new ImageIcon(PzArtikliBrowser.class.getResource("/rs/pezar/sifarnici/resource/img/sort_ascending.png")));
        this.icnPozicioniranjeNaziv.setText("Pozicioniranje|po nazivu|(ALT+N)");
        this.icnPozicioniranjeNaziv.setActionCommand("pozicioniranje_naziv");
        this.icnPozicioniranjeNaziv.setShortcut("alt+N");
        this.icnPozicioniranjeNaziv.addActionListener((ActionListener)((Object)this));
        this.toolbar.add((Component)this.icnPozicioniranjeNaziv);
        if (ProdajaHelper.getInstance().getHelper() != null && this.komitent != null && this.rj != null && (this.rj.getTip().equals("V") || this.rj.getTip().equals("EL") || this.rj.getTip().equals("T"))) {
            this.icnPropustenaProdaja = new PzToolBarIcon();
            this.icnPropustenaProdaja.setText("Propu\u0161tena|prodaja|(CTRL+F12)");
            this.icnPropustenaProdaja.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/shoppingbasket_add.png")));
            this.icnPropustenaProdaja.addActionListener((ActionListener)((Object)this));
            this.icnPropustenaProdaja.setActionCommand("propustena_prodaja");
            this.icnPropustenaProdaja.setShortcut("CTRL+F12");
            this.toolbar.add((Component)this.icnPropustenaProdaja);
        }
        this.icnSifarnik = new PzToolBarIcon();
        this.icnSifarnik.setIcon((Icon)new ImageIcon(PzArtikliBrowser.class.getResource("/rs/pezar/sifarnici/resource/img/product_view.png")));
        this.icnSifarnik.setText("Otvori|\u0161ifarnik|(CTRL+S)");
        this.icnSifarnik.setActionCommand("sifarnik");
        this.icnSifarnik.setShortcut("CTRL+S");
        this.icnSifarnik.addActionListener((ActionListener)((Object)this));
        this.toolbar.add((Component)this.icnSifarnik);
        this.statusBar = new PzStatusBar();
        this.statusBar.setPreferredSize(new Dimension(27, 27));
        this.contentPanel.add((Component)this.statusBar, "South");
        this.lblBrPogodaka = new JLabel("Broj pogodaka: 0");
        this.statusBar.add((Component)this.lblBrPogodaka);
        this.pnlMain = new PzPanel();
        this.pnlMain.setLayout((LayoutManager)new BorderLayout());
        this.pnlMain.setBackground(Color.BLUE);
        this.contentPanel.add((Component)this.pnlMain, "Center");
        this.startupDockFrames();
        this.initPanels();
        this.setSize(1024, 768);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String command = ((PzToolBarIcon)e.getSource()).getActionCommand();
            if (command.equals("upit")) {
                if (this.pnlTable.getSelectedEntity() instanceof Artikal) {
                    Upit.upit((PzDialog)this, (Artikal)this.pnlTable.getSelectedEntity());
                } else {
                    if (this.pnlTable.getSelectedEntity() == null) {
                        return;
                    }
                    Upit.upit((PzDialog)this, (Stanjeartikal)this.pnlTable.getSelectedEntity());
                }
            } else if (command.equals("insert")) {
                if (this.pnlTable.getTable() == null) {
                    return;
                }
                this.getSession().putParameter("update", (Object)false);
                this.getSession().putParameter("INSERTED_ARTIKAL", null);
                this.getSession().putParameter("NOVI_ARTIKAL", (Object)new Artikal());
                this.getSession().putParameter("IZMENA", (Object)false);
                this.getSession().putParameter("dod_rj", (Object)this.rj);
                this.showDialog(DodavanjeExtended.class);
                Artikal art = (Artikal)this.getSession().getParameter("INSERTED_ARTIKAL");
                if (art != null) {
                    Stanjeartikal stanje = (Stanjeartikal)PzEntityManager.find(Stanjeartikal.class, (Object)new StanjeartikalPK(art.getSfrProizvod(), this.rj));
                    this.pnlTable.getTable().insertGUI((PzEntity)stanje);
                }
            } else if (command.equals("izmeni")) {
                if (this.pnlTable.getSelectedEntity() == null) {
                    return;
                }
                this.getSession().putParameter("update", (Object)false);
                this.getSession().putParameter("INSERTED_ARTIKAL", null);
                this.getSession().putParameter("NOVI_ARTIKAL", (Object)PzEntityManager.find(Artikal.class, (Object)((Stanjeartikal)this.pnlTable.getSelectedEntity()).getId().getSfrProizvod()));
                this.getSession().putParameter("IZMENA", (Object)true);
                this.getSession().putParameter("dod_rj", (Object)this.rj);
                this.showDialog(DodavanjeExtended.class);
                Artikal art = (Artikal)this.getSession().getParameter("INSERTED_ARTIKAL");
                if (art != null) {
                    Stanjeartikal stanje = (Stanjeartikal)PzEntityManager.find(Stanjeartikal.class, (Object)new StanjeartikalPK(art.getSfrProizvod(), this.rj));
                    this.pnlTable.getTable().updateSelectedEntityGUI((PzEntity)stanje);
                }
            } else if (command.equals("napredna_pretraga")) {
                String query = null;
                query = this.rj != null ? NaprednaPretraga.getQuery(this, null, 2) : NaprednaPretraga.getQuery(this);
                if (query != null) {
                    this.pnlSearch.search(query, this.rj, null);
                }
            } else if (command.equals("pozicioniranje_naziv") || command.equals("pozicioniranje_sifra")) {
                Class<Artikal> c;
                String sifra;
                if (this.pnlTable.getSelectedEntity() == null) {
                    return;
                }
                if (this.pnlTable.getSelectedEntity() instanceof Stanjeartikal) {
                    this.pnlTable.getTable().getRowSorter().setSortKeys(null);
                    sifra = ((Stanjeartikal)this.pnlTable.getSelectedEntity()).getId().getSfrProizvod();
                    c = Stanjeartikal.class;
                } else {
                    sifra = ((Artikal)this.pnlTable.getSelectedEntity()).getSfrProizvod();
                    c = Artikal.class;
                }
                final String sfr = sifra;
                this.pnlSearch.search(QueryTool.getPozicijaQuery(sifra, c, this.rj, command.equals("pozicioniranje_naziv") ? "naziv" : "sfrSort"), this.rj, new BrowserQueryAction(){

                    @Override
                    public void run() {
                        PzManageableTable table = PzArtikliBrowser.this.pnlTable.getTable();
                        if (table.getRowCount() > 0) {
                            int i = 0;
                            while (i < table.getRowCount()) {
                                if (table.getSelectedEntity() instanceof Artikal && ((Artikal)table.getEntity(i)).getSfrProizvod().equals(sfr) || table.getSelectedEntity() instanceof Stanjeartikal && ((Stanjeartikal)table.getEntity(i)).getId().getSfrProizvod().equals(sfr)) {
                                    table.setRowSelectionInterval(i, i);
                                    table.scrollRowToVisible(i);
                                }
                                ++i;
                            }
                        }
                    }
                });
            } else if (command.equals("kartica")) {
                if (this.pnlTable.getTable() == null || this.pnlTable.getTable().getSelectedEntity() == null) {
                    return;
                }
                if (this.pnlTable.getTable().getSelectedEntity() instanceof Stanjeartikal) {
                    AnalitikaHelper.getInstance().getHelper().karticaArtikla((PzDialog)this, ((Stanjeartikal)this.pnlTable.getTable().getSelectedEntity()).getId().getSfrProizvod(), this.rj.getId().getOznOgranak(), this.rj.getId().getOznRj());
                } else {
                    AnalitikaHelper.getInstance().getHelper().karticaArtikla((PzDialog)this, ((Artikal)this.pnlTable.getTable().getSelectedEntity()).getSfrProizvod(), this.rj.getId().getOznOgranak(), this.rj.getId().getOznRj());
                }
            } else if (command.equals("propustena_prodaja")) {
                Stanjeartikal stArt = (Stanjeartikal)this.pnlTable.getSelectedEntity();
                ProdajaHelper.getInstance().getHelper().propustenaProdaja((PzDialog)this, stArt.getId().getSfrProizvod(), this.komitent.getSfrKomitent(), stArt.getId().getOznRj(), stArt.getId().getOznOgranak());
            } else if (command.equals("sifarnik")) {
                PzDialogArtikliExtended dlg = new PzDialogArtikliExtended(this);
                dlg.setCloseOnEnter(true);
                this.showDialog(dlg);
                if (PzTable.selectedEntity != null) {
                    Artikal a = (Artikal)PzTable.selectedEntity;
                    PzTable.selectedEntity = PzEntityManager.find(Stanjeartikal.class, (Object)new StanjeartikalPK(a.getSfrProizvod(), this.rj));
                    this.dispose();
                    return;
                }
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void initPanels() {
        this.pnlSearch = (BrowserSearchPanel)ComponentRegistry.getInstance().getBrowserComponent("PANEL_SEARCH");
        this.pnlTable = (BrowserTablePanel)ComponentRegistry.getInstance().getBrowserComponent("TABLE_PANEL");
        this.pnlSearch.createEm();
        for (BrowserComponent bc : ComponentRegistry.getInstance().getBrowserComponents()) {
            bc.setBrowser(this);
        }
        this.pnlSearch.setRadnajedinica(this.rj);
        this.pnlSearch.setLabelBrPogodaka(this.lblBrPogodaka);
        this.pnlTable.setRadnajedinica(this.rj);
        this.pnlTable.activateTimer();
        this.pnlTable.setData(Stanjeartikal.class, new ArrayList());
    }

    private void startupDockFrames() {
        ComponentWindowProvider provider = new ComponentWindowProvider((Component)this.pnlMain);
        if (SHARED_CONTROL == null) {
            SHARED_CONTROL = this.control = new CControl((WindowProvider)provider);
            this.control.setTheme("eclipse");
            this.pnlMain.add((Component)this.control.getContentArea());
            this.grid = new CGrid(this.control);
            for (BrowserComponent bc : ComponentRegistry.getInstance().getBrowserComponents()) {
                BrowserComponent.Location l = bc.getComponentLocation();
                this.grid.add((double)l.getX(), (double)l.getY(), (double)l.getWidth(), (double)l.getHeight(), new CDockable[]{bc.getDockable()});
            }
            this.control.getContentArea().deploy(this.grid);
            try {
                File layoutResource = new File(String.valueOf(PzApplication.getApplication().getDataFolder().getAbsolutePath()) + File.separator + ((Object)((Object)this)).getClass().getName() + ".dfl");
                this.control.getResources().readFile(layoutResource);
                this.control.load(((Object)((Object)this)).getClass().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                File f = new File(String.valueOf(PzApplication.getApplication().getDataFolder().getAbsolutePath()) + File.separator + ((Object)((Object)this)).getClass().getName() + ".dfl");
                try {
                    int length;
                    InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/gui/artikli/resources/PzArtikliBrowser.dfl").openStream();
                    FileOutputStream fos = new FileOutputStream(f);
                    byte[] buffer = new byte[4096];
                    while ((length = is.read(buffer)) > 0) {
                        fos.write(buffer, 0, length);
                    }
                    fos.close();
                    is.close();
                    this.control.getResources().readFile(f);
                    this.control.load(((Object)((Object)this)).getClass().getName());
                }
                catch (IOException e1) {
                    PzLogger.getInstance().logException((Throwable)e1);
                }
            }
        } else {
            this.control = SHARED_CONTROL;
            this.pnlMain.add((Component)this.control.getContentArea());
        }
        for (BrowserComponent bc : ComponentRegistry.getInstance().getBrowserComponents()) {
            if (bc.shouldBeShown()) continue;
            bc.getDockable().setVisible(false);
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        this.pnlSearch.saveQuery();
        this.pnlTable.deactivateTimer();
        this.control.save(((Object)((Object)this)).getClass().getName());
        try {
            this.control.getResources().writeFile(new File(String.valueOf(PzApplication.getApplication().getDataFolder().getAbsolutePath()) + File.separator + ((Object)((Object)this)).getClass().getName() + ".dfl"));
            this.pnlSearch.closeEm();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        super.thisWindowClosing(evt);
    }

    public static Stanjeartikal getStanjeArtikal(PzDialog parent, Radnajedinica rj) {
        BROWSER_RJ = rj;
        PzArtikliBrowser dlg = new PzArtikliBrowser(parent);
        dlg.setCloseOnEnter(true);
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setVisible(true);
        BROWSER_RJ = null;
        Stanjeartikal a = (Stanjeartikal)PzTable.selectedEntity;
        PzTable.selectedEntity = null;
        return a;
    }

    private void initServices() {
        this.services = new HashMap();
        this.services.put("RABATNA_POLITIKA_MANAGER", new RabatnaPolitikaManager());
    }

    public Object getService(String serviceId) {
        return this.services.get(serviceId);
    }

    public void setEntity(PzEntity entity, Component component) {
        for (BrowserComponent c : ComponentRegistry.getInstance().getBrowserComponents()) {
            c.setEntity(entity, component);
        }
    }

    private void searchByLast(String sifra) throws Exception {
        final String sfr = sifra;
        this.pnlSearch.search(QueryTool.getPozicijaQuery(sifra, Stanjeartikal.class, this.rj, "sfrSort"), this.rj, new BrowserQueryAction(){

            @Override
            public void run() {
                PzManageableTable table = PzArtikliBrowser.this.pnlTable.getTable();
                if (table.getRowCount() > 0) {
                    int i = 0;
                    while (i < table.getRowCount()) {
                        if (table.getSelectedEntity() instanceof Artikal && ((Artikal)table.getEntity(i)).getSfrProizvod().equals(sfr) || table.getSelectedEntity() instanceof Stanjeartikal && ((Stanjeartikal)table.getEntity(i)).getId().getSfrProizvod().equals(sfr)) {
                            table.setRowSelectionInterval(i, i);
                            table.scrollRowToVisible(i);
                        }
                        ++i;
                    }
                }
            }
        });
    }
}

