/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import rs.pezar.core.gui.pretraga.criteria.Criteria;
import rs.pezar.core.gui.pretraga.criteria.CriteriaComponent;
import rs.pezar.core.gui.pretraga.criteria.CriteriaContainer;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzCheckbox;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;

public class NaprednaPretraga
extends PzDialog {
    private static final long serialVersionUID = -8919579140100081747L;
    private PzPanelHeader header;
    private PzPanel panelContent;
    private PzCheckbox cbStanje;
    private PzPanel pnlRj;
    private PzPanel pnlStanje;
    private CriteriaComponent criteriaPromet;
    private CriteriaContainer containerPromet;
    private CriteriaComponent criteriaStanje;
    private CriteriaContainer containerStanje;
    private JScrollPane scpStanje;
    private JScrollPane scpOpsti;
    private PzButton pzButton1;
    private CriteriaComponent criteriaOpsti;
    private PzTextField nazivKomitenta;
    private JScrollPane scpPromet;
    private PzNumericOnlyTextField sfrKomitent;
    private JLabel lblKomitent;
    private JCheckBox cbPromet;
    private PzPanel pnlPromet;
    private PzTextField nazivRj;
    private JLabel lblRj;
    private PzNumericOnlyTextField oznRj;
    private CriteriaContainer containerOpsti;
    private Radnajedinica rj;
    private int choice;
    private int adCount = 0;
    private Komitent komitent;
    private static String query;
    private static NaprednaPretraga instance;
    public static final int ARTIKAL = 1;
    public static final int STANJEARTIKAL = 2;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                NaprednaPretraga inst = new NaprednaPretraga(frame);
                inst.setVisible(true);
            }
        });
    }

    public NaprednaPretraga() {
        this.initGUI();
    }

    public NaprednaPretraga(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public NaprednaPretraga(PzDialog parent) {
        super(parent);
        this.choice = 1;
        this.initGUI();
    }

    public NaprednaPretraga(PzDialog parent, Radnajedinica rj) {
        super(parent);
        this.choice = 1;
        this.rj = rj;
        this.initGUI();
        if (rj != null) {
            this.oznRj.setVal((Object)rj.getId().getOznRj());
            this.oznRj.setEnabled(false);
        }
    }

    public NaprednaPretraga(PzDialog parent, Radnajedinica rj, int choice) {
        super(parent);
        this.choice = choice;
        this.rj = rj;
        this.initGUI();
        if (rj != null) {
            this.oznRj.setVal((Object)rj.getId().getOznRj());
            this.oznRj.setEnabled(false);
        } else {
            try {
                this.rj = (Radnajedinica)PzEntityManager.selectAll(Radnajedinica.class).get(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Napredna pretraga");
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_find.png")));
            this.header.setTitle("Napredna pretraga artikala");
            this.getContentPane().add((Component)this.header, "North");
            this.panelContent = new PzPanel();
            this.getContentPane().add((Component)this.panelContent, "Center");
            AnchorLayout panelContentLayout = new AnchorLayout();
            this.panelContent.setLayout((LayoutManager)panelContentLayout);
            this.pnlStanje = new PzPanel();
            BorderLayout pnlPrometLayout = new BorderLayout();
            this.pnlStanje.setLayout((LayoutManager)pnlPrometLayout);
            this.panelContent.add((Component)this.pnlStanje, (Object)new AnchorConstraint(19, 995, 907, 502, 1, 1, 1, 1));
            this.pnlStanje.setPreferredSize(new Dimension(647, 533));
            this.pnlStanje.setBorder((Border)BorderFactory.createTitledBorder(null, "Stanje i promet artikla", 4, 0));
            this.pnlRj = new PzPanel();
            this.pnlStanje.add((Component)this.pnlRj, (Object)"North");
            this.pnlRj.setPreferredSize(new Dimension(648, 57));
            this.pnlRj.setLayout(null);
            this.cbStanje = new PzCheckbox();
            this.cbStanje.setEnabled(false);
            this.pnlRj.add((Component)this.cbStanje);
            this.cbStanje.setText("Uklju\u010di stanje");
            this.cbStanje.setBounds(1, 27, 192, 18);
            this.cbStanje.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NaprednaPretraga.this.cbStanjeItemStateChanged(e);
                }
            });
            this.oznRj = new PzNumericOnlyTextField();
            this.pnlRj.add((Component)this.oznRj);
            this.oznRj.setBounds(130, 0, 52, 25);
            this.oznRj.setFKField(Radnajedinica.class, PzDialogRJ.class, true, null);
            this.oznRj.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    try {
                        NaprednaPretraga.this.rj = (Radnajedinica)PzEntityManager.find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", NaprednaPretraga.this.oznRj.getVal()));
                        if (NaprednaPretraga.this.rj != null) {
                            NaprednaPretraga.this.criteriaStanje.setCriterias(NaprednaPretraga.this.getCriteriaStanje(NaprednaPretraga.this.choice));
                            NaprednaPretraga.this.criteriaPromet.setCriterias(NaprednaPretraga.this.getCriteriaPromet(NaprednaPretraga.this.choice));
                            NaprednaPretraga.this.cbStanje.setEnabled(true);
                            NaprednaPretraga.this.cbPromet.setEnabled(true);
                        } else {
                            NaprednaPretraga.this.choice = 1;
                        }
                        return NaprednaPretraga.this.rj;
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)NaprednaPretraga.this.oznRj, (Throwable)e);
                        return null;
                    }
                }
            });
            this.lblRj = new JLabel();
            this.pnlRj.add((Component)this.lblRj);
            this.lblRj.setText("U radnoj jedinici:");
            this.lblRj.setBounds(6, 4, 105, 18);
            this.nazivRj = new PzTextField();
            this.pnlRj.add((Component)this.nazivRj);
            this.nazivRj.setBounds(192, 1, 444, 24);
            this.nazivRj.setEditable(false);
            this.nazivRj.setFocusable(false);
            this.nazivRj.setForeground(new Color(0, 0, 160));
            this.scpStanje = new JScrollPane();
            this.pnlStanje.add((Component)this.scpStanje, (Object)"Center");
            this.scpStanje.setPreferredSize(new Dimension(648, 174));
            this.scpStanje.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.containerStanje = new CriteriaContainer();
            this.scpStanje.setViewportView((Component)this.containerStanje);
            this.criteriaStanje = new CriteriaComponent();
            this.criteriaStanje.setEnabled(false);
            if (this.rj != null) {
                this.criteriaStanje.setCriterias(this.getCriteriaStanje(this.choice));
            }
            this.containerStanje.add(this.criteriaStanje);
            this.pnlPromet = new PzPanel();
            this.pnlStanje.add((Component)this.pnlPromet, (Object)"South");
            this.pnlPromet.setPreferredSize(new Dimension(648, 275));
            this.pnlPromet.setLayout(null);
            this.cbPromet = new JCheckBox();
            this.cbPromet.setEnabled(false);
            this.pnlPromet.add((Component)this.cbPromet, (Object)"North");
            this.cbPromet.setText("Uklju\u010di promet");
            this.cbPromet.setBounds(0, 11, 584, 17);
            this.cbPromet.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    NaprednaPretraga.this.cbPrometItemStateChanged(evt);
                }
            });
            this.lblKomitent = new JLabel();
            this.pnlPromet.add((Component)this.lblKomitent);
            this.lblKomitent.setText("Komitent:");
            this.lblKomitent.setBounds(7, 35, 85, 16);
            this.sfrKomitent = new PzNumericOnlyTextField();
            this.pnlPromet.add((Component)this.sfrKomitent);
            this.sfrKomitent.setBounds(92, 31, 103, 25);
            this.sfrKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, false, null);
            this.sfrKomitent.setEnabled(false);
            this.sfrKomitent.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (NaprednaPretraga.this.sfrKomitent.getVal().equals("0")) {
                        NaprednaPretraga.this.komitent = null;
                        NaprednaPretraga.this.nazivKomitenta.setVal((Object)"");
                    }
                    return true;
                }
            });
            this.scpPromet = new JScrollPane();
            this.pnlPromet.add((Component)this.scpPromet);
            this.scpPromet.setBounds(0, 69, 648, 206);
            this.scpPromet.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.containerPromet = new CriteriaContainer();
            if (this.rj != null) {
                this.criteriaPromet.setCriterias(this.getCriteriaPromet(this.choice));
            }
            this.scpPromet.setViewportView((Component)this.containerPromet);
            this.criteriaPromet = new CriteriaComponent();
            this.containerPromet.add(this.criteriaPromet);
            this.criteriaPromet.setEnabled(false);
            this.nazivKomitenta = new PzTextField();
            this.pnlPromet.add((Component)this.nazivKomitenta);
            this.nazivKomitenta.setBounds(201, 32, 435, 24);
            this.nazivKomitenta.setEditable(false);
            this.nazivKomitenta.setFocusable(false);
            this.scpOpsti = new JScrollPane();
            this.panelContent.add((Component)this.scpOpsti, (Object)new AnchorConstraint(22, 497, 907, 0, 1, 1, 1, 1));
            this.scpOpsti.setPreferredSize(new Dimension(663, 531));
            this.scpOpsti.setBorder(BorderFactory.createTitledBorder("Osnovni podaci"));
            this.containerOpsti = new CriteriaContainer();
            this.scpOpsti.setViewportView((Component)this.containerOpsti);
            this.criteriaOpsti = new CriteriaComponent();
            this.criteriaOpsti.setCriterias(this.getCriteriaOpsti(this.choice));
            this.containerOpsti.add(this.criteriaOpsti);
            this.pzButton1 = new PzButton();
            this.pzButton1.setHorizontalAlignment(10);
            this.pzButton1.setIcon((Icon)new ImageIcon(NaprednaPretraga.class.getResource("/rs/pezar/sifarnici/resource/img/find.png")));
            this.panelContent.add((Component)this.pzButton1, (Object)new AnchorConstraint(925, 991, 982, 845, 1, 1, 1, 1));
            this.pzButton1.setText("   Tra\u017ei");
            this.pzButton1.setPreferredSize(new Dimension(189, 34));
            this.pzButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NaprednaPretraga.this.pzButton1ActionPerformed(evt);
                }
            });
            this.setSize(1343, 702);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Radnajedinica) {
            this.rj = (Radnajedinica)entity;
            ((PzField)component).setVal((Object)((Radnajedinica)entity).getId().getOznRj());
            this.nazivRj.setVal((Object)((Radnajedinica)entity).getNaziv());
            this.cbPromet.setEnabled(true);
            this.cbStanje.setEnabled(true);
        } else if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            ((PzField)component).setVal((Object)((Komitent)entity).getSfrKomitent());
            this.nazivKomitenta.setVal((Object)((Komitent)entity).getNaziv());
        }
    }

    private void pzButton1ActionPerformed(ActionEvent evt) {
        query = this.getQueryString();
        System.out.println(query);
        this.dispose();
    }

    private Object[][] getCriteriasOpsti() {
        return new Object[][]{{"\u0160ifra", "a.sfrProizvod", "a.id.sfrProizvod", 1}, {"Naziv", "a.naziv", "a.naziv", 1}, {"Bli\u017ei opis", "a.bliziOpis", "a.bliziOpis", 1}, {"\u0160ifra dobavlja\u010da", "a.dobavljac.sfrKomitent", "a.sfrDobavljac", 1}, {"Naziv dobavlja\u010da", "a.dobavljac.naziv", "a.nazivDobavljac", 1}, {"\u0160ifra proizvo\u0111a\u010da", "a.proizvodjac.sfrKomitent", "a.sfrProizvodjac", 1}, {"Naziv proizvo\u0111a\u010da", "a.proizvodjac.naziv", "a.nazivProizvodjac", 1}, {"Oznaka modela", "a.model.oznModel", "a.oznModel", 1}, {"Naziv modela", "a.model.naziv", "a.nazivModela", 1}, {"Oznaka robne grupe", "a.robnagrupa.oznRobGr", "a.oznRobGr", 1}, {"Naziv robne grupe", "a.robnagrupa.naziv", "a.nazivRobGr", 1}, {"Proizvo\u0111a\u010deva \u0161ifra", "a.prSifra", "a.prSifra", 1}, {"Katalo\u0161ki broj", "a.dobSifra", "a.dobSifra", 1}, {"Opis", "a.opis", "a.opis", 1}, {"Tip", "a.tip", "a.tip", 1}, {"Jedinica mere", "a.jedMere", "a.jedMere", 1}, {"Te\u017eina", "a.tezina", "a.tezina", 0}, {"\u0160irina", "a.sirina", "a.sirina", 0}, {"Visina", "a.visina", "a.visina", 0}, {"Du\u017eina", "a.duzina", "a.duzina", 0}, {"Fi", "a.fi", "a.fi", 0}};
    }

    private Object[][] getCriteriasStanje() {
        return new Object[][]{{"Raspolo\u017eiva koli\u010dina", "(s.kolicina - s.alocKolicina)", "(a.kolicina - a.alocKolicina)", 0}, {"Ukupna koli\u010dina", "s.kolicina", "a.kolicina", 0}, {"Alocirana koli\u010dina", "s.alocKolicina", "a.alocKolicina", 0}, {"Prodajna cena", "s.prodCena", "a.prodCena", 0}, {"Poslednja nabavna cena", "s.zadNabCena", "a.zadNabCena", 0}, {"Prose\u010dna nabavna cena", "s.prosNabCena", "a.prosNabCena", 0}, {"Po\u010detno stanje", "s.kolPop", "a.kolPop", 0}, {"Cena na po\u010detnom stanju", "s.cenaNaPS", "a.cenaNaPS", 0}, {"Kumulativ ulaza", "s.kumUlaza", "a.kumUlaza", 0}, {"Kumulativ izlaza", "s.kumIzlaza", "a.kumIzlaza", 0}, {"Datum poslednjeg ulaza", "s.datZadUlaza", "a.datZadUlaza", 2}, {"Datum poslednjeg izlaza", "s.datZadIzlaza", "a.datZadIzlaza", 2}};
    }

    private Object[][] getCriteriasPromet() {
        ++this.adCount;
        return new Object[][]{{"Postoji izlaz", "ad<id>.dokument.datum", "ad<id>.dokument.datum", 2, this.getPrometChoices(this.getIzlazString(), "IN")}, {"Ne postoji izlaz", "ad<id>.dokument.datum", "ad<id>.dokument.datum", 2, this.getPrometChoices(this.getIzlazString(), "NOT IN")}, {"Postoji ulaz", "ad<id>.dokument.datum", "ad<id>.dokument.datum", 2, this.getPrometChoices(this.getUlazString(), "IN")}, {"Ne postoji ulaz", "ad<id>.dokument.datum", "ad<id>.dokument.datum", 2, this.getPrometChoices(this.getUlazString(), "NOT IN")}};
    }

    private PzChoice[] getPrometChoices(String ui, String op) {
        return new PzChoice[]{new PzChoice("na datum", (Object)ui.replace("<operation1>", "=").replace("<operation2>", op)), new PzChoice("pre datuma", (Object)ui.replace("<operation1>", "<").replace("<operation2>", op)), new PzChoice("posle datuma", (Object)ui.replace("<operation1>", ">").replace("<operation2>", op)), new PzChoice("nije na datum", (Object)ui.replace("<operation1>", "<>").replace("<operation2>", op))};
    }

    private Criteria[] getCriteriaOpsti(int x) {
        int len = this.getCriteriasOpsti().length;
        Object[][] array = this.getCriteriasOpsti();
        Criteria[] criterias = new Criteria[len];
        int i = 0;
        while (i < len) {
            criterias[i] = new Criteria((String)array[i][x], (String)array[i][0], ((Integer)array[i][3]).intValue());
            ++i;
        }
        return criterias;
    }

    private Criteria[] getCriteriaStanje(int x) {
        int len = this.getCriteriasStanje().length;
        Object[][] array = this.getCriteriasStanje();
        Criteria[] criterias = new Criteria[len];
        int i = 0;
        while (i < len) {
            criterias[i] = array[i].length == 4 ? new Criteria((String)array[i][x], (String)array[i][0], ((Integer)array[i][3]).intValue()) : new Criteria((String)array[i][x], (String)array[i][0], ((Integer)array[i][3]).intValue(), (PzChoice[])array[i][4]);
            ++i;
        }
        return criterias;
    }

    private Criteria[] getCriteriaPromet(int x) {
        int len = this.getCriteriasPromet().length;
        Object[][] array = this.getCriteriasPromet();
        Criteria[] criterias = new Criteria[len];
        int i = 0;
        while (i < len) {
            criterias[i] = array[i].length == 4 ? new Criteria((String)array[i][x], (String)array[i][0], ((Integer)array[i][3]).intValue()) : new Criteria((String)array[i][x], (String)array[i][0], ((Integer)array[i][3]).intValue(), (PzChoice[])array[i][4]);
            ++i;
        }
        return criterias;
    }

    private String getIzlazString() {
        return this.getPrometString(this.choice == 1 ? "a.sfrProizvod" : "a.id.sfrProizvod").replace("<tip>", "I");
    }

    private String getUlazString() {
        return this.getPrometString(this.choice == 1 ? "a.sfrProizvod" : "a.id.sfrProizvod").replace("<tip>", "U");
    }

    private String getPrometString(String sfrProizvod) {
        return " a.id.sfrProizvod <operation2> (SELECT DISTINCT ad<id>.id.sfrProizvod FROM Artikaldokument ad<id> WHERE ad<id>.vrsta='<tip>' AND <field> <operation1> '<value>' AND ad<id>.dokument.radnajedinica.id.oznRj = ':oznRj' AND ad<id>.dokument.radnajedinica.id.oznOgranak = ':oznOgranak' <kom> AND ad<id>.dokument.komitent.sfrKomitent='<sfrKomitent>' <kom>) ".replace(":oznRj", this.rj.getId().getOznRj()).replace(":oznOgranak", this.rj.getId().getOznOgranak()).replace(":sfrProizvod", sfrProizvod).replace("<i>", String.valueOf(this.adCount));
    }

    private String getQueryString() {
        String join = "";
        String rjstr = "";
        if (this.rj != null) {
            if (this.cbStanje.isSelected() && this.choice == 1) {
                join = "LEFT JOIN a.stanjes s";
                rjstr = " AND s.id.oznRj=:oznRj AND s.id.oznOgranak=:oznOgranak".replace(":oznRj", this.rj.getId().getOznRj()).replace(":oznOgranak", this.rj.getId().getOznOgranak());
            } else if (this.choice == 2) {
                rjstr = " AND a.id.oznRj=:oznRj AND a.id.oznOgranak=:oznOgranak".replace(":oznRj", this.rj.getId().getOznRj()).replace(":oznOgranak", this.rj.getId().getOznOgranak());
            }
        }
        String table = this.choice == 1 ? "Artikal" : "Stanjeartikal";
        String qOpsti = !this.containerOpsti.getQuery().equals("") ? "(" + this.containerOpsti.getQuery() + ")" : "";
        String qStanje = this.containerStanje.getQuery();
        String qPromet = this.containerPromet.getQuery();
        if (this.komitent != null && !qPromet.equals("")) {
            qPromet = qPromet.replace("<kom>", "");
            qPromet = qPromet.replace("<sfrKomitent>", this.komitent.getSfrKomitent());
        } else {
            qPromet = qPromet.replaceAll("<kom>.+<kom>", "");
        }
        if ((String.valueOf(qPromet) + qStanje + qOpsti).equals("")) {
            return null;
        }
        String q = "SELECT a FROM " + table + " a " + join + " WHERE " + qOpsti;
        if (this.cbStanje.isSelected()) {
            q = String.valueOf(q) + (qOpsti.equals("") ? "" : " AND ") + qStanje;
        }
        if (this.cbPromet.isSelected()) {
            q = String.valueOf(q) + ((String.valueOf(qOpsti) + qStanje).equals("") ? "" : " AND ") + qPromet;
        }
        return String.valueOf(q) + rjstr;
    }

    public static String getQuery(PzDialog parent) {
        if (instance != null && NaprednaPretraga.instance.choice == 1) {
            instance.setVisible(true);
        } else {
            instance = new NaprednaPretraga(parent);
            parent.setChildDialog((PzDialog)instance);
            instance.setModal(true);
            instance.restoreSize();
            instance.setVisible(true);
        }
        String res = query;
        query = null;
        return res;
    }

    public static String getQuery(PzDialog parent, Radnajedinica rj) {
        if (instance != null && NaprednaPretraga.instance.choice == 1) {
            instance.setVisible(true);
        } else {
            instance = new NaprednaPretraga(parent, rj);
            parent.setChildDialog((PzDialog)instance);
            instance.setModal(true);
            instance.restoreSize();
            instance.setVisible(true);
        }
        String res = query;
        query = null;
        return res;
    }

    public static String getQuery(PzDialog parent, Radnajedinica rj, int choice) {
        if (instance != null && NaprednaPretraga.instance.choice == choice) {
            instance.setVisible(true);
        } else {
            instance = new NaprednaPretraga(parent, rj, choice);
            parent.setChildDialog((PzDialog)instance);
            instance.setModal(true);
            instance.restoreSize();
            instance.setVisible(true);
        }
        String res = query;
        query = null;
        return res;
    }

    private void cbStanjeItemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            this.criteriaStanje.setEnabled(false);
        } else if (this.rj != null) {
            this.criteriaStanje.setEnabled(true);
        }
    }

    private void cbPrometItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            this.sfrKomitent.setEnabled(false);
            this.criteriaPromet.setEnabled(false);
        } else {
            this.sfrKomitent.setEnabled(true);
            this.criteriaPromet.setEnabled(true);
        }
    }
}

