/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Brend;
import rs.pezar.db.entity.OEBroj;
import rs.pezar.db.entity.OEBrojPK;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;

public class OEMBrojeviDodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = -5221318444359002490L;
    private PzButtonPanel btnPanel;
    private JLabel lblProizvodjac;
    private JLabel lblOEM;
    private PzTextField txtProizvodjac;
    private PzTextField txtOEM;
    private PzButton btnNazad;
    private PzButton btnOK;
    private PzPanel pzPanel;
    private PzPanelHeader pnlHeader;
    private Artikal artikal;
    private PzTextField txtProizvodjacNaziv;
    private OEBroj oem;
    private PzFieldIndikator indOEM;
    private PzFieldIndikator indProizvodjac;
    private PzTable table;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                OEMBrojeviDodavanje inst = new OEMBrojeviDodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public OEMBrojeviDodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public OEMBrojeviDodavanje(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog);
        this.artikal = (Artikal)data2;
        this.initGUI();
        this.table = (PzTable)data1;
    }

    protected void initGUI() {
        try {
            this.setTitle("Dodavanje OEM broja artikla");
            this.getContentPane().add((Component)this.getBtnPanel(), "South");
            this.getContentPane().add((Component)this.getPnlHeader(), "North");
            this.getContentPane().add((Component)this.getPzPanel(), "Center");
            this.getTxtOEM().setVerifyInput(true);
            this.getTxtOEM().setStateIndikator(this.indOEM);
            this.getTxtProizvodjac().setStateIndikator(this.indProizvodjac);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        try {
            if (actionCommand.equalsIgnoreCase("nazad")) {
                this.dispose();
                return;
            }
            if (this.oem == null) {
                this.oem = new OEBroj();
                this.oem.setId(new OEBrojPK(this.txtOEM.getText().trim(), this.txtProizvodjac.getText(), this.artikal.getSfrProizvod()));
                this.oem.setArtikal(this.artikal);
                this.oem.setOemStripped(this.txtOEM.getVal().replaceAll("\\W", ""));
                this.table.insert((PzEntity)this.oem, true);
            }
            this.dispose();
            return;
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            return;
        }
    }

    public static Object getGUIBuilderInstance() {
        return new OEMBrojeviDodavanje(Boolean.FALSE);
    }

    public OEMBrojeviDodavanje(Boolean initGUI) {
    }

    private PzButtonPanel getBtnPanel() {
        if (this.btnPanel == null) {
            this.btnPanel = new PzButtonPanel();
            this.btnPanel.add((Component)this.getBtnOK());
            this.btnPanel.add((Component)this.getBtnNazad());
        }
        return this.btnPanel;
    }

    private PzPanelHeader getPnlHeader() {
        if (this.pnlHeader == null) {
            this.pnlHeader = new PzPanelHeader();
        }
        this.pnlHeader.setTitle("Dodavanje OEM broja artikla");
        this.pnlHeader.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_oem.png")));
        return this.pnlHeader;
    }

    private PzPanel getPzPanel() {
        if (this.pzPanel == null) {
            this.pzPanel = new PzPanel();
            GridBagLayout pzPanelLayout = new GridBagLayout();
            pzPanelLayout.rowWeights = new double[]{0.0, 0.0};
            pzPanelLayout.rowHeights = new int[]{26, 26};
            pzPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pzPanelLayout.columnWidths = new int[]{124, 84, 181, 20};
            this.pzPanel.setLayout((LayoutManager)pzPanelLayout);
            this.pzPanel.add((Component)this.getTxtProizvodjac(), (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanel.add((Component)this.getTxtOEM(), (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 10), 0, 0));
            this.pzPanel.add((Component)this.getLblOEM(), (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanel.add((Component)this.getLblProizvodjac(), (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.txtProizvodjacNaziv = new PzTextField();
            this.pzPanel.add((Component)this.txtProizvodjacNaziv, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 10), 0, 0));
            this.txtProizvodjacNaziv.setEditable(false);
            this.txtProizvodjacNaziv.setFocusable(false);
            this.txtProizvodjacNaziv.setSize(200, 24);
            this.txtProizvodjacNaziv.setPreferredSize(new Dimension(5, 24));
            this.indProizvodjac = new PzFieldIndikator();
            this.pzPanel.add((Component)this.indProizvodjac, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.indOEM = new PzFieldIndikator();
            this.pzPanel.add((Component)this.indOEM, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.pzPanel;
    }

    private PzButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new PzButton();
            this.btnOK.setText("Dodaj");
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.btnOK.setActionCommand("dodaj");
        }
        return this.btnOK;
    }

    private PzButton getBtnNazad() {
        if (this.btnNazad == null) {
            this.btnNazad = new PzButton();
            this.btnNazad.setText("Nazad");
            this.btnNazad.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/x.png")));
            this.btnNazad.addActionListener((ActionListener)((Object)this));
            this.btnNazad.setActionCommand("nazad");
        }
        return this.btnNazad;
    }

    private PzTextField getTxtOEM() {
        if (this.txtOEM == null) {
            this.txtOEM = new PzTextField();
            this.txtOEM.setToUpperCase(true);
        }
        return this.txtOEM;
    }

    private PzTextField getTxtProizvodjac() {
        if (this.txtProizvodjac == null) {
            this.txtProizvodjac = new PzTextField();
            this.txtProizvodjac.setPreferredSize(new Dimension(4, 24));
            this.txtProizvodjac.setToUpperCase(true);
        }
        return this.txtProizvodjac;
    }

    private JLabel getLblOEM() {
        if (this.lblOEM == null) {
            this.lblOEM = new JLabel();
            this.lblOEM.setText("OEM broj:");
        }
        return this.lblOEM;
    }

    private JLabel getLblProizvodjac() {
        if (this.lblProizvodjac == null) {
            this.lblProizvodjac = new JLabel();
            this.lblProizvodjac.setText("Proizvo\u0111a\u010d:");
        }
        return this.lblProizvodjac;
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        if (component == this.txtProizvodjac) {
            this.txtProizvodjac.setVal((Object)((Brend)entity).getOznBrend());
            this.txtProizvodjacNaziv.setVal((Object)((Brend)entity).getNaziv());
        }
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }
}

