/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli.browser.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserComponent;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class BrowserAlociranoPanel
extends BrowserComponent {
    private static final long serialVersionUID = 6005674853559487678L;
    public static final String ID = "PANEL_ALOCIRANO";
    private JScrollPane scp;
    private PzTable table;
    private JXLayer<JScrollPane> layer;
    private PzBusyPainterUI layerUI;

    public BrowserAlociranoPanel() {
        this.initGUI();
        this.setComponentLocation(new BrowserComponent.Location(0, 2, 1, 1));
    }

    private void initGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.layerUI = new PzBusyPainterUI();
        this.scp = new JScrollPane();
        this.layer = new JXLayer((Component)this.scp, (LayerUI)this.layerUI);
        this.add((Component)this.layer);
        this.table = new PzTable();
        this.table.setId("TABLE_ALOCIRANO");
        this.table.setEnterAction(null);
        this.table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Artikalfaktura af = (Artikalfaktura)entity;
                return new Object[]{af.getFaktura().getKomitent().getNaziv(), af.getKolicina(), af.getFaktura().getUserKraj().getFullName(), af.getFaktura().getTip()};
            }

            public String[] getColumnNames() {
                return new String[]{"Za kupca", "Koli\u010dina", "Kod korisnika", "Tip dokumenta"};
            }
        });
        this.scp.setViewportView((Component)this.table);
    }

    @Override
    public void updateData(Artikal a, Object parentComponent) {
    }

    @Override
    public void updateData(final Stanjeartikal a, Object parentComponent) {
        if (a == null) {
            return;
        }
        this.layerUI.setLocked(true);
        SwingWorker<List<Artikalfaktura>, Object> worker = new SwingWorker<List<Artikalfaktura>, Object>(){

            @Override
            protected List<Artikalfaktura> doInBackground() throws Exception {
                String query = "SELECT af FROM Artikalfaktura af WHERE af.id.sfrProizvod=:artikal AND ( (af.faktura.tip=:tipFak AND af.faktura.arhiviran = 0 AND af.faktura.zaOtpremnice=0) OR (af.faktura.tip=:tipOtp and af.faktura.arhiviran!=-1 AND (af.faktura.arhiviran=0 OR NOT (af.faktura.zauzeto IS NULL AND af.faktura.fakturaBean IS NOT NULL)))) AND af.faktura.radnajedinica.id.oznRj=:oznRj AND af.faktura.radnajedinica.id.oznOgranak=:oznOgranak AND af.faktura.idDok = af.id.idDok";
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                Query q = em.createQuery(query);
                q.setParameter("tipFak", (Object)"FAKTURA");
                q.setParameter("tipOtp", (Object)"OTPREMNICA");
                q.setParameter("oznRj", (Object)a.getId().getOznRj());
                q.setParameter("oznOgranak", (Object)a.getId().getOznOgranak());
                q.setParameter("artikal", (Object)a.getId().getSfrProizvod());
                List res = q.getResultList();
                em.close();
                return res;
            }

            @Override
            protected void done() {
                try {
                    BrowserAlociranoPanel.this.layerUI.setLocked(false);
                    BrowserAlociranoPanel.this.table.setData((List)this.get(), Artikalfaktura.class);
                    BrowserAlociranoPanel.this.table.packAll();
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)BrowserAlociranoPanel.this), (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    @Override
    public void focusGained() {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getTitle() {
        return "Informacije o alociranim koli\u010dinama";
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public PzToolBarIcon getSwitchIcon() {
        PzToolBarIcon icnZamena = new PzToolBarIcon();
        icnZamena.setText("Info o|alokacijama|(ALT+F3)");
        icnZamena.addActionListener(this.createSwitchActionListener());
        icnZamena.setActionCommand("alocirano");
        icnZamena.setShortcut("alt+f3");
        icnZamena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_alocirano.png")));
        return icnZamena;
    }
}

